/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hsqldb.util.RefCapablePropertyResourceBundle;

public abstract class ValidatingResourceBundle {
    protected boolean validated = false;
    public static final int THROW_BEHAVIOR = 0;
    public static final int EMPTYSTRING_BEHAVIOR = 1;
    public static final int NOOP_BEHAVIOR = 2;
    protected RefCapablePropertyResourceBundle wrappedRCPRB;
    private int missingPropertyBehavior = 0;
    private int missingPosValueBehavior = 0;

    protected abstract Map getKeyIdToString();

    protected ValidatingResourceBundle(String string) {
        this.wrappedRCPRB = RefCapablePropertyResourceBundle.getBundle(string, this.getClass().getClassLoader());
    }

    public String getString(int n2) {
        return this.wrappedRCPRB.getString((String)this.getKeyIdToString().get(new Integer(n2)));
    }

    public String getString(int n2, String[] stringArray) {
        return this.wrappedRCPRB.getString((String)this.getKeyIdToString().get(new Integer(n2)), stringArray, this.missingPosValueBehavior);
    }

    public String getExpandedString(int n2) {
        return this.wrappedRCPRB.getExpandedString((String)this.getKeyIdToString().get(new Integer(n2)), this.missingPropertyBehavior);
    }

    public String getExpandedString(int n2, String[] stringArray) {
        return this.wrappedRCPRB.getExpandedString((String)this.getKeyIdToString().get(new Integer(n2)), stringArray, this.missingPropertyBehavior, this.missingPosValueBehavior);
    }

    public void setMissingPropertyBehavior(int n2) {
        this.missingPropertyBehavior = n2;
    }

    public void setMissingPosValueBehavior(int n2) {
        this.missingPosValueBehavior = n2;
    }

    public int getMissingPropertyBehavior() {
        return this.missingPropertyBehavior;
    }

    public int getMissingPosValueBehavior() {
        return this.missingPosValueBehavior;
    }

    public int getSize() {
        if (!this.validated) {
            throw new RuntimeException("Method SqltoolRB.getSize() may only be called after calling SqltoolRB.validate()");
        }
        return this.getKeyIdToString().size();
    }

    public void validate() {
        if (this.validated) {
            return;
        }
        this.validated = true;
        HashSet hashSet = new HashSet(this.getKeyIdToString().values());
        if (hashSet.size() < this.getKeyIdToString().values().size()) {
            Collection collection = this.getKeyIdToString().values();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                collection.remove(iterator.next());
            }
            throw new RuntimeException("Duplicate property key(s) string in keyIdToString map: " + collection);
        }
        Enumeration enumeration = this.wrappedRCPRB.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.wrappedRCPRB.getString(string);
            hashSet.remove(string);
        }
        if (hashSet.size() > 0) {
            throw new RuntimeException("Resource Bundle pre-validation failed.  Following property key(s) not mapped.\n" + hashSet);
        }
    }

    public String getString(int n2, String string) {
        return this.getString(n2, new String[]{string});
    }

    public String getString(int n2, String string, String string2) {
        return this.getString(n2, new String[]{string, string2});
    }

    public String getString(int n2, String string, String string2, String string3) {
        return this.getString(n2, new String[]{string, string2, string3});
    }

    public String getString(int n2, int n3) {
        return this.getString(n2, new String[]{Integer.toString(n3)});
    }

    public String getString(int n2, int n3, int n4) {
        return this.getString(n2, new String[]{Integer.toString(n3), Integer.toString(n4)});
    }

    public String getString(int n2, int n3, int n4, int n5) {
        return this.getString(n2, new String[]{Integer.toString(n3), Integer.toString(n4), Integer.toString(n5)});
    }

    public String getString(int n2, int n3, String string) {
        return this.getString(n2, new String[]{Integer.toString(n3), string});
    }

    public String getString(int n2, String string, int n3) {
        return this.getString(n2, new String[]{string, Integer.toString(n3)});
    }

    public String getString(int n2, int n3, int n4, String string) {
        return this.getString(n2, new String[]{Integer.toString(n3), Integer.toString(n4), string});
    }

    public String getString(int n2, int n3, String string, int n4) {
        return this.getString(n2, new String[]{Integer.toString(n3), string, Integer.toString(n4)});
    }

    public String getString(int n2, String string, int n3, int n4) {
        return this.getString(n2, new String[]{string, Integer.toString(n3), Integer.toString(n4)});
    }

    public String getString(int n2, int n3, String string, String string2) {
        return this.getString(n2, new String[]{Integer.toString(n3), string, string2});
    }

    public String getString(int n2, String string, String string2, int n3) {
        return this.getString(n2, new String[]{string, string2, Integer.toString(n3)});
    }

    public String getString(int n2, String string, int n3, String string2) {
        return this.getString(n2, new String[]{string, Integer.toString(n3), string2});
    }
}

