/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.util.Vector;

class Grid
extends Panel {
    private Dimension dMinimum;
    protected Font fFont;
    private FontMetrics fMetrics;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iRowHeight;
    private int iFirstRow;
    private int iGridWidth;
    private int iGridHeight;
    private int iX;
    private int iY;
    protected String[] sColHead = new String[0];
    protected Vector vData = new Vector();
    private int[] iColWidth;
    private int iColCount;
    protected int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;
    private boolean bDrag;
    private int iXDrag;
    private int iColDrag;

    public Grid() {
        this.fFont = new Font("Dialog", 0, 12);
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    String[] getHead() {
        return this.sColHead;
    }

    Vector getData() {
        return this.vData;
    }

    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n5 - this.iSbHeight;
        this.iWidth = n4 - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    public void setHead(String[] stringArray) {
        this.iColCount = stringArray.length;
        this.sColHead = new String[this.iColCount];
        this.iColWidth = new int[this.iColCount];
        for (int i2 = 0; i2 < this.iColCount; ++i2) {
            this.sColHead[i2] = stringArray[i2];
            this.iColWidth[i2] = 100;
        }
        this.iRowCount = 0;
        this.iRowHeight = 0;
        this.vData = new Vector();
    }

    public void addRow(String[] stringArray) {
        if (stringArray.length != this.iColCount) {
            return;
        }
        String[] stringArray2 = new String[this.iColCount];
        for (int i2 = 0; i2 < this.iColCount; ++i2) {
            stringArray2[i2] = stringArray[i2];
            if (stringArray2[i2] != null) continue;
            stringArray2[i2] = "(null)";
        }
        this.vData.addElement(stringArray2);
        ++this.iRowCount;
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        int n2;
        if (this.iRowHeight == 0) {
            return;
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.iColCount; ++n2) {
            n3 += this.iColWidth[n2];
        }
        this.iGridWidth = n3;
        this.iGridHeight = this.iRowHeight * (this.iRowCount + 1);
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iGridWidth);
        n2 = this.iY / this.iRowHeight;
        int n4 = this.iHeight / this.iRowHeight;
        this.sbVert.setValues(n2, n4, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = this.iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void paint(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        if (graphics == null) {
            return;
        }
        if (this.sColHead.length == 0) {
            super.paint(graphics);
            return;
        }
        if (this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(SystemColor.control);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(this.fFont);
            if (this.fMetrics == null) {
                this.fMetrics = this.gImage.getFontMetrics();
            }
        }
        if (this.iRowHeight == 0) {
            this.iRowHeight = Grid.getMaxHeight(this.fMetrics);
            for (n4 = 0; n4 < this.iColCount; ++n4) {
                this.calcAutoWidth(n4);
            }
            this.adjustScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.iRowHeight, this.iWidth, this.iRowHeight);
        n4 = -this.iX;
        for (n3 = 0; n3 < this.iColCount; ++n3) {
            n2 = this.iColWidth[n3];
            this.gImage.setColor(SystemColor.control);
            this.gImage.fillRect(n4 + 1, 0, n2 - 2, this.iRowHeight);
            this.gImage.setColor(Color.black);
            this.gImage.drawString(this.sColHead[n3], n4 + 2, this.iRowHeight - 5);
            this.gImage.setColor(Color.darkGray);
            this.gImage.drawLine(n4 + n2 - 1, 0, n4 + n2 - 1, this.iRowHeight - 1);
            this.gImage.setColor(Color.white);
            this.gImage.drawLine(n4 + n2, 0, n4 + n2, this.iRowHeight - 1);
            n4 += n2;
        }
        this.gImage.setColor(SystemColor.control);
        this.gImage.fillRect(0, 0, 1, this.iRowHeight);
        this.gImage.fillRect(n4 + 1, 0, this.iWidth - n4, this.iRowHeight);
        this.gImage.drawLine(0, 0, 0, this.iRowHeight - 1);
        n2 = 0;
        for (n3 = this.iRowHeight + 1 - this.iY; n3 < this.iRowHeight + 1; n3 += this.iRowHeight) {
            ++n2;
        }
        this.iFirstRow = n2;
        for (n3 = this.iRowHeight + 1; n3 < this.iHeight && n2 < this.iRowCount; ++n2, n3 += this.iRowHeight) {
            n4 = -this.iX;
            for (int i2 = 0; i2 < this.iColCount; ++i2) {
                int n5 = this.iColWidth[i2];
                Color color = Color.white;
                Color color2 = Color.black;
                this.gImage.setColor(color);
                this.gImage.fillRect(n4, n3, n5 - 1, this.iRowHeight - 1);
                this.gImage.setColor(color2);
                this.gImage.drawString(this.getDisplay(i2, n2), n4 + 2, n3 + this.iRowHeight - 5);
                this.gImage.setColor(Color.lightGray);
                this.gImage.drawLine(n4 + n5 - 1, n3, n4 + n5 - 1, n3 + this.iRowHeight - 1);
                this.gImage.drawLine(n4, n3 + this.iRowHeight - 1, n4 + n5 - 1, n3 + this.iRowHeight - 1);
                n4 += n5;
            }
            this.gImage.setColor(Color.white);
            this.gImage.fillRect(n4, n3, this.iWidth - n4, this.iRowHeight - 1);
        }
        graphics.drawImage(this.iImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean mouseMove(Event event, int n2, int n3) {
        if (n3 <= this.iRowHeight) {
            int n4;
            int n5 = n2;
            n2 += this.iX - this.iGridWidth;
            for (n4 = this.iColCount - 1; n4 >= 0 && (n2 <= -7 || n2 >= 7); n2 += this.iColWidth[n4], --n4) {
            }
            if (n4 >= 0) {
                if (!this.bDrag) {
                    this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    this.iXDrag = n5 - this.iColWidth[n4];
                    this.iColDrag = n4;
                }
                return true;
            }
        }
        return this.mouseExit(event, n2, n3);
    }

    public boolean mouseDrag(Event event, int n2, int n3) {
        if (this.bDrag && n2 < this.iWidth) {
            int n4 = n2 - this.iXDrag;
            if (n4 < 0) {
                n4 = 0;
            }
            this.iColWidth[this.iColDrag] = n4;
            this.adjustScroll();
            this.repaint();
        }
        return true;
    }

    public boolean mouseExit(Event event, int n2, int n3) {
        if (this.bDrag) {
            this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
        return true;
    }

    public Dimension preferredSize() {
        return this.dMinimum;
    }

    public Dimension getPreferredSize() {
        return this.dMinimum;
    }

    public Dimension getMinimumSize() {
        return this.dMinimum;
    }

    public Dimension minimumSize() {
        return this.dMinimum;
    }

    private void calcAutoWidth(int n2) {
        int n3 = 10;
        n3 = Math.max(n3, this.fMetrics.stringWidth(this.sColHead[n2]));
        for (int i2 = 0; i2 < this.iRowCount; ++i2) {
            String[] stringArray = (String[])this.vData.elementAt(i2);
            n3 = Math.max(n3, this.fMetrics.stringWidth(stringArray[n2]));
        }
        this.iColWidth[n2] = n3 + 6;
    }

    private String getDisplay(int n2, int n3) {
        return ((String[])this.vData.elementAt(n3))[n2];
    }

    private String get(int n2, int n3) {
        return ((String[])this.vData.elementAt(n3))[n2];
    }

    private static int getMaxHeight(FontMetrics fontMetrics) {
        return fontMetrics.getHeight() + 4;
    }
}

