/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.sql.Date;
import org.hsqldb.store.BaseHashMap;

public class ValuePoolHashMap
extends BaseHashMap {
    public ValuePoolHashMap(int n2, int n3, int n4) throws IllegalArgumentException {
        super(n2, 1.0f, 3, 0, true);
        this.maxCapacity = n3;
        this.purgePolicy = n4;
    }

    public void resetCapacity(int n2, int n3) throws IllegalArgumentException {
        if (n2 != 0 && this.hashIndex.elementCount > n2) {
            int n4 = this.hashIndex.elementCount - n2;
            if ((n4 += n4 >> 5) > this.hashIndex.elementCount) {
                n4 = this.hashIndex.elementCount;
            }
            this.clear(n4, n4 >> 6);
        }
        if (n2 != 0 && n2 < this.threshold) {
            this.rehash(n2);
            if (n2 < this.hashIndex.elementCount) {
                n2 = this.maxCapacity;
            }
        }
        this.maxCapacity = n2;
        this.purgePolicy = n3;
    }

    protected Integer getOrAddInteger(int n2) {
        Integer n3;
        int n4 = this.hashIndex.getHashIndex(n2);
        int n5 = this.hashIndex.hashTable[n4];
        int n6 = -1;
        while (n5 >= 0) {
            n3 = (Integer)this.objectKeyTable[n5];
            if (n3 == n2) {
                if (this.accessCount == Integer.MAX_VALUE) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return n3;
            }
            n6 = n5;
            n5 = this.hashIndex.getNextLookup(n5);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(n2);
        }
        n5 = this.hashIndex.linkNode(n4, n6);
        n3 = new Integer(n2);
        this.objectKeyTable[n5] = n3;
        if (this.accessCount == Integer.MAX_VALUE) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return n3;
    }

    protected Long getOrAddLong(long l2) {
        Long l3;
        int n2 = this.hashIndex.getHashIndex((int)(l2 ^ l2 >>> 32));
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            l3 = (Long)this.objectKeyTable[n3];
            if (l3 == l2) {
                if (this.accessCount == Integer.MAX_VALUE) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return l3;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(l2);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        l3 = new Long(l2);
        this.objectKeyTable[n3] = l3;
        if (this.accessCount == Integer.MAX_VALUE) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return l3;
    }

    protected String getOrAddString(Object object) {
        String string;
        int n2 = this.hashIndex.getHashIndex(object.hashCode());
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            string = (String)this.objectKeyTable[n3];
            if (object.equals(string)) {
                if (this.accessCount == Integer.MAX_VALUE) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return string;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(object);
        }
        string = object.toString();
        n3 = this.hashIndex.linkNode(n2, n4);
        this.objectKeyTable[n3] = string;
        if (this.accessCount == Integer.MAX_VALUE) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return string;
    }

    protected Date getOrAddDate(long l2) {
        Date date;
        int n2 = (int)l2 ^ (int)(l2 >>> 32);
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        while (n4 >= 0) {
            date = (Date)this.objectKeyTable[n4];
            if (date.getTime() == l2) {
                if (this.accessCount == Integer.MAX_VALUE) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return date;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(l2);
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        date = new Date(l2);
        this.objectKeyTable[n4] = date;
        if (this.accessCount == Integer.MAX_VALUE) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return date;
    }

    protected Double getOrAddDouble(long l2) {
        Double d2;
        int n2 = this.hashIndex.getHashIndex((int)(l2 ^ l2 >>> 32));
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            d2 = (Double)this.objectKeyTable[n3];
            if (Double.doubleToLongBits(d2) == l2) {
                if (this.accessCount == Integer.MAX_VALUE) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return d2;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(l2);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        d2 = new Double(Double.longBitsToDouble(l2));
        this.objectKeyTable[n3] = d2;
        if (this.accessCount == Integer.MAX_VALUE) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return d2;
    }

    protected Object getOrAddObject(Object object) {
        int n2 = this.hashIndex.getHashIndex(object.hashCode());
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            Object object2 = this.objectKeyTable[n3];
            if (object2.equals(object)) {
                if (this.accessCount == Integer.MAX_VALUE) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return object2;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(object);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        this.objectKeyTable[n3] = object;
        if (this.accessCount == Integer.MAX_VALUE) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return object;
    }
}

