/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.math.BigDecimal;
import java.sql.Date;
import org.hsqldb.store.ValuePoolHashMap;

public class ValuePool {
    static ValuePoolHashMap intPool;
    static ValuePoolHashMap longPool;
    static ValuePoolHashMap doublePool;
    static ValuePoolHashMap bigdecimalPool;
    static ValuePoolHashMap stringPool;
    static ValuePoolHashMap datePool;
    static final int DEFAULT_VALUE_POOL_SIZE = 10000;
    static final int[] defaultPoolLookupSize;
    static final int POOLS_COUNT;
    static final int defaultSizeFactor = 2;
    static final int defaultMaxStringLength = 16;
    static ValuePoolHashMap[] poolList;
    static int maxStringLength;
    static /* synthetic */ Class class$org$hsqldb$store$ValuePool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPool() {
        int[] nArray = defaultPoolLookupSize;
        int n2 = 2;
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            maxStringLength = 16;
            poolList = new ValuePoolHashMap[POOLS_COUNT];
            for (int i2 = 0; i2 < POOLS_COUNT; ++i2) {
                int n3 = nArray[i2];
                ValuePool.poolList[i2] = new ValuePoolHashMap(n3, n3 * n2, 2);
            }
            intPool = poolList[0];
            longPool = poolList[1];
            doublePool = poolList[2];
            bigdecimalPool = poolList[3];
            stringPool = poolList[4];
            datePool = poolList[5];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool(int[] nArray, int n2) {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            for (int i2 = 0; i2 < POOLS_COUNT; ++i2) {
                poolList[i2].resetCapacity(nArray[i2] * n2, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPool() {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            ValuePool.resetPool(defaultPoolLookupSize, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool() {
        Class clazz = class$org$hsqldb$store$ValuePool == null ? (class$org$hsqldb$store$ValuePool = ValuePool.class$("org.hsqldb.store.ValuePool")) : class$org$hsqldb$store$ValuePool;
        synchronized (clazz) {
            for (int i2 = 0; i2 < POOLS_COUNT; ++i2) {
                poolList[i2].clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getInt(int n2) {
        ValuePoolHashMap valuePoolHashMap = intPool;
        synchronized (valuePoolHashMap) {
            return intPool.getOrAddInteger(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getLong(long l2) {
        ValuePoolHashMap valuePoolHashMap = longPool;
        synchronized (valuePoolHashMap) {
            return longPool.getOrAddLong(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getDouble(long l2) {
        ValuePoolHashMap valuePoolHashMap = doublePool;
        synchronized (valuePoolHashMap) {
            return doublePool.getOrAddDouble(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String string) {
        if (string == null || string.length() > maxStringLength) {
            return string;
        }
        ValuePoolHashMap valuePoolHashMap = stringPool;
        synchronized (valuePoolHashMap) {
            return stringPool.getOrAddString(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDate(long l2) {
        ValuePoolHashMap valuePoolHashMap = datePool;
        synchronized (valuePoolHashMap) {
            return datePool.getOrAddDate(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal getBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return bigDecimal;
        }
        ValuePoolHashMap valuePoolHashMap = bigdecimalPool;
        synchronized (valuePoolHashMap) {
            return (BigDecimal)bigdecimalPool.getOrAddObject(bigDecimal);
        }
    }

    public static Boolean getBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultPoolLookupSize = new int[]{10000, 10000, 10000, 10000, 10000, 10000};
        POOLS_COUNT = defaultPoolLookupSize.length;
        ValuePool.initPool();
    }
}

