/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

class HashIndex {
    int[] hashTable;
    int[] linkTable;
    int newNodePointer;
    int elementCount;
    int reclaimedNodePointer = -1;
    boolean fixedSize;

    HashIndex(int n2, int n3, boolean bl) {
        this.reset(n2, n3);
        this.fixedSize = bl;
    }

    void reset(int n2, int n3) {
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n3];
        this.hashTable = nArray;
        this.linkTable = nArray2;
        this.resetTables();
    }

    void resetTables() {
        int n2 = this.hashTable.length;
        int[] nArray = this.hashTable;
        while (--n2 >= 0) {
            nArray[n2] = -1;
        }
        this.newNodePointer = 0;
        this.elementCount = 0;
        this.reclaimedNodePointer = -1;
    }

    void clear() {
        int n2 = this.linkTable.length;
        int[] nArray = this.linkTable;
        while (--n2 >= 0) {
            nArray[n2] = 0;
        }
        this.resetTables();
    }

    int getHashIndex(int n2) {
        return (n2 & Integer.MAX_VALUE) % this.hashTable.length;
    }

    int getLookup(int n2) {
        int n3 = (n2 & Integer.MAX_VALUE) % this.hashTable.length;
        return this.hashTable[n3];
    }

    int getNextLookup(int n2) {
        return this.linkTable[n2];
    }

    int linkNode(int n2, int n3) {
        int n4 = this.reclaimedNodePointer;
        if (n4 == -1) {
            n4 = this.newNodePointer++;
        } else {
            this.reclaimedNodePointer = this.linkTable[n4];
        }
        if (n3 == -1) {
            this.hashTable[n2] = n4;
        } else {
            this.linkTable[n3] = n4;
        }
        this.linkTable[n4] = -1;
        ++this.elementCount;
        return n4;
    }

    void unlinkNode(int n2, int n3, int n4) {
        if (n3 == -1) {
            this.hashTable[n2] = this.linkTable[n4];
        } else {
            this.linkTable[n3] = this.linkTable[n4];
        }
        this.linkTable[n4] = this.reclaimedNodePointer;
        this.reclaimedNodePointer = n4;
        --this.elementCount;
    }

    boolean removeEmptyNode(int n2) {
        boolean bl = false;
        int n3 = -1;
        int n4 = this.reclaimedNodePointer;
        while (n4 >= 0) {
            if (n4 == n2) {
                if (n3 == -1) {
                    this.reclaimedNodePointer = this.linkTable[n2];
                } else {
                    this.linkTable[n3] = this.linkTable[n2];
                }
                bl = true;
                break;
            }
            n3 = n4;
            n4 = this.linkTable[n4];
        }
        if (!bl) {
            return false;
        }
        for (n4 = 0; n4 < this.newNodePointer; ++n4) {
            if (this.linkTable[n4] <= n2) continue;
            int n5 = n4;
            this.linkTable[n5] = this.linkTable[n5] - 1;
        }
        System.arraycopy(this.linkTable, n2 + 1, this.linkTable, n2, this.newNodePointer - n2 - 1);
        this.linkTable[this.newNodePointer - 1] = 0;
        --this.newNodePointer;
        for (n4 = 0; n4 < this.hashTable.length; ++n4) {
            if (this.hashTable[n4] <= n2) continue;
            int n6 = n4;
            this.hashTable[n6] = this.hashTable[n6] - 1;
        }
        return true;
    }
}

