/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.store.ObjectCacheHashMap;

public class TextCache
extends DataFileCache {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    protected String header;
    protected Table table;
    private ObjectCacheHashMap uncommittedCache;
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    static final char LF_CHAR = '\n';
    static final char CR_CHAR = '\r';

    TextCache(Table table, String string) throws HsqlException {
        super(table.database, string);
        this.table = table;
        this.uncommittedCache = new ObjectCacheHashMap(5);
    }

    protected void initParams(Database database, String string) throws HsqlException {
        this.fileName = string;
        this.database = database;
        this.fa = FileUtil.getDefaultInstance();
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(this.fileName, "=", ";", null);
        switch (hsqlProperties.errorCodes.length) {
            case 0: {
                throw Trace.error(75, 172);
            }
            case 1: {
                this.fileName = hsqlProperties.errorKeys[0].trim();
                break;
            }
            default: {
                throw Trace.error(75, 173, hsqlProperties.errorKeys[1]);
            }
        }
        HsqlDatabaseProperties hsqlDatabaseProperties = database.getProperties();
        this.fs = this.translateSep(hsqlProperties.getProperty("fs", hsqlDatabaseProperties.getProperty("textdb.fs", ",")));
        this.vs = this.translateSep(hsqlProperties.getProperty("vs", hsqlDatabaseProperties.getProperty("textdb.vs", this.fs)));
        this.lvs = this.translateSep(hsqlProperties.getProperty("lvs", hsqlDatabaseProperties.getProperty("textdb.lvs", this.fs)));
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Trace.error(75, 174);
        }
        this.ignoreFirst = hsqlProperties.isPropertyTrue("ignore_first", hsqlDatabaseProperties.isPropertyTrue("textdb.ignore_first", false));
        this.isQuoted = hsqlProperties.isPropertyTrue("quoted", hsqlDatabaseProperties.isPropertyTrue("textdb.quoted", true));
        this.isAllQuoted = hsqlProperties.isPropertyTrue("all_quoted", hsqlDatabaseProperties.isPropertyTrue("textdb.all_quoted", false));
        this.stringEncoding = this.translateSep(hsqlProperties.getProperty("encoding", hsqlDatabaseProperties.getProperty("textdb.encoding", "ASCII")));
        int n2 = hsqlProperties.getIntegerProperty("cache_scale", hsqlDatabaseProperties.getIntegerProperty("textdb.cache_scale", 10, 8, 16));
        int n3 = hsqlProperties.getIntegerProperty("cache_size_scale", hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size_scale", 10, 8, 20));
        int n4 = 1 << n2;
        int n5 = 1 << n3;
        this.maxCacheSize = n4 * 3;
        this.maxCacheBytes = this.maxCacheSize * n5;
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    protected void initBuffers() {
        if (this.isQuoted || this.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
            this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
        }
    }

    private String translateSep(String string) {
        return this.translateSep(string, false);
    }

    private String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = 0;
        n2 = string.indexOf(92);
        if (n2 != -1) {
            int n3 = 0;
            char[] cArray = string.toCharArray();
            int n4 = 0;
            int n5 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n5);
            do {
                stringBuffer.append(cArray, n3, n2 - n3);
                n3 = ++n2;
                if (n2 >= n5) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl) {
                    n4 = cArray[n2];
                }
                if (n4 == 110) {
                    stringBuffer.append('\n');
                    ++n3;
                    continue;
                }
                if (n4 == 114) {
                    stringBuffer.append('\r');
                    ++n3;
                    continue;
                }
                if (n4 == 116) {
                    stringBuffer.append('\t');
                    ++n3;
                    continue;
                }
                if (n4 == 92) {
                    stringBuffer.append('\\');
                    ++n3;
                    continue;
                }
                if (n4 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n3, n3 + 4), 16));
                    n3 += 4;
                    continue;
                }
                if (string.startsWith("semi", n2)) {
                    stringBuffer.append(';');
                    n3 += 4;
                    continue;
                }
                if (string.startsWith("space", n2)) {
                    stringBuffer.append(' ');
                    n3 += 5;
                    continue;
                }
                if (string.startsWith("quote", n2)) {
                    stringBuffer.append('\"');
                    n3 += 5;
                    continue;
                }
                if (string.startsWith("apos", n2)) {
                    stringBuffer.append('\'');
                    n3 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n2]);
                ++n3;
            } while ((n2 = string.indexOf(92, n3)) != -1);
            stringBuffer.append(cArray, n3, n5 - n3);
            string = stringBuffer.toString();
        }
        return string;
    }

    public void open(boolean bl) throws HsqlException {
        this.fileFreePosition = 0L;
        try {
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.fileName, bl, 0, null, null);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > Integer.MAX_VALUE) {
                throw new IOException();
            }
            this.initBuffers();
        }
        catch (Exception exception) {
            throw Trace.error(29, 188, new Object[]{this.fileName, exception});
        }
        this.cacheReadonly = bl;
    }

    void reopen() throws HsqlException {
        this.open(this.cacheReadonly);
    }

    public void close(boolean bl) throws HsqlException {
        if (this.dataFile == null) {
            return;
        }
        try {
            this.cache.saveAll();
            boolean bl2 = this.dataFile.length() <= (long)NL.length();
            this.dataFile.close();
            this.dataFile = null;
            if (bl2 && !this.cacheReadonly) {
                FileUtil.getDefaultInstance().delete(this.fileName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 189, new Object[]{this.fileName, exception});
        }
    }

    void purge() throws HsqlException {
        this.uncommittedCache.clear();
        try {
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.getDefaultInstance().delete(this.fileName);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, 190, new Object[]{this.fileName, exception});
        }
    }

    public synchronized void remove(int n2, PersistentStore persistentStore) throws IOException {
        CachedObject cachedObject = (CachedObject)this.uncommittedCache.remove(n2);
        if (cachedObject != null) {
            return;
        }
        cachedObject = this.cache.release(n2);
        this.clearRowImage(cachedObject);
        this.release(n2);
    }

    private void clearRowImage(CachedObject cachedObject) throws IOException {
        int n2 = cachedObject.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
        this.rowOut.reset();
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = this.rowOut.getOutputStream();
        hsqlByteArrayOutputStream.fill(32, n2);
        hsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
        this.dataFile.seek(cachedObject.getPos());
        this.dataFile.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
    }

    public synchronized void removePersistence(int n2, PersistentStore persistentStore) throws IOException {
        CachedObject cachedObject = (CachedObject)this.uncommittedCache.get(n2);
        if (cachedObject != null) {
            return;
        }
        cachedObject = this.cache.get(n2);
        this.clearRowImage(cachedObject);
    }

    protected synchronized RowInputInterface readObject(int n2) throws IOException {
        ByteArray byteArray = new ByteArray(80);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if ((n2 = this.findNextUsedLinePos(n2)) == -1) {
            return null;
        }
        this.dataFile.seek(n2);
        while (!bl) {
            bl4 = false;
            int n3 = this.dataFile.read();
            if (n3 == -1) {
                if (byteArray.length() == 0) {
                    return null;
                }
                bl = true;
                if (bl2 || this.cacheReadonly) break;
                this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                break;
            }
            switch (n3) {
                case 34: {
                    bl4 = true;
                    bl = bl2;
                    bl2 = false;
                    if (!this.isQuoted) break;
                    bl3 = !bl3;
                    break;
                }
                case 13: {
                    bl2 = !bl3;
                    break;
                }
                case 10: {
                    bl = !bl3;
                    break;
                }
                default: {
                    bl4 = true;
                    bl = bl2;
                    bl2 = false;
                }
            }
            byteArray.append(n3);
        }
        if (bl) {
            int n4 = (int)this.dataFile.getFilePointer() - n2;
            if (bl4) {
                --n4;
            }
            ((RowInputText)this.rowIn).setSource(byteArray.toString(), n2, n4);
            return this.rowIn;
        }
        return null;
    }

    public int readHeaderLine() throws HsqlException {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ByteArray byteArray = new ByteArray(80);
        while (!bl) {
            bl3 = false;
            try {
                n2 = this.dataFile.read();
                if (n2 == -1) {
                    if (byteArray.length() == 0) {
                        return 0;
                    }
                    bl = true;
                    if (this.cacheReadonly) break;
                    this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                    break;
                }
            }
            catch (IOException iOException) {
                throw Trace.error(76);
            }
            switch (n2) {
                case 13: {
                    bl2 = true;
                    break;
                }
                case 10: {
                    bl = true;
                    break;
                }
                default: {
                    bl3 = true;
                    bl = bl2;
                    bl2 = false;
                }
            }
            byteArray.append(n2);
        }
        this.header = byteArray.toString();
        try {
            n2 = (int)this.dataFile.getFilePointer();
            if (bl3) {
                --n2;
            }
            return n2;
        }
        catch (IOException iOException) {
            throw Trace.error(76);
        }
    }

    int findNextUsedLinePos(int n2) throws IOException {
        int n3 = n2;
        int n4 = n2;
        boolean bl = false;
        this.dataFile.seek(n2);
        block6: while (true) {
            int n5 = this.dataFile.read();
            ++n4;
            switch (n5) {
                case 13: {
                    bl = true;
                    continue block6;
                }
                case 10: {
                    bl = false;
                    ((RowInputText)this.rowIn).skippedLine();
                    n3 = n4;
                    continue block6;
                }
                case 32: {
                    if (!bl) continue block6;
                    bl = false;
                    ((RowInputText)this.rowIn).skippedLine();
                    continue block6;
                }
                case -1: {
                    return -1;
                }
            }
            break;
        }
        return n3;
    }

    public synchronized void add(CachedObject cachedObject) throws IOException {
        super.add(cachedObject);
        this.clearRowImage(cachedObject);
    }

    public synchronized CachedObject get(int n2, PersistentStore persistentStore, boolean bl) throws HsqlException {
        if (n2 < 0) {
            return null;
        }
        CachedObject cachedObject = (CachedObject)this.uncommittedCache.get(n2);
        if (cachedObject == null) {
            cachedObject = super.get(n2, persistentStore, bl);
        }
        return cachedObject;
    }

    protected synchronized void saveRows(CachedObject[] cachedObjectArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return;
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            CachedObject cachedObject = cachedObjectArray[i2];
            this.uncommittedCache.put(cachedObject.getPos(), cachedObject);
            cachedObjectArray[i2] = null;
        }
    }

    public synchronized void saveRow(CachedObject cachedObject) throws IOException {
        this.uncommittedCache.remove(cachedObject.getPos());
        super.saveRow(cachedObject);
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String string) throws HsqlException {
        if (this.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(string);
                this.header = string;
            }
            catch (IOException iOException) {
                throw new HsqlException(iOException, Trace.getMessage(98), 98);
            }
            return;
        }
        throw Trace.error(150);
    }

    private void writeHeader(String string) throws IOException {
        byte[] byArray = null;
        String string2 = string + NL;
        try {
            byArray = string2.getBytes(this.stringEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string2.getBytes();
        }
        this.dataFile.write(byArray, 0, byArray.length);
        this.fileFreePosition = byArray.length;
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    protected void setFileModified() throws IOException {
        this.fileModified = true;
    }

    private class ByteArray {
        private byte[] buffer;
        private int buflen;

        public ByteArray(int n2) {
            this.buffer = new byte[n2];
            this.buflen = 0;
        }

        public void append(int n2) {
            if (this.buflen >= this.buffer.length) {
                byte[] byArray = new byte[this.buflen + 80];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buflen);
                this.buffer = byArray;
            }
            this.buffer[this.buflen] = (byte)n2;
            ++this.buflen;
        }

        public int length() {
            return this.buflen;
        }

        public void setLength(int n2) {
            this.buflen = n2;
        }

        public String toString() {
            try {
                return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.buffer, 0, this.buflen);
            }
        }
    }
}

