/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.persist.ScaledRAInterface;

class ScaledRAFileNIO
implements ScaledRAInterface {
    private final boolean readOnly;
    private final long bufferLength;
    private RandomAccessFile file;
    private MappedByteBuffer buffer;
    private FileChannel channel;
    private boolean bufferModified;
    private SimpleLog appLog;
    private static final String JVM_ERROR = "JVM threw unsupported Exception";

    ScaledRAFileNIO(Database database, String string, boolean bl, int n2) throws Throwable {
        block17: {
            long l2;
            if (n2 < 262144) {
                n2 = 262144;
            }
            this.file = new RandomAccessFile(string, bl ? "r" : "rw");
            try {
                l2 = this.file.length();
            }
            catch (Throwable throwable) {
                this.file.close();
                throw throwable;
            }
            if (l2 > 0x10000000L) {
                this.file.close();
                throw new IOException("length exceeds nio limit");
            }
            if ((long)n2 < l2) {
                n2 = (int)l2;
            }
            n2 = ScaledRAFileNIO.newNIOBufferSize(n2);
            if (bl) {
                n2 = (int)l2;
            }
            if (l2 < (long)n2) {
                try {
                    this.file.seek(n2 - 1);
                    this.file.writeByte(0);
                    this.file.getFD().sync();
                    this.file.close();
                    this.file = new RandomAccessFile(string, bl ? "r" : "rw");
                }
                catch (Throwable throwable) {
                    this.file.close();
                    throw throwable;
                }
            }
            this.appLog = database.logger.appLog;
            this.readOnly = bl;
            this.bufferLength = n2;
            this.channel = this.file.getChannel();
            try {
                this.buffer = this.channel.map(bl ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, n2);
                Trace.printSystemOut("NIO file instance created. mode: " + bl);
                if (bl) break block17;
                long l3 = (long)n2 - l2;
                if (l3 > 262144L) {
                    l3 = 262144L;
                }
                byte[] byArray = new byte[(int)l3];
                try {
                    long l4;
                    for (l4 = l2; l4 < (long)n2 - l3; l4 += l3) {
                        this.buffer.position((int)l4);
                        this.buffer.put(byArray, 0, byArray.length);
                    }
                    this.buffer.position((int)l4);
                    this.buffer.put(byArray, 0, (int)((long)n2 - l4));
                    this.buffer.force();
                }
                catch (Throwable throwable) {
                    this.appLog.logContext(throwable, "JVM threw unsupported Exception length: " + n2);
                }
                this.buffer.position(0);
            }
            catch (Throwable throwable) {
                Trace.printSystemOut("NIO constructor failed:  " + n2);
                this.buffer = null;
                this.channel = null;
                this.file.close();
                System.gc();
                throw throwable;
            }
        }
    }

    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            this.appLog.logContext(iOException, "nio");
            throw iOException;
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public void seek(long l2) throws IOException {
        try {
            this.buffer.position((int)l2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.appLog.logContext(illegalArgumentException, "nio");
            throw new IOException(illegalArgumentException.toString());
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public long getFilePointer() throws IOException {
        try {
            return this.buffer.position();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public int read() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public void read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.buffer.get(byArray, n2, n3);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.put(byArray, n2, n3);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public void writeInt(int n2) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putInt(n2);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public void writeLong(long l2) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putLong(l2);
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, JVM_ERROR);
            throw new IOException(throwable.toString());
        }
    }

    public void close() throws IOException {
        try {
            Trace.printSystemOut("NIO close() start - fileLength = " + this.bufferLength);
            if (this.buffer != null && this.bufferModified) {
                try {
                    this.buffer.force();
                }
                catch (Throwable throwable) {
                    try {
                        this.buffer.force();
                    }
                    catch (Throwable throwable2) {
                        this.appLog.logContext(throwable, "JVM threw unsupported Exception length: " + this.bufferLength);
                    }
                }
            }
            this.buffer = null;
            this.channel = null;
            this.file.close();
            System.gc();
        }
        catch (Throwable throwable) {
            this.appLog.logContext(throwable, "length: " + this.bufferLength);
            throw new IOException(throwable.toString());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return true;
    }

    public boolean canAccess(int n2) {
        return (long)(this.buffer.position() + n2) <= this.bufferLength;
    }

    public boolean canSeek(long l2) {
        return l2 <= this.bufferLength;
    }

    public Database getDatabase() {
        return null;
    }

    static int newNIOBufferSize(int n2) {
        int n3 = 0;
        for (int i2 = 20; i2 < 30 && (n3 = 1 << i2) < n2; ++i2) {
        }
        return n3;
    }
}

