/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.persist.ScaledRAInterface;

class ScaledRAFileInJar
implements ScaledRAInterface {
    DataInputStream file;
    final String fileName;
    long fileLength;
    boolean bufferDirty = true;
    byte[] buffer = new byte[4096];
    HsqlByteArrayInputStream ba = new HsqlByteArrayInputStream(this.buffer);
    long bufferOffset;
    long seekPosition;
    long realPosition;

    ScaledRAFileInJar(String string) throws FileNotFoundException, IOException {
        this.fileName = string;
        this.resetStream();
        this.file.skip(12L);
        this.fileLength = this.file.readLong();
        this.resetStream();
    }

    public long length() throws IOException {
        return this.fileLength;
    }

    public void seek(long l2) throws IOException {
        this.seekPosition = l2;
    }

    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l2 = this.seekPosition;
        this.bufferDirty = false;
        long l3 = l2 % (long)this.buffer.length;
        long l4 = this.fileLength - (l2 - l3);
        if (l4 <= 0L) {
            throw new IOException("read beyond end of file");
        }
        if (l4 > (long)this.buffer.length) {
            l4 = this.buffer.length;
        }
        this.fileSeek(l2 - l3);
        this.file.readFully(this.buffer, 0, (int)l4);
        this.bufferOffset = l2 - l3;
        this.realPosition = this.bufferOffset + l4;
    }

    public int read() throws IOException {
        if (this.seekPosition >= this.fileLength) {
            return -1;
        }
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n2 = this.ba.read();
        ++this.seekPosition;
        return n2;
    }

    public long readLong() throws IOException {
        long l2 = this.readInt();
        long l3 = this.readInt();
        return (l2 << 32) + (l3 & 0xFFFFFFFFL);
    }

    public int readInt() throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n2 = this.ba.readInt();
        this.seekPosition += 4L;
        return n2;
    }

    public void read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        }
        this.ba.reset();
        this.ba.skip(this.seekPosition - this.bufferOffset);
        int n4 = this.ba.read(byArray, n2, n3);
        this.seekPosition += (long)n4;
        if (n4 < n3) {
            if (this.seekPosition != this.realPosition) {
                this.fileSeek(this.seekPosition);
            }
            this.file.readFully(byArray, n2 + n4, n3 - n4);
            this.seekPosition += (long)(n3 - n4);
            this.realPosition = this.seekPosition;
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
    }

    public void writeInt(int n2) throws IOException {
    }

    public void writeLong(long l2) throws IOException {
    }

    public void close() throws IOException {
        this.file.close();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean wasNio() {
        return false;
    }

    private void resetStream() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        InputStream inputStream = this.getClass().getResourceAsStream(this.fileName);
        this.file = new DataInputStream(inputStream);
    }

    private void fileSeek(long l2) throws IOException {
        long l3 = this.realPosition;
        if (l2 < l3) {
            this.resetStream();
            l3 = 0L;
        }
        while (l2 > l3) {
            l3 += this.file.skip(l2 - l3);
        }
    }

    public boolean canAccess(int n2) {
        return false;
    }

    public boolean canSeek(long l2) {
        return false;
    }

    public Database getDatabase() {
        return null;
    }
}

