/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String filename;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.cache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.filename = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void process() throws HsqlException, IOException {
        Storage storage;
        boolean bl;
        block14: {
            bl = false;
            Trace.printSystemOut("Defrag Transfer begins");
            this.transactionRowLookup = this.database.txManager.getTransactionIDList();
            HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
            this.rootsList = new int[hsqlArrayList.size()][];
            storage = null;
            try {
                try {
                    Object object;
                    int n2;
                    OutputStream outputStream = this.database.getFileAccess().openOutputStreamElement(this.filename + ".new");
                    this.fileStreamOut = new BufferedOutputStream(outputStream, 4096);
                    for (n2 = 0; n2 < 32; ++n2) {
                        this.fileStreamOut.write(0);
                    }
                    this.fileOffset = 32L;
                    int n3 = hsqlArrayList.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        object = (Table)hsqlArrayList.get(n2);
                        if (((Table)object).getTableType() == 4) {
                            int[] nArray = this.writeTableToDataFile((Table)object);
                            this.rootsList[n2] = nArray;
                        } else {
                            this.rootsList[n2] = null;
                        }
                        Trace.printSystemOut(((Table)object).getName().name + " complete");
                    }
                    this.writeTransactionRows();
                    this.fileStreamOut.flush();
                    this.fileStreamOut.close();
                    this.fileStreamOut = null;
                    storage = ScaledRAFile.newScaledRAFile(this.database, this.filename + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
                    storage.seek(12L);
                    storage.writeLong(this.fileOffset);
                    storage.close();
                    storage = null;
                    n3 = this.rootsList.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object = this.rootsList[n2];
                        if (object == null) continue;
                        Trace.printSystemOut(StringUtil.getList((int[])object, ",", ""));
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    throw Trace.error(29, this.filename + ".new");
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw Trace.error(72);
                }
                Object var10_11 = null;
                if (this.fileStreamOut == null) break block14;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (this.fileStreamOut != null) {
                    this.fileStreamOut.close();
                }
                if (storage != null) {
                    storage.close();
                }
                if (bl) throw throwable;
                this.database.getFileAccess().removeElement(this.filename + ".new");
                throw throwable;
            }
            this.fileStreamOut.close();
        }
        if (storage != null) {
            storage.close();
        }
        if (bl) return;
        this.database.getFileAccess().removeElement(this.filename + ".new");
    }

    void updateTableIndexRoots() throws HsqlException {
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        int n2 = hsqlArrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Table table = (Table)hsqlArrayList.get(i2);
            if (table.getTableType() != 4) continue;
            int[] nArray = this.rootsList[i2];
            table.setIndexRoots(nArray);
        }
    }

    void updateTransactionRowIDs() throws HsqlException {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(), false);
        int[] nArray = table.getIndexRootsArray();
        long l2 = this.fileOffset;
        int n2 = 0;
        doubleIntIndex.setKeysSearchTarget();
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIterator(session);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            doubleIntIndex.addUnsorted(row.getPos(), (int)(l2 / (long)this.scale));
            if (n2 % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n2 + " " + row.getPos() + " " + l2);
            }
            l2 += (long)row.getStorageSize();
            ++n2;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n2 = 0;
        rowIterator = table.rowIterator(session);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            rowOutputBinary.reset();
            row.write(rowOutputBinary, doubleIntIndex);
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.fileOffset += (long)row.getStorageSize();
            if (n2 % 50000 == 0) {
                Trace.printSystemOut(n2 + " rows " + this.stopw.elapsedTime());
            }
            ++n2;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == -1) continue;
            int n3 = doubleIntIndex.findFirstEqualKeyIndex(nArray[i2]);
            if (n3 == -1) {
                throw Trace.error(129);
            }
            nArray[i2] = doubleIntIndex.getValue(n3);
        }
        this.setTransactionRowLookups(doubleIntIndex);
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }

    void setTransactionRowLookups(DoubleIntIndex doubleIntIndex) {
        int n2 = this.transactionRowLookup.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.transactionRowLookup.getKey(i2);
            int n4 = doubleIntIndex.findFirstEqualKeyIndex(n3);
            if (n4 == -1) continue;
            this.transactionRowLookup.setValue(i2, doubleIntIndex.getValue(n4));
        }
    }

    void writeTransactionRows() {
        int n2 = this.transactionRowLookup.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.transactionRowLookup.getValue(i2) != 0) continue;
            int n3 = this.transactionRowLookup.getKey(i2);
            try {
                this.transactionRowLookup.setValue(i2, (int)(this.fileOffset / (long)this.scale));
                RowInputInterface rowInputInterface = this.cache.readObject(n3);
                this.fileStreamOut.write(rowInputInterface.getBuffer(), 0, rowInputInterface.getSize());
                this.fileOffset += (long)rowInputInterface.getSize();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

