/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Trace;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.store.ObjectCacheHashMap;

public class Cache {
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private CachedObject[] rowTable;
    private final ObjectCacheHashMap cacheMap;
    long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch makeRowTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int makeRowCount = 0;
    int saveRowCount = 0;

    Cache(DataFileCache dataFileCache) {
        this.dataFileCache = dataFileCache;
        this.capacity = dataFileCache.capacity();
        this.bytesCapacity = dataFileCache.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheMap = new ObjectCacheHashMap(this.capacity);
        this.cacheBytesLength = 0L;
    }

    void init(int n2, long l2) {
    }

    int size() {
        return this.cacheMap.size();
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    synchronized CachedObject get(int n2) {
        return (CachedObject)this.cacheMap.get(n2);
    }

    synchronized void put(int n2, CachedObject cachedObject) throws IOException {
        int n3 = cachedObject.getStorageSize();
        if (this.cacheMap.size() >= this.capacity || (long)n3 + this.cacheBytesLength > this.bytesCapacity) {
            this.cleanUp();
        }
        this.cacheMap.put(n2, cachedObject);
        this.cacheBytesLength += (long)n3;
    }

    synchronized CachedObject release(int n2) {
        CachedObject cachedObject = (CachedObject)this.cacheMap.remove(n2);
        if (cachedObject == null) {
            return null;
        }
        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        return cachedObject;
    }

    private synchronized void cleanUp() throws IOException {
        int n2 = this.cacheMap.size() / 2;
        int n3 = this.cacheMap.getAccessCountCeiling(n2, n2 / 8);
        ObjectCacheHashMap.ObjectCacheIterator objectCacheIterator = this.cacheMap.iterator();
        int n4 = 0;
        while (objectCacheIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)objectCacheIterator.next();
            if (objectCacheIterator.getAccessCount() > n3 || cachedObject.isKeepInMemory()) continue;
            if (cachedObject.hasChanged()) {
                this.rowTable[n4++] = cachedObject;
            }
            objectCacheIterator.remove();
            this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        }
        this.cacheMap.setAccessCountFloor(n3);
        this.saveRows(n4);
    }

    private synchronized void saveRows(int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.rowComparator.setType(1);
        this.sortTimer.start();
        Sort.sort(this.rowTable, this.rowComparator, 0, n2 - 1);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        this.dataFileCache.saveRows(this.rowTable, 0, n2);
        this.saveRowCount += n2;
        this.saveAllTimer.stop();
    }

    synchronized void saveAll() throws IOException {
        ObjectCacheHashMap.ObjectCacheIterator objectCacheIterator = this.cacheMap.iterator();
        int n2 = 0;
        while (objectCacheIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)objectCacheIterator.next();
            if (!cachedObject.hasChanged()) continue;
            this.rowTable[n2++] = cachedObject;
        }
        this.saveRows(n2);
        Trace.printSystemOut(this.saveAllTimer.elapsedTimeToMessage("Cache.saveRow() total row save time"));
        Trace.printSystemOut("Cache.saveRow() total row save count = " + this.saveRowCount);
        Trace.printSystemOut(this.makeRowTimer.elapsedTimeToMessage("Cache.makeRow() total row load time"));
        Trace.printSystemOut("Cache.makeRow() total row load count = " + this.makeRowCount);
        Trace.printSystemOut(this.sortTimer.elapsedTimeToMessage("Cache.sort() total time"));
    }

    synchronized void clear() {
        this.cacheMap.clear();
        this.cacheBytesLength = 0L;
    }

    static class CachedObjectComparator
    implements ObjectComparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType;

        CachedObjectComparator() {
        }

        void setType(int n2) {
            this.compareType = n2;
        }

        public int compare(Object object, Object object2) {
            switch (this.compareType) {
                case 1: {
                    return ((CachedObject)object).getPos() - ((CachedObject)object2).getPos();
                }
                case 2: {
                    return ((CachedObject)object).getStorageSize() - ((CachedObject)object2).getStorageSize();
                }
            }
            return 0;
        }
    }
}

