/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;

public class StringConverter {
    private static final byte[] HEXBYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

    byte[] stringToFullByteArray(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2 * 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            byArray[i2 * 2] = (byte)((c2 & 0xFF00) >> 8);
            byArray[i2 * 2 + 1] = (byte)(c2 & 0xFF);
        }
        return byArray;
    }

    public static byte[] hexToByte(String string) throws IOException {
        int n2 = string.length() / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        if (string.length() % 2 != 0) {
            throw new IOException("hexadecimal string with odd number of characters");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            int n4;
            if ((n4 = HEXINDEX.indexOf(c2 = string.charAt(n3++))) == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            int n5 = (n4 & 0xF) << 4;
            c2 = string.charAt(n3++);
            n4 = HEXINDEX.indexOf(c2);
            byArray[i2] = (byte)(n5 += n4 & 0xF);
        }
        return byArray;
    }

    public static String byteToHex(byte[] byArray) {
        int n2 = byArray.length;
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            cArray[n3++] = (char)HEXBYTES[n4 >> 4 & 0xF];
            cArray[n3++] = (char)HEXBYTES[n4 & 0xF];
        }
        return new String(cArray);
    }

    public static void writeHex(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = byArray2.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = byArray2[i2] & 0xFF;
            byArray[n2++] = HEXBYTES[n4 >> 4 & 0xF];
            byArray[n2++] = HEXBYTES[n4 & 0xF];
        }
    }

    public static String byteToString(byte[] byArray, String string) {
        try {
            return string == null ? new String(byArray) : new String(byArray, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String unicodeToHexString(String string) {
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
        StringConverter.writeUTF(string, hsqlByteArrayOutputStream);
        return StringConverter.byteToHex(hsqlByteArrayOutputStream.toByteArray());
    }

    public static int unicodeToAscii(HsqlByteArrayOutputStream hsqlByteArrayOutputStream, String string, boolean bl) {
        int n2 = 0;
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                if (i2 < n3 - 1 && string.charAt(i2 + 1) == 'u') {
                    hsqlByteArrayOutputStream.write(c2);
                    hsqlByteArrayOutputStream.write(117);
                    hsqlByteArrayOutputStream.write(48);
                    hsqlByteArrayOutputStream.write(48);
                    hsqlByteArrayOutputStream.write(53);
                    hsqlByteArrayOutputStream.write(99);
                    n2 += 6;
                    continue;
                }
                hsqlByteArrayOutputStream.write(c2);
                ++n2;
                continue;
            }
            if (c2 >= ' ' && c2 <= '\u007f') {
                hsqlByteArrayOutputStream.write(c2);
                ++n2;
                if (c2 != '\'' || !bl) continue;
                hsqlByteArrayOutputStream.write(c2);
                ++n2;
                continue;
            }
            hsqlByteArrayOutputStream.write(92);
            hsqlByteArrayOutputStream.write(117);
            hsqlByteArrayOutputStream.write(HEXBYTES[c2 >> 12 & 0xF]);
            hsqlByteArrayOutputStream.write(HEXBYTES[c2 >> 8 & 0xF]);
            hsqlByteArrayOutputStream.write(HEXBYTES[c2 >> 4 & 0xF]);
            hsqlByteArrayOutputStream.write(HEXBYTES[c2 & 0xF]);
            n2 += 6;
        }
        return n2;
    }

    public static String asciiToUnicode(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return "";
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = byArray[n2 + i2];
            if (by == 92 && i2 < n3 - 5) {
                byte by2 = byArray[n2 + i2 + 1];
                if (by2 == 117) {
                    ++i2;
                    int n5 = HEXINDEX.indexOf(byArray[n2 + ++i2]) << 12;
                    n5 += HEXINDEX.indexOf(byArray[n2 + ++i2]) << 8;
                    n5 += HEXINDEX.indexOf(byArray[n2 + ++i2]) << 4;
                    cArray[n4++] = (char)(n5 += HEXINDEX.indexOf(byArray[n2 + ++i2]));
                    continue;
                }
                cArray[n4++] = (char)by;
                continue;
            }
            cArray[n4++] = (char)by;
        }
        return new String(cArray, 0, n4);
    }

    public static String asciiToUnicode(String string) {
        if (string == null || string.indexOf("\\u") == -1) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\' && i2 < n2 - 5) {
                char c3 = string.charAt(i2 + 1);
                if (c3 == 'u') {
                    ++i2;
                    int n4 = HEXINDEX.indexOf(string.charAt(++i2)) << 12;
                    n4 += HEXINDEX.indexOf(string.charAt(++i2)) << 8;
                    n4 += HEXINDEX.indexOf(string.charAt(++i2)) << 4;
                    cArray[n3++] = (char)(n4 += HEXINDEX.indexOf(string.charAt(++i2)));
                    continue;
                }
                cArray[n3++] = c2;
                continue;
            }
            cArray[n3++] = c2;
        }
        return new String(cArray, 0, n3);
    }

    public static String readUTF(byte[] byArray, int n2, int n3) throws IOException {
        char[] cArray = new char[n3];
        return StringConverter.readUTF(byArray, n2, n3, cArray);
    }

    public static String readUTF(byte[] byArray, int n2, int n3, char[] cArray) throws IOException {
        int n4 = 0;
        int n5 = 0;
        block4: while (n5 < n3) {
            int n6 = byArray[n2 + n5];
            if (n4 == cArray.length) {
                cArray = (char[])ArrayUtil.resizeArray(cArray, n3);
            }
            if (n6 > 0) {
                ++n5;
                cArray[n4++] = (char)n6;
                continue;
            }
            switch ((n6 &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((n5 += 2) > n3) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 + n5 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n4++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
                case 14: {
                    if ((n5 += 3) > n3) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 + n5 - 2];
                    byte by2 = byArray[n2 + n5 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n4++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block4;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n4);
    }

    public static int writeUTF(String string, HsqlByteArrayOutputStream hsqlByteArrayOutputStream) {
        int n2 = string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                hsqlByteArrayOutputStream.write(c2);
                ++n3;
                continue;
            }
            if (c2 > '\u07ff') {
                hsqlByteArrayOutputStream.write(0xE0 | c2 >> 12 & 0xF);
                hsqlByteArrayOutputStream.write(0x80 | c2 >> 6 & 0x3F);
                hsqlByteArrayOutputStream.write(0x80 | c2 >> 0 & 0x3F);
                n3 += 3;
                continue;
            }
            hsqlByteArrayOutputStream.write(0xC0 | c2 >> 6 & 0x1F);
            hsqlByteArrayOutputStream.write(0x80 | c2 >> 0 & 0x3F);
            n3 += 2;
        }
        return n3;
    }

    public static int getUTFSize(String string) {
        int n2 = string == null ? 0 : string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n3;
                continue;
            }
            if (c2 > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        return n3;
    }

    public static String inputStreamToString(InputStream inputStream, int n2) throws IOException {
        int n3;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        int n4 = 8192;
        char[] cArray = new char[n4];
        for (int i2 = n2; i2 > 0 && (n3 = inputStreamReader.read(cArray, 0, i2 > n4 ? n4 : i2)) != -1; i2 -= n3) {
            stringWriter.write(cArray, 0, n3);
        }
        stringWriter.close();
        return stringWriter.toString();
    }

    public static String toQuotedString(String string, char c2, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = bl ? StringConverter.count(string, c2) : 0;
        int n3 = string.length();
        char[] cArray = new char[2 + n2 + n3];
        int n4 = 0;
        cArray[n4++] = c2;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c3 = string.charAt(i2);
            cArray[n4++] = c3;
            if (!bl || c3 != c2) continue;
            cArray[n4++] = c3;
        }
        cArray[n4] = c2;
        return new String(cArray);
    }

    static int count(String string, char c2) {
        int n2 = 0;
        int n3 = 0;
        if (string != null) {
            while ((n2 = string.indexOf(c2, n2)) > -1) {
                ++n3;
                ++n2;
            }
        }
        return n3;
    }
}

