/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;

public class HsqlLinkedList
extends BaseList
implements HsqlList {
    private Node first;
    private Node last;

    public HsqlLinkedList() {
        this.last = this.first = new Node(null, null);
        this.elementCount = 0;
    }

    public void add(int n2, Object object) {
        if (n2 == this.size()) {
            this.add(object);
        } else {
            if (n2 > this.size()) {
                throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " > " + this.size());
            }
            Node node = this.getInternal(n2);
            Node node2 = new Node(node.data, node.next);
            node.data = object;
            node.next = node2;
            ++this.elementCount;
            if (this.last == node) {
                this.last = node2;
            }
        }
    }

    public boolean add(Object object) {
        this.last = this.last.next = new Node(object, null);
        ++this.elementCount;
        return true;
    }

    public void clear() {
        this.first.next = null;
    }

    public Object get(int n2) {
        return this.getInternal((int)n2).data;
    }

    public Object remove(int n2) {
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.size());
        }
        Node node = n2 == 0 ? this.first : this.getInternal(n2 - 1);
        Node node2 = node.next;
        node.next = node2.next;
        --this.elementCount;
        if (this.last == node2) {
            this.last = node;
        }
        return node2.data;
    }

    public Object set(int n2, Object object) {
        Node node = this.getInternal(n2);
        Object object2 = node.data;
        node.data = object;
        return object2;
    }

    public final int size() {
        return this.elementCount;
    }

    protected final Node getInternal(int n2) {
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.size());
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        if (n2 == 0) {
            return this.first.next;
        }
        if (n2 == this.size() - 1) {
            return this.last;
        }
        Node node = this.first.next;
        for (int i2 = 0; i2 < n2; ++i2) {
            node = node.next;
        }
        return node;
    }

    private static class Node {
        public Node next;
        public Object data;

        public Node() {
            this.next = null;
            this.data = null;
        }

        public Node(Object object) {
            this.next = null;
            this.data = object;
        }

        public Node(Object object, Node node) {
            this.next = node;
            this.data = object;
        }
    }
}

