/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;

public class HsqlDeque
extends BaseList
implements HsqlList {
    private Object[] list = new Object[10];
    private int firstindex = 0;
    private int endindex = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;

    public int size() {
        return this.elementCount;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    public Object get(int n2) throws IndexOutOfBoundsException {
        int n3 = this.getInternalIndex(n2);
        return this.list[n3];
    }

    public void add(int n2, Object object) throws IndexOutOfBoundsException {
        throw new RuntimeException();
    }

    public Object set(int n2, Object object) throws IndexOutOfBoundsException {
        int n3 = this.getInternalIndex(n2);
        Object object2 = this.list[n3];
        this.list[n3] = object;
        return object2;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return object;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        Object object = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return object;
    }

    public boolean add(Object object) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = object;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public boolean addLast(Object object) {
        return this.add(object);
    }

    public boolean addFirst(Object object) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = object;
        ++this.elementCount;
        return true;
    }

    public void clear() {
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        for (int i2 = 0; i2 < this.list.length; ++i2) {
            this.list[i2] = null;
        }
    }

    public Object remove(int n2) {
        int n3 = this.getInternalIndex(n2);
        Object object = this.list[n3];
        if (n3 >= this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, n3 - this.firstindex);
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, n3 + 1, this.list, n3, this.endindex - n3 - 1);
            this.list[this.endindex] = null;
            --this.endindex;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return object;
    }

    private int getInternalIndex(int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.firstindex + n2;
        if (n3 >= this.list.length) {
            n3 -= this.list.length;
        }
        return n3;
    }

    private void resetCapacity() {
        int n2;
        if (this.elementCount < this.list.length) {
            return;
        }
        Object[] objectArray = new Object[this.list.length * 2];
        for (n2 = 0; n2 < this.list.length; ++n2) {
            objectArray[n2] = this.list[n2];
        }
        this.list = objectArray;
        objectArray = null;
        if (this.endindex <= this.firstindex) {
            n2 = this.firstindex + this.elementCount - this.endindex;
            for (int i2 = 0; i2 < this.endindex; ++i2) {
                this.list[n2 + i2] = this.list[i2];
                this.list[i2] = null;
            }
            this.endindex = this.firstindex + this.elementCount;
        }
    }
}

