/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buf;
    protected int count;

    public HsqlByteArrayOutputStream() {
        this(128);
    }

    public HsqlByteArrayOutputStream(int n2) {
        if (n2 < 128) {
            n2 = 128;
        }
        this.buf = new byte[n2];
    }

    public HsqlByteArrayOutputStream(byte[] byArray) {
        this.buf = byArray;
    }

    public final void writeShort(int n2) {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(n2 >>> 8);
        this.buf[this.count++] = (byte)n2;
    }

    public final void writeInt(int n2) {
        if (this.count + 4 > this.buf.length) {
            this.ensureRoom(4);
        }
        this.buf[this.count++] = (byte)(n2 >>> 24);
        this.buf[this.count++] = (byte)(n2 >>> 16);
        this.buf[this.count++] = (byte)(n2 >>> 8);
        this.buf[this.count++] = (byte)n2;
    }

    public final void writeLong(long l2) {
        this.writeInt((int)(l2 >>> 32));
        this.writeInt((int)l2);
    }

    public final void writeBytes(String string) {
        int n2 = string.length();
        this.ensureRoom(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buf[this.count++] = (byte)string.charAt(i2);
        }
    }

    public final void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public final void writeDouble(double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n2) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)n2;
    }

    public void writeChar(int n2) throws IOException {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(n2 >>> 8);
        this.buf[this.count++] = (byte)n2;
    }

    public void writeChars(String string) throws IOException {
        int n2 = string.length();
        this.ensureRoom(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            this.buf[this.count++] = (byte)(c2 >>> 8);
            this.buf[this.count++] = (byte)c2;
        }
    }

    public void writeUTF(String string) throws IOException {
        int n2 = string.length();
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(n2 * 3 + 2);
        int n3 = this.count;
        this.count += 2;
        StringConverter.writeUTF(string, this);
        int n4 = this.count - n3 - 2;
        if (n4 > 65535) {
            this.count = n3;
            throw new UTFDataFormatException();
        }
        this.buf[n3++] = (byte)(n4 >>> 8);
        this.buf[n3] = (byte)n4;
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void write(int n2) {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)n2;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.ensureRoom(n3);
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count += n3;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    public void close() throws IOException {
    }

    public void fill(int n2, int n3) {
        this.ensureRoom(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.buf[this.count++] = (byte)n2;
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    protected void ensureRoom(int n2) {
        int n3 = this.count + n2;
        int n4 = this.buf.length;
        if (n3 > n4) {
            while (n3 > n4) {
                n4 *= 2;
            }
            byte[] byArray = new byte[n4];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    protected void reset(int n2) {
        this.count = 0;
        if (n2 > this.buf.length) {
            this.buf = new byte[n2];
        }
    }
}

