/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;

public class HsqlArrayList
extends BaseList
implements HsqlList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    private Object[] elementData;
    private boolean minimizeOnClear;

    public HsqlArrayList() {
        this.elementData = new Object[10];
    }

    public HsqlArrayList(boolean bl) {
        this.elementData = new Object[10];
        this.minimizeOnClear = bl;
    }

    public HsqlArrayList(int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        this.elementData = n2 == 0 ? new Object[1] : new Object[n2];
    }

    public void add(int n2, Object object) {
        if (n2 > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + ">" + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        for (int i2 = this.elementCount; i2 > n2; --i2) {
            this.elementData[i2] = this.elementData[i2 - 1];
        }
        this.elementData[n2] = object;
        ++this.elementCount;
    }

    public boolean add(Object object) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = object;
        ++this.elementCount;
        return true;
    }

    public Object get(int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        return this.elementData[n2];
    }

    public int indexOf(Object object) {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (!this.elementData[i2].equals(object)) continue;
            return i2;
        }
        return -1;
    }

    public Object remove(int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        Object object = this.elementData[n2];
        for (int i2 = n2; i2 < this.elementCount - 1; ++i2) {
            this.elementData[i2] = this.elementData[i2 + 1];
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        if (this.minimizeOnClear && this.elementCount == 0) {
            this.elementData = new Object[10];
        }
        return object;
    }

    public Object set(int n2, Object object) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        Object object2 = this.elementData[n2];
        this.elementData[n2] = object;
        return object2;
    }

    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int n2 = this.elementData.length == 0 ? 1 : this.elementData.length;
        Object[] objectArray = new Object[(int)((float)n2 * 2.0f)];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementData.length);
        this.elementData = objectArray;
        objectArray = null;
    }

    public void trim() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
        objectArray = null;
    }

    public void clear() {
        if (this.minimizeOnClear && this.elementData.length > 10) {
            this.elementData = new Object[10];
            this.elementCount = 0;
            return;
        }
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int n2) {
        if (n2 < this.elementCount) {
            if (this.minimizeOnClear && n2 == 0 && this.elementData.length > 10) {
                this.elementData = new Object[10];
                this.elementCount = 0;
                return;
            }
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
        }
        this.elementCount = n2;
        while (this.elementCount > this.elementData.length) {
            this.increaseCapacity();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public Object[] toArray(int n2, int n3) {
        Object[] objectArray = new Object[this.elementCount - n3];
        System.arraycopy(this.elementData, n2, objectArray, 0, this.elementCount - n3);
        return objectArray;
    }

    public Object toArray(Object object) {
        if (Array.getLength(object) < this.elementCount) {
            object = Array.newInstance(object.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, object, 0, this.elementCount);
        return object;
    }

    public void sort(ObjectComparator objectComparator) {
        if (this.elementCount < 2) {
            return;
        }
        Sort.sort(this.elementData, objectComparator, 0, this.elementCount - 1);
    }

    public Object[] getArray() {
        return this.elementData;
    }
}

