/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HsqlHeap;
import org.hsqldb.lib.ObjectComparator;

public class HsqlArrayHeap
implements HsqlHeap {
    protected ObjectComparator oc;
    protected int count;
    protected Object[] heap;

    public HsqlArrayHeap(int n2, ObjectComparator objectComparator) throws IllegalArgumentException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("" + n2);
        }
        if (objectComparator == null) {
            throw new IllegalArgumentException("null comparator");
        }
        this.heap = new Object[n2];
        this.oc = objectComparator;
    }

    public synchronized void clear() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            this.heap[i2] = null;
        }
        this.count = 0;
    }

    public synchronized void add(Object object) throws IllegalArgumentException, RuntimeException {
        if (object == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this.isFull()) {
            throw new RuntimeException("full");
        }
        if (this.count >= this.heap.length) {
            this.increaseCapacity();
        }
        int n2 = this.count++;
        while (n2 > 0) {
            int n3 = n2 - 1 >> 1;
            try {
                if (this.oc.compare(object, this.heap[n3]) >= 0) {
                    break;
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.toString());
            }
            this.heap[n2] = this.heap[n3];
            n2 = n3;
        }
        this.heap[n2] = object;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized boolean isFull() {
        return this.count == Integer.MAX_VALUE;
    }

    public synchronized Object peek() {
        return this.heap[0];
    }

    public synchronized Object remove() {
        int n2;
        if (this.count == 0) {
            return null;
        }
        int n3 = 0;
        Object object = this.heap[n3];
        --this.count;
        if (this.count == 0) {
            this.heap[0] = null;
            return object;
        }
        Object object2 = this.heap[this.count];
        this.heap[this.count] = null;
        while ((n2 = (n3 << 1) + 1) < this.count) {
            int n4;
            int n5 = (n3 << 1) + 2;
            int n6 = n4 = n5 >= this.count || this.oc.compare(this.heap[n2], this.heap[n5]) < 0 ? n2 : n5;
            if (this.oc.compare(object2, this.heap[n4]) <= 0) break;
            this.heap[n3] = this.heap[n4];
            n3 = n4;
        }
        this.heap[n3] = object2;
        return object;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" : size=");
        stringBuffer.append(this.count);
        stringBuffer.append(' ');
        stringBuffer.append('[');
        for (int i2 = 0; i2 < this.count; ++i2) {
            stringBuffer.append(this.heap[i2]);
            if (i2 + 1 >= this.count) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void increaseCapacity() {
        Object[] objectArray = this.heap;
        this.heap = new Object[3 * this.heap.length / 2 + 1];
        System.arraycopy(objectArray, 0, this.heap, 0, this.count);
    }
}

