/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashMap;

public class HashMappedList
extends HashMap {
    public HashMappedList() {
        this(16, 0.75f);
    }

    public HashMappedList(int n2) throws IllegalArgumentException {
        this(n2, 0.75f);
    }

    public HashMappedList(int n2, float f2) throws IllegalArgumentException {
        super(n2, f2);
    }

    public Object get(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        return this.objectValueTable[n2];
    }

    public Object remove(Object object) {
        int n2 = this.getLookup(object, object.hashCode());
        if (n2 < 0) {
            return null;
        }
        Object object2 = super.remove(object);
        this.removeRow(n2);
        return object2;
    }

    public Object remove(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        return this.remove(this.objectKeyTable[n2]);
    }

    public boolean add(Object object, Object object2) {
        if (this.keySet().contains(object)) {
            return false;
        }
        super.put(object, object2);
        return true;
    }

    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    public Object set(int n2, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        Object object2 = this.objectKeyTable[n2];
        this.objectKeyTable[n2] = object;
        return object2;
    }

    public boolean insert(int n2, Object object, Object object2) throws IndexOutOfBoundsException {
        int n3;
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.keySet().contains(object)) {
            return false;
        }
        if (n2 == this.size()) {
            return this.add(object, object2);
        }
        HashMappedList hashMappedList = new HashMappedList(this.size());
        for (n3 = n2; n3 < this.size(); ++n3) {
            hashMappedList.add(this.getKey(n3), this.get(n3));
        }
        for (n3 = this.size() - 1; n3 >= n2; --n3) {
            this.remove(n3);
        }
        for (n3 = 0; n3 < hashMappedList.size(); ++n3) {
            this.add(hashMappedList.getKey(n3), hashMappedList.get(n3));
        }
        return true;
    }

    public boolean set(int n2, Object object, Object object2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        if (this.keySet().contains(object) && this.getIndex(object) != n2) {
            return false;
        }
        super.remove(this.objectKeyTable[n2]);
        super.put(object, object2);
        return true;
    }

    public boolean setKey(int n2, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        Object object2 = this.objectValueTable[n2];
        return this.set(n2, object, object2);
    }

    public Object getKey(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        return this.objectKeyTable[n2];
    }

    public int getIndex(Object object) {
        return this.getLookup(object, object.hashCode());
    }

    private void checkRange(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

