/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntLookup;

public class DoubleIntIndex
implements IntLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = true;
    private boolean hasChanged;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public DoubleIntIndex(int n2, boolean bl) {
        this.capacity = n2;
        this.keys = new int[n2];
        this.values = new int[n2];
        this.fixedSize = bl;
        this.hasChanged = true;
    }

    public synchronized int getKey(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n2];
    }

    public synchronized int getValue(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[n2];
    }

    public synchronized void setKey(int n2, int n3) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[n2] = n3;
    }

    public synchronized void setValue(int n2, int n3) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[n2] = n3;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public synchronized boolean addUnsorted(int n2, int n3) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0) {
            if (this.sortOnValues) {
                if (n3 < this.values[this.count - 1]) {
                    this.sorted = false;
                }
            } else if (n3 < this.keys[this.count - 1]) {
                this.sorted = false;
            }
        }
        this.hasChanged = true;
        this.keys[this.count] = n2;
        this.values[this.count] = n3;
        ++this.count;
        return true;
    }

    public synchronized boolean addSorted(int n2, int n3) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0 && n3 < this.values[this.count - 1]) {
            return false;
        }
        this.hasChanged = true;
        this.keys[this.count] = n2;
        this.values[this.count] = n3;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int n2, int n3) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n3 : n2;
        int n4 = this.binaryEmptySlotSearch();
        if (n4 == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != n4) {
            this.moveRows(n4, n4 + 1, this.count - n4);
        }
        this.keys[n4] = n2;
        this.values[n4] = n3;
        ++this.count;
        return true;
    }

    public synchronized boolean add(int n2, int n3) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n3 : n2;
        int n4 = this.binarySlotSearch();
        if (n4 == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != n4) {
            this.moveRows(n4, n4 + 1, this.count - n4);
        }
        this.keys[n4] = n2;
        this.values[n4] = n3;
        ++this.count;
        return true;
    }

    public int lookupFirstEqual(int n2) throws NoSuchElementException {
        int n3;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n3 = this.findFirstEqualKeyIndex(n2)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n3);
    }

    public int lookupFirstGreaterEqual(int n2) throws NoSuchElementException {
        int n3;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n3 = this.findFirstGreaterEqualKeyIndex(n2)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n3);
    }

    public synchronized void setValuesSearchTarget() {
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = true;
    }

    public synchronized void setKeysSearchTarget() {
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = false;
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int n2) {
        int n3 = this.findFirstGreaterEqualSlotIndex(n2);
        return n3 == this.count ? -1 : n3;
    }

    public synchronized int findFirstEqualKeyIndex(int n2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        return this.binaryFirstSearch();
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int n2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        return this.binarySlotSearch();
    }

    private int binaryFirstSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.count;
        while (n2 < n3) {
            n4 = (n2 + n3) / 2;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
            n6 = n4;
        }
        return n6 == this.count ? -1 : n6;
    }

    private int binaryGreaterSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = (n2 + n3) / 2;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2 == this.count ? -1 : n2;
    }

    private int binarySlotSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = (n2 + n3) / 2;
            n5 = this.compare(n4);
            if (n5 <= 0) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    private int binaryEmptySlotSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = (n2 + n3) / 2;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            return -1;
        }
        return n2;
    }

    private synchronized void fastQuickSort() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n2, int n3) {
        int n4 = 4;
        if (n3 - n2 > n4) {
            int n5 = (n3 + n2) / 2;
            if (this.lessThan(n5, n2)) {
                this.swap(n2, n5);
            }
            if (this.lessThan(n3, n2)) {
                this.swap(n2, n3);
            }
            if (this.lessThan(n3, n5)) {
                this.swap(n5, n3);
            }
            int n6 = n3 - 1;
            this.swap(n5, n6);
            n5 = n2;
            int n7 = n6;
            while (true) {
                if (this.lessThan(++n5, n7)) {
                    continue;
                }
                while (this.lessThan(n7, --n6)) {
                }
                if (n6 < n5) break;
                this.swap(n5, n6);
            }
            this.swap(n5, n3 - 1);
            this.quickSort(n2, n6);
            this.quickSort(n5 + 1, n3);
        }
    }

    private void insertionSort(int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4;
            for (n4 = i2; n4 > n2 && this.lessThan(i2, n4 - 1); --n4) {
            }
            if (i2 == n4) continue;
            this.moveAndInsertRow(i2, n4);
        }
    }

    private void moveAndInsertRow(int n2, int n3) {
        int n4 = this.keys[n2];
        int n5 = this.values[n2];
        this.moveRows(n3, n3 + 1, n2 - n3);
        this.keys[n3] = n4;
        this.values[n3] = n5;
    }

    private void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (int[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    private void swap(int n2, int n3) {
        int n4 = this.keys[n2];
        int n5 = this.values[n2];
        this.keys[n2] = this.keys[n3];
        this.values[n2] = this.values[n3];
        this.keys[n3] = n4;
        this.values[n3] = n5;
    }

    private void moveRows(int n2, int n3, int n4) {
        System.arraycopy(this.keys, n2, this.keys, n3, n4);
        System.arraycopy(this.values, n2, this.values, n3, n4);
    }

    public void removeRange(int n2, int n3) {
        this.moveRows(n3, n2, this.count - n3);
        this.count -= n3 - n2;
    }

    public void removeAll() {
        this.hasChanged = true;
        ArrayUtil.clearArray(73, this.keys, 0, this.count);
        ArrayUtil.clearArray(73, this.values, 0, this.count);
        this.count = 0;
    }

    private int compare(int n2) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[n2]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[n2]) {
                return -1;
            }
        } else {
            if (this.targetSearchValue > this.keys[n2]) {
                return 1;
            }
            if (this.targetSearchValue < this.keys[n2]) {
                return -1;
            }
        }
        return 0;
    }

    public final synchronized void remove(int n2) {
        this.hasChanged = true;
        this.moveRows(n2 + 1, n2, this.count - n2 - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    private boolean lessThan(int n2, int n3) {
        return this.sortOnValues ? this.values[n2] < this.values[n3] : this.keys[n2] < this.keys[n3];
    }
}

