/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import org.hsqldb.lib.IntValueHashMap;

public class ArrayUtil {
    public static final int CLASS_CODE_BYTE = 66;
    public static final int CLASS_CODE_CHAR = 67;
    public static final int CLASS_CODE_DOUBLE = 68;
    public static final int CLASS_CODE_FLOAT = 70;
    public static final int CLASS_CODE_INT = 73;
    public static final int CLASS_CODE_LONG = 74;
    public static final int CLASS_CODE_OBJECT = 76;
    public static final int CLASS_CODE_SHORT = 83;
    public static final int CLASS_CODE_BOOLEAN = 90;
    private static IntValueHashMap classCodeMap = new IntValueHashMap();
    static /* synthetic */ Class class$java$lang$Object;

    static int getClassCode(Class clazz) {
        if (!clazz.isPrimitive()) {
            return 76;
        }
        return classCodeMap.get((Object)clazz, -1);
    }

    public static void clearArray(int n2, Object object, int n3, int n4) {
        switch (n2) {
            case 66: {
                byte[] byArray = (byte[])object;
                while (--n4 >= n3) {
                    byArray[n4] = 0;
                }
                return;
            }
            case 67: {
                byte[] byArray = (byte[])object;
                while (--n4 >= n3) {
                    byArray[n4] = 0;
                }
                return;
            }
            case 83: {
                short[] sArray = (short[])object;
                while (--n4 >= n3) {
                    sArray[n4] = 0;
                }
                return;
            }
            case 73: {
                int[] nArray = (int[])object;
                while (--n4 >= n3) {
                    nArray[n4] = 0;
                }
                return;
            }
            case 74: {
                long[] lArray = (long[])object;
                while (--n4 >= n3) {
                    lArray[n4] = 0L;
                }
                return;
            }
            case 70: {
                float[] fArray = (float[])object;
                while (--n4 >= n3) {
                    fArray[n4] = 0.0f;
                }
                return;
            }
            case 68: {
                double[] dArray = (double[])object;
                while (--n4 >= n3) {
                    dArray[n4] = 0.0;
                }
                return;
            }
            case 90: {
                boolean[] blArray = (boolean[])object;
                while (--n4 >= n3) {
                    blArray[n4] = false;
                }
                return;
            }
        }
        Object[] objectArray = (Object[])object;
        while (--n4 >= n3) {
            objectArray[n4] = null;
        }
    }

    public static void adjustArray(int n2, Object object, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        if (n4 >= n3) {
            return;
        }
        int n9 = n3 + n5;
        if (n5 >= 0) {
            n8 = n4;
            n7 = n4 + n5;
            n6 = n3 - n4;
        } else {
            n8 = n4 - n5;
            n7 = n4;
            n6 = n3 - n4 + n5;
        }
        if (n6 > 0) {
            System.arraycopy(object, n8, object, n7, n6);
        }
        if (n5 < 0) {
            ArrayUtil.clearArray(n2, object, n9, n3);
        }
    }

    public static void sortArray(int[] nArray) {
        boolean bl;
        do {
            bl = false;
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                if (nArray[i2] <= nArray[i2 + 1]) continue;
                int n2 = nArray[i2 + 1];
                nArray[i2 + 1] = nArray[i2];
                nArray[i2] = n2;
                bl = true;
            }
        } while (bl);
    }

    public static int find(Object[] objectArray, Object object) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == object) {
                return i2;
            }
            if (object == null || !object.equals(objectArray[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static int find(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int findNot(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == n2) continue;
            return i2;
        }
        return -1;
    }

    public static boolean areEqualSets(int[] nArray, int[] nArray2) {
        return nArray.length == nArray2.length && ArrayUtil.haveEqualSets(nArray, nArray2, nArray.length);
    }

    public static boolean areEqual(int[] nArray, int[] nArray2, int n2, boolean bl) {
        if (ArrayUtil.haveEqualArrays(nArray, nArray2, n2)) {
            if (bl) {
                return nArray.length == nArray2.length && n2 == nArray.length;
            }
            return true;
        }
        return false;
    }

    public static boolean haveEqualSets(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            return false;
        }
        if (n2 == 1) {
            return nArray[0] == nArray2[0];
        }
        int[] nArray3 = (int[])ArrayUtil.resizeArray(nArray, n2);
        int[] nArray4 = (int[])ArrayUtil.resizeArray(nArray2, n2);
        ArrayUtil.sortArray(nArray3);
        ArrayUtil.sortArray(nArray4);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray3[i2] == nArray4[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean haveEqualArrays(Object[] objectArray, Object[] objectArray2, int n2) {
        if (n2 > objectArray.length || n2 > objectArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[i2] == objectArray2[i2] || objectArray[i2] != null && objectArray[i2].equals(objectArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommonElement(int[] nArray, int[] nArray2, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                if (n3 != nArray2[i3]) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] commonElements(int[] nArray, int[] nArray2) {
        int[] nArray3 = null;
        int n2 = ArrayUtil.countCommonElements(nArray, nArray2);
        if (n2 > 0) {
            nArray3 = new int[n2];
            int n3 = 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    if (nArray[i2] != nArray2[i3]) continue;
                    nArray3[n3++] = nArray[i2];
                }
            }
        }
        return nArray3;
    }

    public static int countCommonElements(int[] nArray, int[] nArray2) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                if (nArray[i2] != nArray2[i3]) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static int countSameElements(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        int n4 = byArray.length - n2;
        if (n4 > byArray2.length) {
            n4 = byArray2.length;
        }
        for (int i2 = 0; i2 < n4 && byArray[i2 + n2] == byArray2[i2]; ++i2) {
            ++n3;
        }
        return n3;
    }

    public static int find(byte[] byArray, int n2, int n3, byte[] byArray2) {
        n3 = n3 - byArray2.length + 1;
        byte by = byArray2[0];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] != by) continue;
            if (byArray2.length == 1) {
                return i2;
            }
            if (!ArrayUtil.containsAt(byArray, i2, byArray2)) continue;
            return i2;
        }
        return -1;
    }

    public static int findNotIn(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = 0;
        if (n4 < n3) {
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray[n4] != byArray2[i2]) continue;
            }
            return n4;
        }
        return -1;
    }

    public static int findIn(byte[] byArray, int n2, int n3, byte[] byArray2) {
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2] != byArray2[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int find(byte[] byArray, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] != n4 && byArray[i2] != n5) continue;
            return i2;
        }
        return -1;
    }

    public static void intIndexesToBooleanArray(int[] nArray, boolean[] blArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= blArray.length) continue;
            blArray[nArray[i2]] = true;
        }
    }

    public static boolean containsAllTrueElements(boolean[] blArray, boolean[] blArray2) {
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (!blArray2[i2] || blArray[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAt(byte[] byArray, int n2, byte[] byArray2) {
        return ArrayUtil.countSameElements(byArray, n2, byArray2) == byArray2.length;
    }

    public static int countStartElementsAt(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        block0: for (int i2 = n2; i2 < byArray.length; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2] != byArray2[i3]) continue;
                ++n3;
                continue block0;
            }
        }
        return n3;
    }

    public static int countNonStartElementsAt(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        block0: for (int i2 = n2; i2 < byArray.length; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2] == byArray2[i3]) break block0;
            }
            ++n3;
        }
        return n3;
    }

    public static void copyArray(Object object, Object object2, int n2) {
        System.arraycopy(object, 0, object2, 0, n2);
    }

    public static int[] arraySlice(int[] nArray, int n2, int n3) {
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, n2, nArray2, 0, n3);
        return nArray2;
    }

    public static void fillArray(Object[] objectArray, Object object) {
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            objectArray[n2] = object;
        }
    }

    public static void fillArray(int[] nArray, int n2) {
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
    }

    public static Object duplicateArray(Object object) {
        int n2 = Array.getLength(object);
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static Object resizeArrayIfDifferent(Object object, int n2) {
        int n3 = Array.getLength(object);
        if (n3 == n2) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        if (n3 < n2) {
            n2 = n3;
        }
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static Object resizeArray(Object object, int n2) {
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n2);
        int n3 = Array.getLength(object);
        if (n3 < n2) {
            n2 = n3;
        }
        System.arraycopy(object, 0, object2, 0, n2);
        return object2;
    }

    public static Object toAdjustedArray(Object object, Object object2, int n2, int n3) {
        int n4 = Array.getLength(object) + n3;
        Object object3 = Array.newInstance(object.getClass().getComponentType(), n4);
        ArrayUtil.copyAdjustArray(object, object3, object2, n2, n3);
        return object3;
    }

    public static void copyAdjustArray(Object object, Object object2, Object object3, int n2, int n3) {
        int n4 = Array.getLength(object);
        if (n2 < 0) {
            System.arraycopy(object, 0, object2, 0, n4);
            return;
        }
        System.arraycopy(object, 0, object2, 0, n2);
        if (n3 == 0) {
            int n5 = n4 - n2 - 1;
            Array.set(object2, n2, object3);
            if (n5 > 0) {
                System.arraycopy(object, n2 + 1, object2, n2 + 1, n5);
            }
        } else if (n3 < 0) {
            int n6 = n4 - n2 - 1;
            if (n6 > 0) {
                System.arraycopy(object, n2 + 1, object2, n2, n6);
            }
        } else {
            int n7 = n4 - n2;
            Array.set(object2, n2, object3);
            if (n7 > 0) {
                System.arraycopy(object, n2, object2, n2 + 1, n7);
            }
        }
    }

    public static int[] toAdjustedColumnArray(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        int n4 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] > n2) {
                nArray2[n4] = nArray[i2] + n3;
                ++n4;
                continue;
            }
            if (nArray[i2] == n2) {
                if (n3 < 0) continue;
                nArray2[n4] = nArray[i2] + n3;
                ++n4;
                continue;
            }
            nArray2[n4] = nArray[i2];
            ++n4;
        }
        if (nArray.length != n4) {
            int[] nArray3 = new int[n4];
            ArrayUtil.copyArray(nArray2, nArray3, n4);
            return nArray3;
        }
        return nArray2;
    }

    public static void copyColumnValues(Object[] objectArray, int[] nArray, Object[] objectArray2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            objectArray2[i2] = objectArray[nArray[i2]];
        }
    }

    public static void copyColumnValues(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray3[i2] = nArray[nArray2[i2]];
        }
    }

    public static void fillSequence(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = i2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        classCodeMap.put(Byte.TYPE, 66);
        classCodeMap.put(Character.TYPE, 83);
        classCodeMap.put(Short.TYPE, 83);
        classCodeMap.put(Integer.TYPE, 73);
        classCodeMap.put(Long.TYPE, 74);
        classCodeMap.put(Float.TYPE, 70);
        classCodeMap.put(Double.TYPE, 68);
        classCodeMap.put(Boolean.TYPE, 90);
        classCodeMap.put(class$java$lang$Object == null ? (class$java$lang$Object = ArrayUtil.class$("java.lang.Object")) : class$java$lang$Object, 76);
    }
}

