/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcColumnMetaData;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.persist.HsqlProperties;

public class jdbcResultSetMetaData
implements ResultSetMetaData {
    private jdbcColumnMetaData[] columnMetaData;
    private int columnCount;
    private boolean useColumnName;
    private static final boolean TRACE = false;

    jdbcResultSetMetaData(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        this.init(jdbcResultSet2, hsqlProperties);
    }

    jdbcResultSetMetaData(Result result, HsqlProperties hsqlProperties) throws SQLException {
        this.init(result, hsqlProperties);
    }

    void init(jdbcResultSet jdbcResultSet2, HsqlProperties hsqlProperties) throws SQLException {
        if (jdbcResultSet2 == null) {
            throw Util.sqlException(40, 119, null);
        }
        this.init(jdbcResultSet2.rResult, hsqlProperties);
    }

    void init(Result result, HsqlProperties hsqlProperties) throws SQLException {
        if (result == null) {
            throw Util.sqlException(40, 120, null);
        }
        if (!result.isData()) {
            return;
        }
        this.columnCount = result.getColumnCount();
        this.useColumnName = hsqlProperties == null ? true : hsqlProperties.isPropertyTrue("get_column_name");
        this.columnMetaData = new jdbcColumnMetaData[this.columnCount];
        Result.ResultMetaData resultMetaData = result.metaData;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            Boolean bl;
            jdbcColumnMetaData jdbcColumnMetaData2;
            this.columnMetaData[i2] = jdbcColumnMetaData2 = new jdbcColumnMetaData();
            jdbcColumnMetaData2.catalogName = resultMetaData.catalogNames[i2] == null ? "" : resultMetaData.catalogNames[i2];
            jdbcColumnMetaData2.schemaName = resultMetaData.schemaNames[i2] == null ? "" : resultMetaData.schemaNames[i2];
            jdbcColumnMetaData2.tableName = resultMetaData.tableNames[i2] == null ? "" : resultMetaData.tableNames[i2];
            jdbcColumnMetaData2.columnName = resultMetaData.colNames[i2] == null ? "" : resultMetaData.colNames[i2];
            jdbcColumnMetaData2.columnLabel = resultMetaData.colLabels[i2] == null ? "" : resultMetaData.colLabels[i2];
            jdbcColumnMetaData2.columnType = resultMetaData.colTypes[i2];
            jdbcColumnMetaData2.columnTypeName = Types.getTypeString(jdbcColumnMetaData2.columnType);
            jdbcColumnMetaData2.isWritable = resultMetaData.isWritable[i2];
            jdbcColumnMetaData2.isReadOnly = !jdbcColumnMetaData2.isWritable;
            jdbcColumnMetaData2.isAutoIncrement = resultMetaData.isIdentity[i2];
            jdbcColumnMetaData2.isNullable = resultMetaData.colNullable[i2];
            int n2 = jdbcColumnMetaData2.columnType;
            jdbcColumnMetaData2.columnClassName = resultMetaData.classNames[i2];
            if (jdbcColumnMetaData2.columnClassName == null || jdbcColumnMetaData2.columnClassName.length() == 0) {
                jdbcColumnMetaData2.columnClassName = Types.getColStClsName(n2);
            }
            if (Types.acceptsPrecisionCreateParam(n2)) {
                if (resultMetaData.colSizes[i2] == 0) {
                    jdbcColumnMetaData2.columnDisplaySize = Types.getMaxDisplaySize(n2);
                } else {
                    jdbcColumnMetaData2.columnDisplaySize = resultMetaData.colSizes[i2];
                    if (Types.acceptsScaleCreateParam(n2) && resultMetaData.colScales[i2] != 0) {
                        jdbcColumnMetaData2.columnDisplaySize += 1 + resultMetaData.colScales[i2];
                    }
                }
            } else {
                jdbcColumnMetaData2.columnDisplaySize = Types.getMaxDisplaySize(n2);
            }
            if (Types.isNumberType(n2) && Types.acceptsPrecisionCreateParam(n2)) {
                jdbcColumnMetaData2.precision = resultMetaData.colSizes[i2];
                if (jdbcColumnMetaData2.precision == 0) {
                    jdbcColumnMetaData2.precision = Types.getPrecision(n2);
                }
            } else {
                jdbcColumnMetaData2.precision = Types.getPrecision(n2);
            }
            if (Types.acceptsScaleCreateParam(n2)) {
                jdbcColumnMetaData2.scale = resultMetaData.colScales[i2];
            }
            jdbcColumnMetaData2.isSigned = (bl = Types.isUnsignedAttribute(n2)) != null && bl == false;
            Boolean bl2 = Types.isCaseSensitive(n2);
            jdbcColumnMetaData2.isCaseSensitive = bl2 != null && bl2 != false;
            jdbcColumnMetaData2.isSearchable = Types.isSearchable(n2);
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isAutoIncrement;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isCaseSensitive;
    }

    public boolean isSearchable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isSearchable;
    }

    public boolean isCurrency(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isCurrency;
    }

    public int isNullable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isNullable;
    }

    public boolean isSigned(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isSigned;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].columnDisplaySize;
    }

    public String getColumnLabel(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].columnLabel;
    }

    public String getColumnName(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.useColumnName ? this.columnMetaData[n2].columnName : this.columnMetaData[--n2].columnLabel;
    }

    public String getSchemaName(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].schemaName;
    }

    public int getPrecision(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].precision;
    }

    public int getScale(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].scale;
    }

    public String getTableName(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].tableName;
    }

    public String getCatalogName(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].catalogName;
    }

    public int getColumnType(int n2) throws SQLException {
        this.checkColumn(n2);
        int n3 = this.columnMetaData[--n2].columnType;
        return n3 == 100 ? 12 : n3;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].columnTypeName;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isReadOnly;
    }

    public boolean isWritable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isWritable;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].isDefinitelyWritable;
    }

    public String getColumnClassName(int n2) throws SQLException {
        this.checkColumn(n2);
        return this.columnMetaData[--n2].columnClassName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.columnCount == 0) {
            stringBuffer.append("[columnCount=0]");
            return stringBuffer.toString();
        }
        stringBuffer.append('[');
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            stringBuffer.append('\n');
            stringBuffer.append("   column_");
            stringBuffer.append(i2 + 1);
            stringBuffer.append('=');
            stringBuffer.append(this.columnMetaData[i2]);
            if (i2 + 1 >= this.columnCount) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void checkColumn(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.columnCount) {
            throw Util.sqlException(28, String.valueOf(n2));
        }
    }
}

