/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;

public class jdbcParameterMetaData
implements ParameterMetaData {
    Result.ResultMetaData rmd;
    int[] types;
    int[] modes;
    boolean[] isIdentity;
    int[] nullability;
    String[] classNames;
    int parameterCount;

    jdbcParameterMetaData(Result result) throws SQLException {
        if (result == null) {
            this.parameterCount = 0;
            return;
        }
        this.rmd = result.metaData;
        this.types = this.rmd.colTypes;
        this.parameterCount = this.types.length;
        this.nullability = this.rmd.colNullable;
        this.isIdentity = this.rmd.isIdentity;
        this.classNames = this.rmd.classNames;
        this.modes = this.rmd.paramMode;
    }

    void checkRange(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.parameterCount) {
            String string = n2 + " is out of range";
            throw Util.sqlException(62, string);
        }
    }

    public String getParameterClassName(int n2) throws SQLException {
        this.checkRange(n2);
        return this.classNames[--n2];
    }

    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    public int getParameterMode(int n2) throws SQLException {
        this.checkRange(n2);
        return this.modes[--n2];
    }

    public int getParameterType(int n2) throws SQLException {
        this.checkRange(n2);
        int n3 = this.types[--n2];
        return n3 == 100 ? 12 : n3;
    }

    public String getParameterTypeName(int n2) throws SQLException {
        this.checkRange(n2);
        return Types.getTypeName(this.types[--n2]);
    }

    public int getPrecision(int n2) throws SQLException {
        this.checkRange(n2);
        return Types.getPrecision(this.types[--n2]);
    }

    public int getScale(int n2) throws SQLException {
        this.checkRange(n2);
        return 0;
    }

    public int isNullable(int n2) throws SQLException {
        this.checkRange(n2);
        return this.nullability[--n2];
    }

    public boolean isSigned(int n2) throws SQLException {
        this.checkRange(n2);
        Boolean bl = Types.isUnsignedAttribute(this.types[--n2]);
        return bl != null && bl == false && !this.isIdentity[n2];
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable throwable) {
            return super.toString() + "[toStringImpl_exception=" + throwable + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n2 = this.getParameterCount();
        if (n2 == 0) {
            stringBuffer.append("[parameterCount=0]");
            return stringBuffer.toString();
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        stringBuffer.append('[');
        int n3 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('\n');
            stringBuffer.append("    parameter_");
            stringBuffer.append(i2 + 1);
            stringBuffer.append('=');
            stringBuffer.append('[');
            for (int i3 = 0; i3 < n3; ++i3) {
                Method method = methodArray[i3];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                stringBuffer.append(method.getName());
                stringBuffer.append('=');
                stringBuffer.append(method.invoke((Object)this, new Integer(i2 + 1)));
                if (i3 + 1 >= n3) continue;
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
            if (i2 + 1 >= n2) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

