/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;

public class jdbcBlob
implements Blob {
    volatile byte[] data;

    public jdbcBlob(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw Util.sqlException(62, "null");
        }
        this.data = byArray;
    }

    public long length() throws SQLException {
        byte[] byArray = this.data;
        return byArray.length;
    }

    public byte[] getBytes(long l2, int n2) throws SQLException {
        byte[] byArray = this.data;
        int n3 = byArray.length;
        if (--l2 < 0L || l2 > (long)n3) {
            throw Util.sqlException(62, "pos: " + (l2 + 1L));
        }
        if (n2 < 0 || (long)n2 > (long)n3 - l2) {
            throw Util.sqlException(62, "length: " + n2);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, (int)l2, byArray2, 0, n2);
        return byArray2;
    }

    public InputStream getBinaryStream() throws SQLException {
        byte[] byArray = this.data;
        return new ByteArrayInputStream(byArray);
    }

    public long position(byte[] byArray, long l2) throws SQLException {
        byte[] byArray2 = this.data;
        int n2 = byArray2.length;
        if (l2 > (long)n2 || byArray == null) {
            return -1L;
        }
        l2 = l2 < 1L ? 0L : --l2;
        int n3 = byArray.length;
        if (n3 == 0 || l2 > (long)(n2 - n3)) {
            return -1L;
        }
        int n4 = n2 - n3;
        byte by = byArray[0];
        block0: for (int i2 = (int)l2; i2 <= n4; ++i2) {
            if (byArray2[i2] != by) continue;
            int n5 = n3;
            int n6 = i2;
            int n7 = 0;
            boolean bl = true;
            while (n5-- > 0) {
                if (byArray2[n6++] == byArray[n7++]) continue;
                continue block0;
            }
            return i2 + 1;
        }
        return -1L;
    }

    public long position(Blob blob, long l2) throws SQLException {
        byte[] byArray = this.data;
        int n2 = byArray.length;
        if (l2 > (long)n2 || blob == null) {
            return -1L;
        }
        l2 = l2 < 1L ? 0L : --l2;
        long l3 = blob.length();
        if (l3 == 0L || l2 > (long)n2 - l3) {
            return -1L;
        }
        int n3 = (int)l3;
        byte[] byArray2 = blob instanceof jdbcBlob ? ((jdbcBlob)blob).data : blob.getBytes(1L, n3);
        int n4 = n2 - n3;
        byte by = byArray2[0];
        block0: for (int i2 = (int)l2; i2 <= n4; ++i2) {
            if (byArray[i2] != by) continue;
            int n5 = n3;
            int n6 = i2;
            int n7 = 0;
            while (n5-- > 0) {
                if (byArray[n6++] == byArray2[n7++]) continue;
                continue block0;
            }
            return i2 + 1;
        }
        return -1L;
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        throw Util.notSupported();
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        throw Util.notSupported();
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        throw Util.notSupported();
    }

    public void truncate(long l2) throws SQLException {
        byte[] byArray = this.data;
        if (l2 < 0L || l2 > (long)byArray.length) {
            throw Util.sqlException(62, Long.toString(l2));
        }
        if (l2 == (long)byArray.length) {
            return;
        }
        byte[] byArray2 = new byte[(int)l2];
        System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
        this.data = byArray2;
    }
}

