/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongKeyIntValueHashMap;

public class TransactionManager {
    LongKeyIntValueHashMap rowSessionMap;
    boolean reWriteProtect;
    Database database;
    private long globalActionTimestamp = 0L;

    TransactionManager(Database database) {
        this.database = database;
        this.rowSessionMap = new LongKeyIntValueHashMap(true);
    }

    public void setReWriteProtection(boolean bl) {
        this.reWriteProtect = bl;
    }

    void checkDelete(Session session, Row row) throws HsqlException {
    }

    void checkDelete(Session session, HashMappedList hashMappedList) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int n2 = session.getId();
        int n3 = hashMappedList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Row row = (Row)hashMappedList.getKey(i2);
            long l2 = row.getId();
            if (this.rowSessionMap.get(l2, n2) == n2) continue;
            throw Trace.error(117, 122);
        }
    }

    void checkDelete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int n2 = session.getId();
        int n3 = hsqlArrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Row row = (Row)hsqlArrayList.get(i2);
            long l2 = row.getId();
            if (this.rowSessionMap.get(l2, n2) == n2) continue;
            throw Trace.error(117, 122);
        }
    }

    void commit(Session session) {
        Object[] objectArray = session.rowActionList.getArray();
        int n2 = session.rowActionList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Transaction transaction = (Transaction)objectArray[i2];
            long l2 = transaction.row.getId();
            transaction.commit(session);
            this.rowSessionMap.remove(l2);
        }
        session.rowActionList.clear();
        session.savepoints.clear();
    }

    synchronized void rollback(Session session) {
        this.rollbackTransactions(session, 0, false);
        session.savepoints.clear();
    }

    void rollbackSavepoint(Session session, String string) throws HsqlException {
        int n2 = session.savepoints.getIndex(string);
        if (n2 < 0) {
            throw Trace.error(44, string);
        }
        Integer n3 = (Integer)session.savepoints.get(n2);
        int n4 = n3;
        this.rollbackTransactions(session, n4, false);
        while (session.savepoints.size() > n2) {
            session.savepoints.remove(session.savepoints.size() - 1);
        }
    }

    void rollbackTransactions(Session session, int n2, boolean bl) {
        Transaction transaction;
        int n3;
        Object[] objectArray = session.rowActionList.getArray();
        int n4 = session.rowActionList.size();
        for (n3 = n4 - 1; n3 >= n2; --n3) {
            transaction = (Transaction)objectArray[n3];
            transaction.rollback(session, bl);
        }
        for (n3 = n2; n3 < n4; ++n3) {
            transaction = (Transaction)objectArray[n3];
            long l2 = transaction.row.getId();
            this.rowSessionMap.remove(l2);
        }
        session.rowActionList.setSize(n2);
    }

    void addTransaction(Session session, Transaction transaction) {
        if (this.reWriteProtect) {
            this.rowSessionMap.put(transaction.row.getId(), session.getId());
        }
    }

    long nextActionTimestamp() {
        ++this.globalActionTimestamp;
        return this.globalActionTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    Transaction[] getTransactionList() {
        var1_1 = this.database.sessionManager.getAllSessions();
        var2_2 = new int[var1_1.length];
        var4_3 = 0;
        var5_4 = 0;
        for (var6_5 = 0; var6_5 < var1_1.length; ++var6_5) {
            var5_4 += var1_1[var6_5].getTransactionSize();
        }
        var3_7 = new Transaction[var5_4];
        block1: while (true) {
            var5_4 = 0;
            var6_6 = 0x7FFFFFFFFFFFFFFFL;
            var8_8 = 0;
            for (var9_10 = 0; var9_10 < var1_1.length; ++var9_10) {
                var10_11 = var1_1[var9_10].getTransactionSize();
                if (var2_2[var9_10] >= var10_11) continue;
                var11_13 = (Transaction)var1_1[var9_10].rowActionList.get(var2_2[var9_10]);
                if (var11_13.SCN < var6_6) {
                    var6_6 = var11_13.SCN;
                    var8_8 = var9_10;
                }
                var5_4 = 1;
            }
            if (var5_4 == 0) break;
            var9_9 = var1_1[var8_8].rowActionList;
            while (true) {
                if (var2_2[var8_8] >= var9_9.size()) continue block1;
                var10_12 = (Transaction)var9_9.get(var2_2[var8_8]);
                if (var10_12.SCN == var6_6 + 1L) {
                    ++var6_6;
                }
                if (var10_12.SCN == var6_6) ** break;
                continue block1;
                var3_7[var4_3++] = var10_12;
                v0 = var8_8;
                var2_2[v0] = var2_2[v0] + 1;
            }
            break;
        }
        return var3_7;
    }

    public DoubleIntIndex getTransactionIDList() {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(10, false);
        doubleIntIndex.setKeysSearchTarget();
        for (int i2 = 0; i2 < sessionArray.length; ++i2) {
            HsqlArrayList hsqlArrayList = sessionArray[i2].rowActionList;
            int n2 = hsqlArrayList.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                Transaction transaction = (Transaction)hsqlArrayList.get(i3);
                if (transaction.tTable.getTableType() != 4) continue;
                doubleIntIndex.addUnique(transaction.row.getPos(), 0);
            }
        }
        return doubleIntIndex;
    }

    public void convertTransactionIDs(DoubleIntIndex doubleIntIndex) {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        for (int i2 = 0; i2 < sessionArray.length; ++i2) {
            HsqlArrayList hsqlArrayList = sessionArray[i2].rowActionList;
            int n2 = hsqlArrayList.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                Transaction transaction = (Transaction)hsqlArrayList.get(i3);
                if (transaction.tTable.getTableType() != 4) continue;
                int n3 = doubleIntIndex.lookupFirstEqual(transaction.row.getPos());
                transaction.row.setPos(n3);
            }
        }
    }
}

