/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.util.Locale;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Token;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;

public class Tokenizer {
    private static final int NO_TYPE = 0;
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int DECIMAL = 8;
    private static final int BOOLEAN = 9;
    private static final int DATE = 10;
    private static final int TIME = 11;
    private static final int TIMESTAMP = 12;
    private static final int NULL = 13;
    private static final int NAMED_PARAM = 14;
    private static final int QUOTED_IDENTIFIER = 15;
    private static final int REMARK_LINE = 16;
    private static final int REMARK = 17;
    private String sCommand;
    private int iLength;
    private int iIndex;
    private int tokenIndex;
    private int nextTokenIndex;
    private int beginIndex;
    private int iType;
    private String sToken;
    private int indexLongNameFirst = -1;
    private String sLongNameFirst = null;
    private int typeLongNameFirst;
    private boolean retainFirst = false;
    private boolean bWait;
    private boolean lastTokenQuotedID;
    static IntValueHashMap valueTokens = new IntValueHashMap();
    static BigDecimal LONG_MAX_VALUE_INCREMENT;

    public Tokenizer() {
    }

    public Tokenizer(String string) {
        this.sCommand = string;
        this.iLength = string.length();
        this.iIndex = 0;
    }

    public void reset(String string) {
        this.sCommand = string;
        this.iLength = string.length();
        this.iIndex = 0;
        this.tokenIndex = 0;
        this.nextTokenIndex = 0;
        this.beginIndex = 0;
        this.iType = 0;
        this.typeLongNameFirst = 0;
        this.sToken = null;
        this.indexLongNameFirst = -1;
        this.sLongNameFirst = null;
        this.bWait = false;
        this.lastTokenQuotedID = false;
        this.retainFirst = false;
    }

    void back() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        this.nextTokenIndex = this.iIndex;
        this.iIndex = this.indexLongNameFirst != -1 ? this.indexLongNameFirst : this.tokenIndex;
        this.bWait = true;
    }

    String getThis(String string) throws HsqlException {
        this.getToken();
        this.matchThis(string);
        return this.sToken;
    }

    void matchThis(String string) throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        if (!this.sToken.equals(string) || this.iType == 15 || this.iType == 2) {
            String string2 = this.iType == 2 ? this.sLongNameFirst : this.sToken;
            throw Trace.error(11, 160, new Object[]{string2, string});
        }
    }

    void throwUnexpected() throws HsqlException {
        String string = this.iType == 2 ? this.sLongNameFirst : this.sToken;
        throw Trace.error(11, string);
    }

    public boolean isGetThis(String string) throws HsqlException {
        this.getToken();
        if (this.iType != 15 && this.iType != 2 && this.sToken.equals(string)) {
            return true;
        }
        this.back();
        return false;
    }

    boolean wasValue() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        switch (this.iType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    boolean wasQuotedIdentifier() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.lastTokenQuotedID;
    }

    boolean wasFirstQuotedIdentifier() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.typeLongNameFirst == 15;
    }

    boolean wasLongName() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.iType == 2;
    }

    boolean wasSimpleName() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        if (this.iType == 15 && this.sToken.length() != 0) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !Token.isKeyword(this.sToken);
    }

    boolean wasParameter() throws HsqlException {
        Trace.doAssert(!this.bWait, "Querying state when in Wait mode");
        return this.iType == 14;
    }

    boolean wasName() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        if (this.iType == 15) {
            return true;
        }
        if (this.iType != 1 && this.iType != 2) {
            return false;
        }
        return !Token.isKeyword(this.sToken);
    }

    String getLongNamePre() throws HsqlException {
        return null;
    }

    String getLongNameFirst() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        return this.sLongNameFirst;
    }

    boolean wasSimpleToken() throws HsqlException {
        return this.iType != 15 && this.iType != 2 && this.iType != 6 && this.iType != 14;
    }

    String getSimpleToken() throws HsqlException {
        this.getToken();
        if (!this.wasSimpleToken()) {
            String string = this.iType == 2 ? this.sLongNameFirst : this.sToken;
            throw Trace.error(11, string);
        }
        return this.sToken;
    }

    public boolean wasThis(String string) throws HsqlException {
        return this.sToken.equals(string) && this.iType != 15 && this.iType != 2 && this.iType != 6;
    }

    public String getName() throws HsqlException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(11, this.sToken);
        }
        return this.sToken;
    }

    public String getSimpleName() throws HsqlException {
        this.getToken();
        if (!this.wasSimpleName()) {
            String string = this.iType == 2 ? this.sLongNameFirst : this.sToken;
            throw Trace.error(11, string);
        }
        return this.sToken;
    }

    public String getString() throws HsqlException {
        this.getToken();
        return this.sToken;
    }

    int getInt() throws HsqlException {
        long l2 = this.getBigint();
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw Trace.error(16, Types.getTypeString(this.getType()));
        }
        return (int)l2;
    }

    long getBigint() throws HsqlException {
        boolean bl = false;
        this.getToken();
        if (this.sToken.equals("-")) {
            bl = true;
            this.getToken();
        }
        Object object = this.getAsValue();
        int n2 = this.getType();
        switch (n2) {
            case -5: 
            case 4: {
                break;
            }
            case 3: {
                if (bl && LONG_MAX_VALUE_INCREMENT.equals(object)) {
                    return Long.MIN_VALUE;
                }
            }
            default: {
                throw Trace.error(16, Types.getTypeString(n2));
            }
        }
        long l2 = ((Number)object).longValue();
        return bl ? -l2 : l2;
    }

    Object getInType(int n2) throws HsqlException {
        this.getToken();
        Object object = this.getAsValue();
        int n3 = this.getType();
        if (n3 != n2) {
            throw Trace.error(16, Types.getTypeString(n3));
        }
        return object;
    }

    public int getType() throws HsqlException {
        if (this.bWait) {
            Trace.doAssert(false, "Querying state when in Wait mode");
        }
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 16;
            }
            case 10: {
                return 91;
            }
            case 11: {
                return 92;
            }
            case 12: {
                return 93;
            }
        }
        return 0;
    }

    Object getAsValue() throws HsqlException {
        if (!this.wasValue()) {
            throw Trace.error(11, this.sToken);
        }
        switch (this.iType) {
            case 13: {
                return null;
            }
            case 6: {
                return this.sToken;
            }
            case 7: {
                return ValuePool.getLong(Long.parseLong(this.sToken));
            }
            case 4: {
                if (this.sToken.length() < 11) {
                    try {
                        return ValuePool.getInt(Integer.parseInt(this.sToken));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.sToken.length() < 20) {
                    try {
                        this.iType = 7;
                        return ValuePool.getLong(Long.parseLong(this.sToken));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.iType = 8;
                return new BigDecimal(this.sToken);
            }
            case 5: {
                double d2 = JavaSystem.parseDouble(this.sToken);
                long l2 = Double.doubleToLongBits(d2);
                return ValuePool.getDouble(l2);
            }
            case 8: {
                return new BigDecimal(this.sToken);
            }
            case 9: {
                return this.sToken.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return HsqlDateTime.dateValue(this.sToken);
            }
            case 11: {
                return HsqlDateTime.timeValue(this.sToken);
            }
            case 12: {
                return HsqlDateTime.timestampValue(this.sToken);
            }
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int n2, int n3) {
        return this.sCommand.substring(n2, n3);
    }

    int getPartMarker() {
        return this.beginIndex;
    }

    void setPartMarker() {
        this.beginIndex = this.iIndex;
    }

    void setPartMarker(int n2) {
        this.beginIndex = n2;
    }

    String getLastPart() {
        return this.sCommand.substring(this.beginIndex, this.iIndex);
    }

    private void getToken() throws HsqlException {
        if (this.bWait) {
            this.bWait = false;
            this.iIndex = this.nextTokenIndex;
            return;
        }
        if (!this.retainFirst) {
            this.sLongNameFirst = null;
            this.indexLongNameFirst = -1;
            this.typeLongNameFirst = 0;
        }
        while (this.iIndex < this.iLength && Character.isWhitespace(this.sCommand.charAt(this.iIndex))) {
            ++this.iIndex;
        }
        this.sToken = "";
        this.tokenIndex = this.iIndex;
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        char c2 = this.sCommand.charAt(this.iIndex);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        char c3 = '\u0000';
        this.lastTokenQuotedID = false;
        if (Character.isJavaIdentifierStart(c2)) {
            this.iType = 1;
        } else if (Character.isDigit(c2)) {
            this.iType = 4;
            bl2 = true;
        } else {
            switch (c2) {
                case '(': {
                    this.sToken = "(";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ')': {
                    this.sToken = ")";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ',': {
                    this.sToken = ",";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '*': {
                    this.sToken = "*";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '=': {
                    this.sToken = "=";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ';': {
                    this.sToken = ";";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '+': {
                    this.sToken = "+";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '%': {
                    this.sToken = "%";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case '?': {
                    this.sToken = "?";
                    this.iType = 3;
                    ++this.iIndex;
                    return;
                }
                case ':': {
                    Trace.check(++this.iIndex < this.iLength, 12);
                    c2 = this.sCommand.charAt(this.iIndex);
                    Trace.check(Character.isJavaIdentifierStart(c2), 74, ":" + c2);
                    this.iType = 14;
                    break;
                }
                case '\"': {
                    this.lastTokenQuotedID = true;
                    this.iType = 15;
                    ++this.iIndex;
                    this.sToken = this.getString('\"');
                    if (this.iIndex == this.sCommand.length()) {
                        return;
                    }
                    c2 = this.sCommand.charAt(this.iIndex);
                    if (c2 == '.') {
                        this.sLongNameFirst = this.sToken;
                        this.indexLongNameFirst = this.tokenIndex;
                        this.typeLongNameFirst = this.iType;
                        ++this.iIndex;
                        if (this.retainFirst) {
                            throw Trace.error(226);
                        }
                        this.retainFirst = true;
                        this.getToken();
                        this.retainFirst = false;
                        this.iType = 2;
                    }
                    return;
                }
                case '\'': {
                    this.iType = 6;
                    ++this.iIndex;
                    this.sToken = this.getString('\'');
                    return;
                }
                case '!': 
                case '-': 
                case '/': 
                case '<': 
                case '>': 
                case '|': {
                    c3 = c2;
                    this.iType = 3;
                    break;
                }
                case '.': {
                    this.iType = 8;
                    bl = true;
                    break;
                }
                default: {
                    throw Trace.error(11, String.valueOf(c2));
                }
            }
        }
        int n2 = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                c2 = ' ';
                bl5 = true;
                Trace.check(this.iType != 6 && this.iType != 15, 12);
            } else {
                c2 = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: 
                case 14: {
                    int n3;
                    if (Character.isJavaIdentifierPart(c2)) break;
                    this.sToken = this.sCommand.substring(n2, this.iIndex).toUpperCase(Locale.ENGLISH);
                    if (this.iType == 14) {
                        return;
                    }
                    if (c2 == '.') {
                        this.typeLongNameFirst = this.iType;
                        this.sLongNameFirst = this.sToken;
                        this.indexLongNameFirst = this.tokenIndex;
                        ++this.iIndex;
                        if (this.retainFirst) {
                            throw Trace.error(226);
                        }
                        this.retainFirst = true;
                        this.getToken();
                        this.retainFirst = false;
                        this.iType = 2;
                    } else if (c2 != '(' && (n3 = valueTokens.get((Object)this.sToken, -1)) != -1) {
                        this.iType = n3;
                    }
                    return;
                }
                case 6: 
                case 15: {
                    break;
                }
                case 17: {
                    if (bl5) {
                        this.iType = 0;
                        return;
                    }
                    if (c2 != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 16: {
                    if (bl5) {
                        this.iType = 0;
                        return;
                    }
                    if (c2 != '\r' && c2 != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (c2 == '/' && c3 == '/') {
                        this.iType = 16;
                        break;
                    }
                    if (c2 == '-' && c3 == '-') {
                        this.iType = 16;
                        break;
                    }
                    if (c2 == '*' && c3 == '/') {
                        this.iType = 17;
                        break;
                    }
                    if (c2 == '>' || c2 == '=' || c2 == '|') break;
                    this.sToken = this.sCommand.substring(n2, this.iIndex);
                    return;
                }
                case 4: 
                case 5: 
                case 8: {
                    if (Character.isDigit(c2)) {
                        bl2 = true;
                        break;
                    }
                    if (c2 == '.') {
                        this.iType = 8;
                        if (bl) {
                            throw Trace.error(11, ".");
                        }
                        bl = true;
                        break;
                    }
                    if (c2 == 'E' || c2 == 'e') {
                        if (bl3) {
                            throw Trace.error(11, "E");
                        }
                        this.iType = 5;
                        bl4 = true;
                        bl = true;
                        bl3 = true;
                        break;
                    }
                    if (c2 == '-' && bl4) {
                        bl4 = false;
                        break;
                    }
                    if (c2 == '+' && bl4) {
                        bl4 = false;
                        break;
                    }
                    bl4 = false;
                    if (!bl2) {
                        if (bl && n2 == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(11, String.valueOf(c2));
                    }
                    this.sToken = this.sCommand.substring(n2, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    private String getString(char c2) throws HsqlException {
        try {
            int n2 = this.iIndex;
            boolean bl = false;
            while (true) {
                if ((n2 = this.sCommand.indexOf(c2, n2)) < 0) {
                    throw Trace.error(12);
                }
                if (n2 >= this.iLength - 1 || this.sCommand.charAt(n2 + 1) != c2) break;
                bl = true;
                n2 += 2;
            }
            char[] cArray = new char[n2 - this.iIndex];
            this.sCommand.getChars(this.iIndex, n2, cArray, 0);
            int n3 = cArray.length;
            if (bl) {
                n3 = 0;
                int n4 = 0;
                while (n4 < cArray.length) {
                    if (cArray[n4] == c2) {
                        ++n4;
                    }
                    cArray[n3] = cArray[n4];
                    ++n4;
                    ++n3;
                }
            }
            this.iIndex = ++n2;
            return new String(cArray, 0, n3);
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Exception exception) {
            exception.toString();
            return null;
        }
    }

    int getLength() {
        return this.iLength;
    }

    static {
        valueTokens.put("NULL", 13);
        valueTokens.put("TRUE", 9);
        valueTokens.put("FALSE", 9);
        LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    }
}

