/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;

class TextTable
extends Table {
    private String dataSource = "";
    private boolean isReversed = false;
    private boolean isConnected = false;

    TextTable(Database database, HsqlNameManager.HsqlName hsqlName, int n2) throws HsqlException {
        super(database, hsqlName, n2);
    }

    private void onConnectError(Session session) {
        if (this.cache != null) {
            try {
                this.cache.close(false);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        this.cache = null;
        this.clearAllRows(session);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void connect(Session session) throws HsqlException {
        this.connect(session, this.isReadOnly);
    }

    private void connect(Session session, boolean bl) throws HsqlException {
        if (this.dataSource.length() == 0 || this.isConnected) {
            return;
        }
        try {
            this.cache = this.database.logger.openTextCache(this, this.dataSource, bl, this.isReversed);
            CachedRow cachedRow = null;
            int n2 = 0;
            if (((TextCache)this.cache).ignoreFirst) {
                n2 += ((TextCache)this.cache).readHeaderLine();
            }
            while ((cachedRow = (CachedRow)this.rowStore.get(n2)) != null) {
                n2 = cachedRow.getPos() + cachedRow.getStorageSize();
                cachedRow.setNewNodes();
                this.insertFromTextSource(cachedRow);
            }
        }
        catch (HsqlException hsqlException) {
            int n3 = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
            this.onConnectError(session);
            throw Trace.error(76, new Object[]{new Integer(n3), hsqlException.getMessage()});
        }
        catch (RuntimeException runtimeException) {
            int n4 = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
            this.onConnectError(session);
            throw Trace.error(76, new Object[]{new Integer(n4), runtimeException.getClass().getName() + ": " + runtimeException.getMessage()});
        }
        this.isConnected = true;
        this.setIsReadOnly(bl);
    }

    public void disconnect(Session session) throws HsqlException {
        this.database.logger.closeTextCache(this);
        this.cache = null;
        this.clearAllRows(session);
        this.isConnected = false;
    }

    private void openCache(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        if (string == null) {
            string = "";
        }
        this.disconnect(session);
        this.dataSource = string;
        this.isReversed = bl && this.dataSource.length() > 0;
        this.connect(session, bl2);
    }

    protected void setDataSource(Session session, String string, boolean bl, boolean bl2) throws HsqlException {
        if (this.getTableType() != 5) {
            session.checkAdmin();
        }
        string = string.trim();
        if (bl2 && FileUtil.getDefaultInstance().exists(string)) {
            throw Trace.error(196, string);
        }
        if (bl || bl != this.isReversed || !this.dataSource.equals(string) || !this.isConnected) {
            this.openCache(session, string, bl, this.isReadOnly);
        }
        if (this.isReversed) {
            this.setIsReadOnly(true);
        }
    }

    protected String getDataSource() {
        return this.dataSource;
    }

    protected boolean isDescDataSource() {
        return this.isReversed;
    }

    public void setHeader(String string) throws HsqlException {
        if (this.cache != null && ((TextCache)this.cache).ignoreFirst) {
            ((TextCache)this.cache).setHeader(string);
            return;
        }
        throw Trace.error(150);
    }

    public String getHeader() {
        String string = this.cache == null ? null : ((TextCache)this.cache).getHeader();
        return string == null ? null : StringConverter.toQuotedString(string, '\"', true);
    }

    void checkDataReadOnly() throws HsqlException {
        if (this.dataSource.length() == 0) {
            throw Trace.error(48);
        }
        if (this.isDataReadOnly()) {
            throw Trace.error(32);
        }
    }

    public boolean isDataReadOnly() {
        return !this.isConnected() || super.isDataReadOnly();
    }

    void setDataReadOnly(boolean bl) throws HsqlException {
        if (this.isReversed && !bl) {
            throw Trace.error(32);
        }
        this.openCache(null, this.dataSource, this.isReversed, bl);
        this.setIsReadOnly(bl);
    }

    boolean isIndexCached() {
        return false;
    }

    protected Table duplicate() throws HsqlException {
        return new TextTable(this.database, this.tableName, this.getTableType());
    }

    void drop() throws HsqlException {
        this.openCache(null, "", false, false);
    }

    void setIndexRoots(String string) throws HsqlException {
    }
}

