/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingLen;
    int iOrderLen;
    int[] sortOrder;
    int[] sortDirection;
    boolean sortUnion;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType;
    Select[] unionArray;
    int unionMaxDepth;
    Select unionSelect;
    int unionType;
    int unionDepth;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private boolean simpleLimit;
    Result.ResultMetaData resultMetaData;
    IntKeyHashMap asteriskPositions;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < this.iResultLen; ++i2) {
            String string = this.exprColumns[i2].getAlias();
            if (string == null) continue;
            hashMap.put(string, this.exprColumns[i2]);
        }
        return hashMap;
    }

    void resolve(Session session) throws HsqlException {
        this.resolveTables();
        this.resolveTypes(session);
        this.setFilterConditions(session);
    }

    private void resolveTables() throws HsqlException {
        int n2;
        int n3;
        for (n3 = this.iResultLen; n3 < this.exprColumns.length; ++n3) {
            if (this.exprColumns[n3].getType() == 2) {
                if (this.exprColumns[n3].joinedTableColumnIndex != -1) continue;
                n2 = this.exprColumns[n3].isDescending() ? 1 : 0;
                this.exprColumns[n3] = this.exprColumns[n3].getExpressionForAlias(this.exprColumns, this.iResultLen);
                if (n2 == 0) continue;
                this.exprColumns[n3].setDescending();
                continue;
            }
            this.exprColumns[n3].replaceAliases(this.exprColumns, this.iResultLen);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceAliases(this.exprColumns, this.iResultLen);
        }
        n3 = this.tFilter.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.resolveTables(this.tFilter[n2]);
        }
    }

    void resolveUnionColumnTypes() throws HsqlException {
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            for (int i2 = 0; i2 < this.iResultLen; ++i2) {
                Expression expression = this.exprColumns[i2];
                if (expression.isTypeEqual(this.unionSelect.exprColumns[i2])) continue;
                this.unionSelect.exprColumns[i2] = new Expression(this.unionSelect.exprColumns[i2], expression.getDataType(), expression.getColumnSize(), expression.getColumnScale());
            }
        }
    }

    void resolveTypes(Session session) throws HsqlException {
        int n2 = this.exprColumns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.exprColumns[i2].resolveTypes(session);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session);
        }
    }

    void resolveTablesUnion(TableFilter tableFilter) throws HsqlException {
        if (this.unionArray == null) {
            this.resolveTables(tableFilter);
        } else {
            for (int i2 = 0; i2 < this.unionArray.length; ++i2) {
                this.unionArray[i2].resolveTables(tableFilter);
            }
        }
    }

    void resolveTables(TableFilter tableFilter) throws HsqlException {
        int n2 = this.exprColumns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.exprColumns[i2].resolveTables(tableFilter);
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(tableFilter);
        }
    }

    private void setFilterConditions(Session session) throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        for (int i2 = 0; i2 < this.tFilter.length; ++i2) {
            this.tFilter[i2].setConditions(session, this.queryCondition);
        }
    }

    boolean checkResolved(boolean bl) throws HsqlException {
        int n2;
        boolean bl2 = true;
        int n3 = this.exprColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            bl2 = bl2 && this.exprColumns[n2].checkResolved(bl);
        }
        if (this.queryCondition != null) {
            boolean bl3 = bl2 = bl2 && this.queryCondition.checkResolved(bl);
        }
        if (this.havingCondition != null) {
            bl2 = bl2 && this.havingCondition.checkResolved(bl);
        }
        for (n2 = 0; n2 < this.tFilter.length; ++n2) {
            if (this.tFilter[n2].filterIndex != null) continue;
            this.tFilter[n2].filterIndex = this.tFilter[n2].filterTable.getPrimaryIndex();
        }
        return bl2;
    }

    Object getValue(Session session, int n2) throws HsqlException {
        this.resolve(session);
        Result result = this.getResult(session, 2);
        int n3 = result.getSize();
        int n4 = result.getColumnCount();
        if (n4 == 1) {
            if (n3 == 0) {
                return null;
            }
            if (n3 == 1) {
                Object object = result.rRoot.data[0];
                return result.metaData.colTypes[0] == n2 ? object : Column.convertObject(object, n2);
            }
            throw Trace.error(17);
        }
        HsqlException hsqlException = Trace.error(17);
        throw new HsqlInternalException(hsqlException);
    }

    void prepareResult(Session session) throws HsqlException {
        int n2;
        this.resolveAll(session, true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            for (n2 = this.iResultLen; n2 < this.iResultLen + this.iGroupLen; ++n2) {
                this.exprColumns[n2].collectAllColumnNames(this.groupColumnNames);
            }
        }
        n2 = this.exprColumns.length;
        Result.ResultMetaData resultMetaData = this.resultMetaData = new Result.ResultMetaData(n2);
        int n3 = this.iResultLen;
        int n4 = n3 + this.iGroupLen;
        int n5 = n4 + this.iHavingLen;
        int n6 = n5 + this.iOrderLen;
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = this.exprColumns[i2];
            resultMetaData.colTypes[i2] = expression.getDataType();
            resultMetaData.colSizes[i2] = expression.getColumnSize();
            resultMetaData.colScales[i2] = expression.getColumnScale();
            if (expression.isAggregate()) {
                this.isAggregated = true;
            }
            if (i2 >= n3 && i2 < n4 && !this.exprColumns[i2].canBeInGroupBy()) {
                Trace.error(68, this.exprColumns[i2]);
            }
            if (i2 >= n4 && i2 < n4 + this.iHavingLen && !this.exprColumns[i2].isConditional()) {
                Trace.error(69, this.exprColumns[i2]);
            }
            if (i2 >= n5 && i2 < n6 && !this.exprColumns[i2].canBeInOrderBy()) {
                Trace.error(70, this.exprColumns[i2]);
            }
            if (i2 >= this.iResultLen) continue;
            resultMetaData.colLabels[i2] = expression.getAlias();
            resultMetaData.isLabelQuoted[i2] = expression.isAliasQuoted();
            resultMetaData.schemaNames[i2] = expression.getTableSchemaName();
            resultMetaData.tableNames[i2] = expression.getTableName();
            resultMetaData.colNames[i2] = expression.getColumnName();
            if (resultMetaData.isTableColumn(i2)) {
                resultMetaData.colNullable[i2] = expression.nullability;
                resultMetaData.isIdentity[i2] = expression.isIdentity;
                resultMetaData.isWritable[i2] = expression.isWritable;
            }
            resultMetaData.classNames[i2] = expression.getValueClassName();
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        this.checkAggregateOrGroupByColumns(n4, n5);
        this.checkAggregateOrGroupByOrderColumns(n5, n6);
        this.prepareSort();
        this.simpleLimit = !this.isDistinctSelect && !this.isGrouped && this.unionSelect == null && this.iOrderLen == 0;
    }

    void prepareUnions() throws HsqlException {
        int n2 = 0;
        Select select = this;
        while (select != null) {
            select = select.unionSelect;
            ++n2;
        }
        if (n2 == 1) {
            if (this.unionDepth != 0) {
                throw Trace.error(121);
            }
            return;
        }
        this.unionArray = new Select[n2];
        n2 = 0;
        select = this;
        while (select != null) {
            this.unionArray[n2] = select;
            this.unionMaxDepth = select.unionDepth > this.unionMaxDepth ? select.unionDepth : this.unionMaxDepth;
            select = select.unionSelect;
            ++n2;
        }
        if (this.unionArray[this.unionArray.length - 1].unionDepth != 0) {
            throw Trace.error(121);
        }
    }

    Result getResult(Session session, int n2) throws HsqlException {
        Result result;
        if (this.unionArray == null) {
            result = this.getSingleResult(session, n2);
        } else {
            result = this.getResultMain(session);
            if (this.sortUnion) {
                this.sortResult(session, result);
                result.trimResult(this.getLimitStart(session), this.getLimitCount(session, n2));
            }
        }
        result.setColumnCount(this.iResultLen);
        return result;
    }

    private Result getResultMain(Session session) throws HsqlException {
        int n2;
        Result[] resultArray = new Result[this.unionArray.length];
        for (n2 = 0; n2 < this.unionArray.length; ++n2) {
            resultArray[n2] = this.unionArray[n2].getSingleResult(session, Integer.MAX_VALUE);
        }
        for (n2 = this.unionMaxDepth; n2 >= 0; --n2) {
            block2: for (int i2 = 0; i2 < 2; ++i2) {
                for (int i3 = 0; i3 < this.unionArray.length - 1; ++i3) {
                    int n3;
                    if (resultArray[i3] == null || this.unionArray[i3].unionDepth < n2 || i2 == 0 && this.unionArray[i3].unionType != 3 || i2 == 1 && this.unionArray[i3].unionType == 3) continue;
                    for (n3 = i3 + 1; n3 < this.unionArray.length && resultArray[n3] == null; ++n3) {
                    }
                    if (n3 == this.unionArray.length) continue block2;
                    this.unionArray[i3].mergeResults(session, resultArray[i3], resultArray[n3]);
                    resultArray[n3] = resultArray[i3];
                    resultArray[i3] = null;
                }
            }
        }
        return resultArray[resultArray.length - 1];
    }

    private void mergeResults(Session session, Result result, Result result2) throws HsqlException {
        switch (this.unionType) {
            case 1: {
                result.append(result2);
                result.removeDuplicates(session, this.iResultLen);
                break;
            }
            case 2: {
                result.append(result2);
                break;
            }
            case 3: {
                result.removeDifferent(session, result2, this.iResultLen);
                break;
            }
            case 4: {
                result.removeSecond(session, result2, this.iResultLen);
            }
        }
    }

    int getLimitStart(Session session) throws HsqlException {
        Integer n2;
        if (this.limitCondition != null && (n2 = (Integer)this.limitCondition.getArg().getValue(session)) != null) {
            return n2;
        }
        return 0;
    }

    int getLimitCount(Session session, int n2) throws HsqlException {
        Integer n3;
        int n4 = 0;
        if (this.limitCondition != null && (n3 = (Integer)this.limitCondition.getArg2().getValue(session)) != null) {
            n4 = n3;
        }
        if (n2 != 0 && (n4 == 0 || n2 < n4)) {
            n4 = n2;
        }
        return n4;
    }

    int getMaxRowCount(Session session, int n2) throws HsqlException {
        int n3 = this.getLimitStart(session);
        int n4 = this.getLimitCount(session, n2);
        if (!this.simpleLimit) {
            n2 = Integer.MAX_VALUE;
        } else {
            if (n2 == 0) {
                n2 = n4;
            }
            n2 = n2 == 0 || n2 > Integer.MAX_VALUE - n3 ? Integer.MAX_VALUE : (n2 += n3);
        }
        return n2;
    }

    private Result getSingleResult(Session session, int n2) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult(session);
        }
        Result result = this.buildResult(session, this.getMaxRowCount(session, n2));
        if (this.isDistinctSelect) {
            result.removeDuplicates(session, this.iResultLen);
        }
        if (!this.sortUnion) {
            this.sortResult(session, result);
            result.trimResult(this.getLimitStart(session), this.getLimitCount(session, n2));
        }
        return result;
    }

    private void prepareSort() {
        int n2;
        if (this.iOrderLen == 0) {
            return;
        }
        this.sortOrder = new int[this.iOrderLen];
        this.sortDirection = new int[this.iOrderLen];
        int n3 = n2 = this.iResultLen + this.iGroupLen + this.iHavingLen;
        for (int i2 = 0; i2 < this.iOrderLen; ++i2) {
            int n4 = n3;
            if (this.exprColumns[n3].joinedTableColumnIndex != -1) {
                n4 = this.exprColumns[n3].joinedTableColumnIndex;
            }
            this.sortOrder[i2] = n4;
            this.sortDirection[i2] = this.exprColumns[n3].isDescending() ? -1 : 1;
            ++n3;
        }
    }

    private void sortResult(Session session, Result result) throws HsqlException {
        if (this.iOrderLen == 0) {
            return;
        }
        result.sortResult(session, this.sortOrder, this.sortDirection);
    }

    private void checkAggregateOrGroupByColumns(int n2, int n3) throws HsqlException {
        if (n2 < n3) {
            int n4;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            for (n4 = n2; n4 < n3; ++n4) {
                this.exprColumns[n4].collectInGroupByExpressions(hsqlArrayList);
            }
            int n5 = hsqlArrayList.size();
            for (n4 = 0; n4 < n5; ++n4) {
                Expression expression = (Expression)hsqlArrayList.get(n4);
                if (this.inAggregateOrGroupByClause(expression)) continue;
                throw Trace.error(67, expression);
            }
        }
    }

    private void checkAggregateOrGroupByOrderColumns(int n2, int n3) throws HsqlException {
        this.checkAggregateOrGroupByColumns(n2, n3);
        if (n2 < n3 && this.isDistinctSelect) {
            int n4;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            for (n4 = n2; n4 < n3; ++n4) {
                this.exprColumns[n4].collectInGroupByExpressions(hsqlArrayList);
            }
            int n5 = hsqlArrayList.size();
            for (n4 = 0; n4 < n5; ++n4) {
                Expression expression = (Expression)hsqlArrayList.get(n4);
                if (this.isSimilarIn(expression, 0, this.iResultLen)) continue;
                throw Trace.error(71, expression);
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression expression) {
        if (this.isGrouped) {
            return this.isSimilarIn(expression, this.iResultLen, this.iResultLen + this.iGroupLen) || Select.allColumnsAreDefinedIn(expression, this.groupColumnNames);
        }
        if (this.isAggregated) {
            return expression.canBeInAggregate();
        }
        return true;
    }

    private boolean isSimilarIn(Expression expression, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!expression.similarTo(this.exprColumns[i2])) continue;
            return true;
        }
        return false;
    }

    static boolean allColumnsAreDefinedIn(Expression expression, HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        expression.collectAllColumnNames(hashSet2);
        if (hashSet2.size() > 0 && hashSet == null) {
            return false;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private Result buildResult(Session session, int n2) throws HsqlException {
        int n3;
        int n4;
        Object[] objectArray;
        boolean bl;
        GroupedResult groupedResult = new GroupedResult(this, this.resultMetaData);
        int n5 = this.exprColumns.length;
        int n6 = this.tFilter.length;
        boolean[] blArray = new boolean[n6];
        boolean[] blArray2 = new boolean[n6];
        int n7 = 0;
        boolean bl2 = bl = this.queryCondition == null || !this.queryCondition.isFixedConditional() || this.queryCondition.testCondition(session);
        while (bl && n7 >= 0) {
            objectArray = this.tFilter[n7];
            if (!blArray[n7]) {
                n4 = objectArray.findFirst(session);
                n3 = objectArray.isOuterJoin && n4 == 0 && !blArray2[n7] && !objectArray.nonJoinIsNull && objectArray.nextOuter(session) ? 1 : 0;
                blArray2[n7] = n3;
                blArray[n7] = n4;
            } else {
                n4 = objectArray.next(session);
                n3 = objectArray.isOuterJoin && n4 == 0 && !blArray[n7] && !blArray2[n7] && !objectArray.nonJoinIsNull && objectArray.nextOuter(session) ? 1 : 0;
                blArray2[n7] = n3;
                blArray[n7] = n4;
            }
            if (n4 == 0 && n3 == 0) {
                --n7;
                continue;
            }
            if (n7 < n6 - 1) {
                ++n7;
                continue;
            }
            while (blArray2[n7]) {
                blArray2[n7--] = false;
            }
            if (this.queryCondition != null && !this.queryCondition.testCondition(session)) continue;
            try {
                int n8;
                Object[] objectArray2 = new Object[n5];
                for (n8 = groupedResult.groupBegin; n8 < groupedResult.groupEnd; ++n8) {
                    objectArray2[n8] = this.exprColumns[n8].getValue(session);
                }
                objectArray2 = groupedResult.getRow(objectArray2);
                for (n8 = 0; n8 < groupedResult.groupBegin; ++n8) {
                    objectArray2[n8] = this.isAggregated && this.exprColumns[n8].isAggregate() ? this.exprColumns[n8].updateAggregatingValue(session, objectArray2[n8]) : this.exprColumns[n8].getValue(session);
                }
                for (n8 = groupedResult.groupEnd; n8 < n5; ++n8) {
                    objectArray2[n8] = this.isAggregated && this.exprColumns[n8].isAggregate() ? this.exprColumns[n8].updateAggregatingValue(session, objectArray2[n8]) : this.exprColumns[n8].getValue(session);
                }
                groupedResult.addRow(objectArray2);
                if (groupedResult.size() < n2) continue;
                break;
            }
            catch (HsqlInternalException hsqlInternalException) {
            }
        }
        if (this.isAggregated && !this.isGrouped && groupedResult.size() == 0) {
            objectArray = new Object[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                objectArray[n4] = this.exprColumns[n4].isAggregate() ? null : this.exprColumns[n4].getValue(session);
            }
            groupedResult.addRow(objectArray);
        }
        objectArray = groupedResult.iterator();
        while (objectArray.hasNext()) {
            Object[] objectArray3 = (Object[])objectArray.next();
            if (this.isAggregated) {
                for (n3 = 0; n3 < n5; ++n3) {
                    if (!this.exprColumns[n3].isAggregate()) continue;
                    objectArray3[n3] = this.exprColumns[n3].getAggregatedValue(session, objectArray3[n3]);
                }
            }
            if (this.iHavingLen <= 0 || Boolean.TRUE.equals(objectArray3[this.iResultLen + this.iGroupLen])) continue;
            objectArray.remove();
        }
        return groupedResult.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        TableFilter tableFilter;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        for (n2 = 0; n2 < this.iResultLen; ++n2) {
            stringBuffer.append(this.exprColumns[n2].getDDL());
            if (n2 >= this.iResultLen - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append("FROM");
        for (n2 = 0; n2 < this.tFilter.length; ++n2) {
            tableFilter = this.tFilter[n2];
            if (n2 != 0 && tableFilter.isOuterJoin) {
                stringBuffer.append("FROM").append(' ');
                stringBuffer.append("JOIN").append(' ');
            }
            stringBuffer.append(',');
        }
        stringBuffer.append(' ').append("WHERE").append(' ');
        for (n2 = 0; n2 < this.tFilter.length; ++n2) {
            tableFilter = this.tFilter[n2];
        }
        stringBuffer.append(' ').append("GROUP").append(' ');
        for (n2 = this.iResultLen; n2 < this.iResultLen + this.iGroupLen; ++n2) {
            stringBuffer.append(this.exprColumns[n2].getDDL());
            if (n2 >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(' ').append("HAVING").append(' ');
        for (n2 = this.iResultLen + this.iGroupLen; n2 < this.iResultLen + this.iGroupLen + this.iHavingLen; ++n2) {
            stringBuffer.append(this.exprColumns[n2].getDDL());
            if (n2 >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    stringBuffer.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    stringBuffer.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    stringBuffer.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        n2 = this.iResultLen + this.iGroupLen;
        int n3 = n2 + this.iHavingLen;
        int n4 = n3 + this.iOrderLen;
        stringBuffer.append(' ').append("ORDER").append("BY").append(' ');
        for (int i2 = n3; i2 < n4; ++i2) {
            stringBuffer.append(this.exprColumns[i2].getDDL());
            if (i2 >= this.iResultLen + this.iGroupLen - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer;
    }

    boolean resolveAll(Session session, boolean bl) throws HsqlException {
        if (this.isResolved) {
            return true;
        }
        this.resolve(session);
        this.isResolved = this.checkResolved(bl);
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            for (int i2 = 0; i2 < this.iResultLen; ++i2) {
                Expression expression = this.exprColumns[i2];
                if (expression.isTypeEqual(this.unionSelect.exprColumns[i2])) continue;
                this.unionSelect.exprColumns[i2] = new Expression(this.unionSelect.exprColumns[i2], expression.getDataType(), expression.getColumnSize(), expression.getColumnScale());
            }
            this.isResolved &= this.unionSelect.resolveAll(session, bl);
        }
        return this.isResolved;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String describe(Session session) {
        int n2;
        try {
            this.getResult(session, 1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            stringBuffer.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            stringBuffer.append("offset=[").append(this.limitCondition.getArg().describe(session)).append("]\n");
            stringBuffer.append("limit=[").append(this.limitCondition.getArg2().describe(session)).append("]\n");
        }
        stringBuffer.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer.append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer.append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer.append("columns=[");
        int n3 = this.exprColumns.length - this.iOrderLen;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(this.exprColumns[n2].describe(session));
        }
        stringBuffer.append("\n]\n");
        stringBuffer.append("tableFilters=[\n");
        for (n2 = 0; n2 < this.tFilter.length; ++n2) {
            stringBuffer.append("[\n");
            stringBuffer.append(this.tFilter[n2].describe(session));
            stringBuffer.append("\n]");
        }
        stringBuffer.append("]\n");
        String string = this.queryCondition == null ? "null" : this.queryCondition.describe(session);
        stringBuffer.append("eCondition=[").append(string).append("]\n");
        string = this.havingCondition == null ? "null" : this.havingCondition.describe(session);
        stringBuffer.append("havingCondition=[").append(string).append("]\n");
        stringBuffer.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    stringBuffer.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" UNION ");
                    break;
                }
                case 2: {
                    stringBuffer.append(" UNION ALL ");
                    break;
                }
                default: {
                    stringBuffer.append(" UNKNOWN SET OPERATION ");
                }
            }
            stringBuffer.append("[\n").append(this.unionSelect.describe(session)).append("]\n");
        }
        return stringBuffer.toString();
    }

    Result describeResult() {
        Result result = new Result(3, this.iResultLen);
        Result.ResultMetaData resultMetaData = result.metaData;
        for (int i2 = 0; i2 < this.iResultLen; ++i2) {
            Expression expression = this.exprColumns[i2];
            resultMetaData.colTypes[i2] = expression.getDataType();
            resultMetaData.colSizes[i2] = expression.getColumnSize();
            resultMetaData.colScales[i2] = expression.getColumnScale();
            resultMetaData.colLabels[i2] = expression.getAlias();
            resultMetaData.isLabelQuoted[i2] = expression.isAliasQuoted();
            resultMetaData.tableNames[i2] = expression.getTableName();
            resultMetaData.colNames[i2] = expression.getColumnName();
            if (!resultMetaData.isTableColumn(i2)) continue;
            resultMetaData.colNullable[i2] = expression.nullability;
            resultMetaData.isIdentity[i2] = expression.isIdentity;
            resultMetaData.isWritable[i2] = expression.isWritable;
        }
        return result;
    }
}

