/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.rowio.RowOutputInterface;

public class Row
implements CachedObject {
    int tableId;
    int iPos;
    protected Object[] oData;
    protected Node nPrimaryNode;

    protected Row() {
    }

    Row(Table table, Object[] objectArray) throws HsqlException {
        int n2 = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        for (int i2 = 1; i2 < n2; ++i2) {
            node = node.nNext = Node.newNode(this, i2, table);
        }
        this.tableId = table.getId();
        this.oData = objectArray;
    }

    Node getNode(int n2) {
        Node node = this.nPrimaryNode;
        while (n2-- > 0) {
            node = node.nNext;
        }
        return node;
    }

    Node getNextNode(Node node) {
        node = node == null ? this.nPrimaryNode : node.nNext;
        return node;
    }

    Row getUpdatedRow() throws HsqlException {
        return this;
    }

    public Object[] getData() {
        return this.oData;
    }

    void delete() throws HsqlException {
        ++JavaSystem.memoryRecords;
        this.nPrimaryNode = null;
    }

    void clearNodeLinks() {
        Node node = this.nPrimaryNode;
        while (node.nNext != null) {
            Node node2 = node.nNext;
            node.nNext = null;
            node = node2;
        }
        this.nPrimaryNode = null;
    }

    boolean isCascadeDeleted() {
        return this.nPrimaryNode == null;
    }

    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 0;
    }

    public void setStorageSize(int n2) {
    }

    public int getStorageSize() {
        return 0;
    }

    public long getId() {
        return ((long)this.tableId << 32) + (long)this.iPos;
    }

    public static long getId(Table table, int n2) {
        return ((long)table.getId() << 32) + (long)n2;
    }

    public int getPos() {
        return this.iPos;
    }

    public void setPos(int n2) {
        this.iPos = n2;
    }

    public boolean hasChanged() {
        return false;
    }

    public boolean isKeepInMemory() {
        return true;
    }

    public void keepInMemory(boolean bl) {
    }

    public boolean isInMemory() {
        return true;
    }

    public void setInMemory(boolean bl) {
    }

    public void write(RowOutputInterface rowOutputInterface) {
    }

    public void write(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Row) {
            return ((Row)object).iPos == this.iPos;
        }
        return false;
    }

    public int hashCode() {
        return this.iPos;
    }
}

