/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;

public class NumberSequence {
    HsqlNameManager.HsqlName name;
    private long startValue;
    private long currValue;
    private long lastValue;
    private long increment;
    private int dataType;

    public NumberSequence(HsqlNameManager.HsqlName hsqlName, long l2, long l3, int n2) {
        this.name = hsqlName;
        this.currValue = this.lastValue = l2;
        this.startValue = this.lastValue;
        this.increment = l3;
        this.dataType = n2;
    }

    synchronized long getValue() {
        long l2 = this.currValue;
        this.currValue += this.increment;
        return l2;
    }

    synchronized long getValue(long l2) {
        if (l2 >= this.currValue) {
            this.currValue = l2;
            this.currValue += this.increment;
            return l2;
        }
        return l2;
    }

    Object getValueObject() {
        long l2 = this.currValue;
        this.currValue += this.increment;
        Number number = this.dataType == 4 ? (Number)new Integer((int)l2) : (Number)new Long(l2);
        return number;
    }

    void reset() {
        this.lastValue = this.currValue = this.startValue;
    }

    public long peek() {
        return this.currValue;
    }

    boolean wasUsed() {
        return this.lastValue != this.currValue;
    }

    void resetWasUsed() {
        this.lastValue = this.currValue;
    }

    public void reset(long l2) {
        this.currValue = this.lastValue = l2;
        this.startValue = this.lastValue;
    }

    void reset(long l2, long l3) {
        this.reset(l2);
        this.increment = l3;
    }

    int getType() {
        return this.dataType;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public String getSchemaName() {
        return this.name.schema.name;
    }

    long getIncrement() {
        return this.increment;
    }
}

