/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;

public final class HsqlSocketFactorySecure
extends HsqlSocketFactory
implements HandshakeCompletedListener {
    protected Object socketFactory;
    protected Object serverSocketFactory;
    protected final Object socket_factory_mutex = new Object();
    protected final Object server_socket_factory_mutex = new Object();

    protected HsqlSocketFactorySecure() throws Exception {
        if (Security.getProvider("SunJSSE") == null) {
            try {
                Provider provider = (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance();
                Security.addProvider(provider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void configureSocket(Socket socket) {
        super.configureSocket(socket);
        SSLSocket sSLSocket = (SSLSocket)socket;
        sSLSocket.addHandshakeCompletedListener(this);
    }

    public ServerSocket createServerSocket(int n2) throws Exception {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n2);
        if (Trace.TRACE) {
            Trace.printSystemOut("[" + this + "]: createServerSocket()");
            Trace.printSystemOut("capabilities for " + sSLServerSocket + ":");
            Trace.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n2, String string) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(string);
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.getServerSocketFactoryImpl().createServerSocket(n2, 128, inetAddress);
        if (Trace.TRACE) {
            Trace.printSystemOut("[" + this + "]: createServerSocket()");
            Trace.printSystemOut("capabilities for " + sSLServerSocket + ":");
            Trace.printSystemOut("----------------------------");
            HsqlSocketFactorySecure.dump("supported cipher suites", sSLServerSocket.getSupportedCipherSuites());
            HsqlSocketFactorySecure.dump("enabled cipher suites", sSLServerSocket.getEnabledCipherSuites());
        }
        return sSLServerSocket;
    }

    private static void dump(String string, String[] stringArray) {
        Trace.printSystemOut(string);
        Trace.printSystemOut("----------------------------");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Trace.printSystemOut(String.valueOf(stringArray[i2]));
        }
        Trace.printSystemOut("----------------------------");
    }

    public Socket createSocket(String string, int n2) throws Exception {
        SSLSocket sSLSocket = (SSLSocket)this.getSocketFactoryImpl().createSocket(string, n2);
        sSLSocket.addHandshakeCompletedListener(this);
        sSLSocket.startHandshake();
        this.verify(string, sSLSocket.getSession());
        return sSLSocket;
    }

    public boolean isSecure() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLServerSocketFactory getServerSocketFactoryImpl() throws Exception {
        Object object;
        Object object2 = this.server_socket_factory_mutex;
        synchronized (object2) {
            object = this.serverSocketFactory;
            if (object == null) {
                this.serverSocketFactory = object = SSLServerSocketFactory.getDefault();
            }
        }
        return (SSLServerSocketFactory)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLSocketFactory getSocketFactoryImpl() throws Exception {
        Object object;
        Object object2 = this.socket_factory_mutex;
        synchronized (object2) {
            object = this.socketFactory;
            if (object == null) {
                this.socketFactory = object = SSLSocketFactory.getDefault();
            }
        }
        return (SSLSocketFactory)object;
    }

    protected void verify(String string, SSLSession sSLSession) throws Exception {
        String string2;
        X509Certificate[] x509CertificateArray = sSLSession.getPeerCertificateChain();
        X509Certificate x509Certificate = x509CertificateArray[0];
        Principal principal = x509Certificate.getSubjectDN();
        String string3 = String.valueOf(principal);
        int n2 = string3.indexOf("CN=");
        if (n2 < 0) {
            throw new UnknownHostException(Trace.getMessage(136));
        }
        int n3 = string3.indexOf(44, n2 += 3);
        if ((string2 = string3.substring(n2, n3 > -1 ? n3 : string3.length())).length() < 1) {
            throw new UnknownHostException(Trace.getMessage(137));
        }
        if (!string2.equalsIgnoreCase(string)) {
            throw new UnknownHostException(Trace.getMessage(139, true, new Object[]{string2, string}));
        }
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        if (Trace.TRACE) {
            SSLSocket sSLSocket = handshakeCompletedEvent.getSocket();
            SSLSession sSLSession = handshakeCompletedEvent.getSession();
            Trace.printSystemOut("SSL handshake completed:");
            Trace.printSystemOut("------------------------------------------------");
            Trace.printSystemOut("socket:      : " + sSLSocket);
            Trace.printSystemOut("cipher suite : " + sSLSession.getCipherSuite());
            String string = StringConverter.byteToHex(sSLSession.getId());
            Trace.printSystemOut("session id   : " + string);
            Trace.printSystemOut("------------------------------------------------");
        }
    }
}

