/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;

public class Grantee {
    boolean isRole;
    private boolean isAdminDirect = false;
    private boolean isAdmin = false;
    private IntValueHashMap fullRightsMap = new IntValueHashMap();
    private String granteeName;
    private IntValueHashMap rightsMap;
    HashSet roles = new HashSet();
    private Grantee pubGrantee;
    private GranteeManager granteeManager;

    Grantee(String string, Grantee grantee, GranteeManager granteeManager) throws HsqlException {
        this.rightsMap = new IntValueHashMap();
        this.granteeName = string;
        this.granteeManager = granteeManager;
        this.pubGrantee = grantee;
    }

    String getName() {
        return this.granteeName;
    }

    IntValueHashMap getRights() {
        return this.rightsMap;
    }

    public void grant(String string) throws HsqlException {
        this.roles.add(string);
    }

    public void revoke(String string) throws HsqlException {
        if (!this.hasRoleDirect(string)) {
            throw Trace.error(246, string);
        }
        this.roles.remove(string);
    }

    public HashSet getDirectRoles() {
        return this.roles;
    }

    String getDirectRolesString() {
        return this.setToString(this.roles);
    }

    String getAllRolesString() {
        return this.setToString(this.getAllRoles());
    }

    public String setToString(Set set) {
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public HashSet getAllRoles() {
        HashSet hashSet = new HashSet();
        this.addGranteeAndRoles(hashSet);
        hashSet.remove(this.granteeName);
        return hashSet;
    }

    private HashSet addGranteeAndRoles(HashSet hashSet) {
        hashSet.add(this.granteeName);
        Iterator iterator = this.roles.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashSet.contains(string)) continue;
            try {
                this.granteeManager.getRole(string).addGranteeAndRoles(hashSet);
            }
            catch (HsqlException hsqlException) {
                throw new RuntimeException(hsqlException.getMessage());
            }
        }
        return hashSet;
    }

    public boolean hasRoleDirect(String string) {
        return this.roles.contains(string);
    }

    public boolean hasRole(String string) {
        return this.getAllRoles().contains(string);
    }

    public String allRolesString() {
        HashSet hashSet = this.getAllRoles();
        if (hashSet.size() < 1) {
            return null;
        }
        Iterator iterator = this.getAllRoles().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }

    void grant(Object object, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.rightsMap.get(object, 0);
        this.rightsMap.put(object, n3 |= n2);
    }

    void revoke(Object object, int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.rightsMap.get(object, 0);
        if (n3 == 0) {
            return;
        }
        if ((n2 = n3 & 15 - n2) == 0) {
            this.rightsMap.remove(object);
        } else {
            this.rightsMap.put(object, n2);
        }
    }

    void revokeDbObject(Object object) {
        this.rightsMap.remove(object);
        this.fullRightsMap.remove(object);
    }

    void clearPrivileges() {
        this.roles.clear();
        this.rightsMap.clear();
        this.fullRightsMap.clear();
        this.isAdminDirect = false;
    }

    void check(HsqlNameManager.HsqlName hsqlName, int n2) throws HsqlException {
        if (!this.isAccessible(hsqlName, n2)) {
            throw Trace.error(33);
        }
    }

    void check(String string) throws HsqlException {
        if (!this.isAccessible(string)) {
            throw Trace.error(33);
        }
    }

    boolean isAccessible(HsqlNameManager.HsqlName hsqlName, int n2) throws HsqlException {
        if (this.isAdmin) {
            return true;
        }
        if (this.pubGrantee != null && this.pubGrantee.isAccessible(hsqlName, n2)) {
            return true;
        }
        int n3 = this.fullRightsMap.get((Object)hsqlName, 0);
        if (n3 != 0) {
            return (n3 & n2) != 0;
        }
        return false;
    }

    boolean isAccessible(String string) throws HsqlException {
        if (string.startsWith("org.hsqldb.Library") || string.startsWith("java.lang.Math")) {
            return true;
        }
        if (this.isAdmin) {
            return true;
        }
        if (this.pubGrantee != null && this.pubGrantee.isAccessible(string)) {
            return true;
        }
        int n2 = this.fullRightsMap.get((Object)string, 0);
        return n2 != 0;
    }

    protected boolean isDirectlyAccessible(Object object, int n2) throws HsqlException {
        int n3 = this.rightsMap.get(object, 0);
        if (n3 != 0) {
            return (n3 & n2) != 0;
        }
        return false;
    }

    boolean isAccessible(HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        return this.isAccessible(hsqlName, 15);
    }

    void checkAdmin() throws HsqlException {
        if (!this.isAdmin()) {
            throw Trace.error(33);
        }
    }

    boolean isAdmin() {
        return this.isAdmin;
    }

    boolean isAdminDirect() {
        return this.isAdminDirect;
    }

    HashSet getGrantedClassNames(boolean bl) throws HsqlException {
        IntValueHashMap intValueHashMap = this.rightsMap;
        HashSet hashSet = this.getGrantedClassNamesDirect();
        if (bl && this.pubGrantee != null) {
            intValueHashMap = this.pubGrantee.rightsMap;
            Iterator iterator = intValueHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n2;
                Object object = iterator.next();
                if (!(object instanceof String) || (n2 = intValueHashMap.get(object, 0)) != 15) continue;
                hashSet.add(object);
            }
        }
        Iterator iterator = this.getAllRoles().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(this.granteeManager.getRole((String)iterator.next()).getGrantedClassNamesDirect());
        }
        return hashSet;
    }

    HashSet getGrantedClassNamesDirect() throws HsqlException {
        IntValueHashMap intValueHashMap = this.rightsMap;
        HashSet hashSet = new HashSet();
        Iterator iterator = this.rightsMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2;
            Object object = iterator.next();
            if (!(object instanceof String) || (n2 = intValueHashMap.get(object, 0)) != 15) continue;
            hashSet.add(object);
        }
        return hashSet;
    }

    String[] listGrantedTablePrivileges(HsqlNameManager.HsqlName hsqlName) {
        return GranteeManager.getRightsArray(this.rightsMap.get((Object)hsqlName, 0));
    }

    void setAdminDirect() {
        this.isAdminDirect = true;
        this.isAdmin = true;
    }

    boolean updateNestedRoles(String string) {
        boolean bl = false;
        boolean bl2 = string.equals(this.granteeName);
        if (!bl2) {
            Iterator iterator = this.roles.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    Grantee grantee = this.granteeManager.getRole(string2);
                    bl |= grantee.updateNestedRoles(string);
                }
                catch (HsqlException hsqlException) {}
            }
        }
        if (bl) {
            this.updateAllRights();
        }
        return bl || bl2;
    }

    void updateAllRights() {
        this.fullRightsMap.clear();
        this.isAdmin = this.isAdminDirect;
        Iterator iterator = this.roles.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Grantee grantee = this.granteeManager.getRole(string);
                this.fullRightsMap.putAll(grantee.fullRightsMap);
                this.isAdmin |= grantee.isAdmin();
            }
            catch (HsqlException hsqlException) {}
        }
        this.fullRightsMap.putAll(this.rightsMap);
    }
}

