/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Collation;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Library;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class Column {
    public HsqlNameManager.HsqlName columnName;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    long identityStart;
    long identityIncrement;
    static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigDecimal BIG_DECIMAL_0 = new BigDecimal(0.0);
    static final BigDecimal BIG_DECIMAL_1 = new BigDecimal(1.0);
    static int[] tenPower = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000};

    Column(HsqlNameManager.HsqlName hsqlName, boolean bl, int n2, int n3, int n4, boolean bl2, Expression expression) throws HsqlException {
        this.columnName = hsqlName;
        this.isNullable = bl;
        this.colType = n2;
        this.colSize = n3;
        this.colScale = n4;
        this.isPrimaryKey = bl2;
        this.defaultExpression = expression;
    }

    void setIdentity(boolean bl, long l2, long l3) throws HsqlException {
        this.isIdentity = bl;
        this.identityStart = l2;
        this.identityIncrement = l3;
        if (this.isIdentity && this.colType == 4 && (this.identityStart > Integer.MAX_VALUE || this.identityIncrement > Integer.MAX_VALUE)) {
            throw Trace.error(65, this.columnName.statementName);
        }
    }

    private Column() {
    }

    Column duplicate(boolean bl) throws HsqlException {
        Column column = new Column();
        column.columnName = this.columnName;
        column.isNullable = this.isNullable;
        column.colType = this.colType;
        column.colSize = this.colSize;
        column.colScale = this.colScale;
        column.defaultExpression = this.defaultExpression;
        if (bl) {
            column.setIdentity(this.isIdentity, this.identityStart, this.identityIncrement);
        }
        return column;
    }

    void setType(Column column) {
        this.isNullable = column.isNullable;
        this.colType = column.colType;
        this.colSize = column.colSize;
        this.colScale = column.colScale;
    }

    boolean isIdentity() {
        return this.isIdentity;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    void setNullable(boolean bl) {
        this.isNullable = bl;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    Object getDefaultValue(Session session) throws HsqlException {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.colType);
    }

    String getDefaultDDL() {
        String string = null;
        try {
            string = this.defaultExpression == null ? null : this.defaultExpression.getDDL();
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        return string;
    }

    Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expression) {
        this.defaultExpression = expression;
    }

    int getType() {
        return this.colType;
    }

    int getDIType() {
        return this.colType == 100 ? 12 : this.colType;
    }

    int getDITypeSub() {
        if (this.colType == 100) {
            return 4;
        }
        return 1;
    }

    int getSize() {
        return this.colSize;
    }

    int getScale() {
        return this.colScale;
    }

    static Object add(Object object, Object object2, int n2) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2 + d3));
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return (String)object + (String)object2;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.add(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return ValuePool.getInt(n3 + n4);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return ValuePool.getLong(l2 + l3);
            }
        }
        throw Trace.error(20, Types.getTypeString(n2));
    }

    static Object concat(Object object, Object object2) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        return object.toString() + object2.toString();
    }

    static Object negate(Object object, int n2) throws HsqlException {
        if (object == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = -((Number)object).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: 
            case 4: 
            case 5: {
                return ValuePool.getInt(-((Number)object).intValue());
            }
            case -5: {
                return ValuePool.getLong(-((Number)object).longValue());
            }
        }
        throw Trace.error(20, Types.getTypeString(n2));
    }

    static Object multiply(Object object, Object object2, int n2) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof Number) || !(object2 instanceof Number)) {
            object = Column.convertObject(object, n2);
            object2 = Column.convertObject(object2, n2);
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2 * d3));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.multiply(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return ValuePool.getInt(n3 * n4);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return ValuePool.getLong(l2 * l3);
            }
        }
        throw Trace.error(20, Types.getTypeString(n2));
    }

    static Object divide(Object object, Object object2, int n2) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2 / d3));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                int n3 = bigDecimal.scale() > bigDecimal2.scale() ? bigDecimal.scale() : bigDecimal2.scale();
                return bigDecimal2.signum() == 0 ? null : bigDecimal.divide(bigDecimal2, n3, 5);
            }
            case -6: 
            case 4: 
            case 5: {
                int n4 = ((Number)object).intValue();
                int n5 = ((Number)object2).intValue();
                if (n5 == 0) {
                    throw Trace.error(6);
                }
                return ValuePool.getInt(n4 / n5);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return l3 == 0L ? null : ValuePool.getLong(l2 / l3);
            }
        }
        throw Trace.error(20, Types.getTypeString(n2));
    }

    static Object subtract(Object object, Object object2, int n2) throws HsqlException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(d2 - d3));
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.subtract(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return ValuePool.getInt(n3 - n4);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return ValuePool.getLong(l2 - l3);
            }
        }
        throw Trace.error(20, Types.getTypeString(n2));
    }

    static int compare(Collation collation, Object object, Object object2, int n2) {
        int n3 = 0;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (n2) {
            case 0: {
                return 0;
            }
            case -1: 
            case 12: {
                return collation.compare((String)object, (String)object2);
            }
            case 1: {
                return collation.compare(Library.rtrim((String)object), Library.rtrim((String)object2));
            }
            case 100: {
                return collation.compareIgnoreCase((String)object, (String)object2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n4 = ((Number)object).intValue();
                int n5 = ((Number)object2).intValue();
                return n4 > n5 ? 1 : (n5 > n4 ? -1 : 0);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return l2 > l3 ? 1 : (l3 > l2 ? -1 : 0);
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return d2 > d3 ? 1 : (d3 > d2 ? -1 : 0);
            }
            case 2: 
            case 3: {
                n3 = ((BigDecimal)object).compareTo((BigDecimal)object2);
                break;
            }
            case 91: {
                return HsqlDateTime.compare((Date)object, (Date)object2);
            }
            case 92: {
                return HsqlDateTime.compare((Time)object, (Time)object2);
            }
            case 93: {
                return HsqlDateTime.compare((Timestamp)object, (Timestamp)object2);
            }
            case 16: {
                boolean bl = (Boolean)object;
                boolean bl2 = (Boolean)object2;
                return bl == bl2 ? 0 : (bl2 ? -1 : 1);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(object instanceof Binary) || !(object2 instanceof Binary)) break;
                n3 = Column.compareTo(((Binary)object).getBytes(), ((Binary)object2).getBytes());
                break;
            }
            case 1111: {
                return 0;
            }
        }
        return n3 == 0 ? 0 : (n3 < 0 ? -1 : 1);
    }

    public static Object convertObject(Object object, int n2) throws HsqlException {
        try {
            if (object == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return null;
                }
                case -6: {
                    int n3;
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        n3 = Integer.parseInt((String)object);
                        object = ValuePool.getInt(n3);
                    }
                    if (object instanceof Integer) {
                        n3 = ((Number)object).intValue();
                        if (127 < n3 || n3 < -128) {
                            throw Trace.error(65);
                        }
                        return object;
                    }
                    if (object instanceof Long) {
                        long l2 = ((Number)object).longValue();
                        if (127L < l2 || l2 < -128L) {
                            throw Trace.error(65);
                        }
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (object instanceof Byte) {
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (object instanceof Number) {
                        return Column.convertObject(Column.convertToInt(object), n2);
                    }
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                }
                case 5: {
                    int n4;
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        n4 = Integer.parseInt((String)object);
                        object = ValuePool.getInt(n4);
                    }
                    if (object instanceof Integer) {
                        n4 = ((Number)object).intValue();
                        if (Short.MAX_VALUE < n4 || n4 < Short.MIN_VALUE) {
                            throw Trace.error(65);
                        }
                        return object;
                    }
                    if (object instanceof Long) {
                        long l3 = ((Number)object).longValue();
                        if (32767L < l3 || l3 < -32768L) {
                            throw Trace.error(65);
                        }
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (object instanceof Byte || object instanceof Short) {
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (object instanceof Number) {
                        return Column.convertObject(Column.convertToInt(object), n2);
                    }
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                }
                case 4: {
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        int n5 = Integer.parseInt((String)object);
                        return ValuePool.getInt(n5);
                    }
                    if (object instanceof Long) {
                        long l4 = ((Number)object).longValue();
                        if (Integer.MAX_VALUE < l4 || l4 < Integer.MIN_VALUE) {
                            throw Trace.error(65);
                        }
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (object instanceof Byte || object instanceof Short) {
                        return ValuePool.getInt(((Number)object).intValue());
                    }
                    if (object instanceof Number) {
                        return Column.convertToInt(object);
                    }
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object != false ? ValuePool.getInt(1) : ValuePool.getInt(0);
                }
                case -5: {
                    if (object instanceof Long) {
                        return object;
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        long l5 = Long.parseLong((String)object);
                        return ValuePool.getLong(l5);
                    }
                    if (object instanceof Integer) {
                        return ValuePool.getLong(((Integer)object).longValue());
                    }
                    if (object instanceof Byte || object instanceof Short) {
                        return ValuePool.getLong(((Number)object).intValue());
                    }
                    if (object instanceof Number) {
                        return Column.convertToLong(object);
                    }
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object != false ? ValuePool.getLong(1L) : ValuePool.getLong(0L);
                }
                case 6: 
                case 7: 
                case 8: {
                    if (object instanceof Double) {
                        return object;
                    }
                    if (object instanceof String) {
                        object = Library.trim((String)object, " ", true, true);
                        double d2 = JavaSystem.parseDouble((String)object);
                        long l6 = Double.doubleToLongBits(d2);
                        return ValuePool.getDouble(l6);
                    }
                    if (object instanceof Number) {
                        return Column.convertToDouble(object);
                    }
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object != false ? ValuePool.getDouble(1L) : ValuePool.getDouble(0L);
                }
                case 2: 
                case 3: {
                    if (object instanceof BigDecimal) {
                        return object;
                    }
                    if (object instanceof Long) {
                        return BigDecimal.valueOf((Long)object);
                    }
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object != false ? BIG_DECIMAL_1 : BIG_DECIMAL_0;
                }
                case 16: {
                    if (object instanceof Boolean) {
                        return (Boolean)object;
                    }
                    if (object instanceof String) {
                        return ((String)(object = Library.trim((String)object, " ", true, true))).equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if (object instanceof Integer) {
                        return (Integer)object == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (object instanceof Long) {
                        return (Long)object == 0L ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (object instanceof Double) {
                        return (Double)object == 0.0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (object instanceof BigDecimal) {
                        return ((BigDecimal)object).equals(BIG_DECIMAL_0) ? Boolean.FALSE : Boolean.TRUE;
                    }
                    throw Trace.error(16);
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    if (object instanceof String) {
                        return object;
                    }
                    if (object instanceof Time) {
                        return HsqlDateTime.getTimeString((Time)object, null);
                    }
                    if (object instanceof Timestamp) {
                        return HsqlDateTime.getTimestampString((Timestamp)object, null);
                    }
                    if (object instanceof Date) {
                        return HsqlDateTime.getDateString((Date)object, null);
                    }
                    if (!(object instanceof byte[])) break;
                    return StringConverter.byteToHex((byte[])object);
                }
                case 92: {
                    if (object instanceof Time) {
                        return HsqlDateTime.getNormalisedTime((Time)object);
                    }
                    if (object instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedTime((Timestamp)object);
                    }
                    if (object instanceof String) {
                        return HsqlDateTime.timeValue((String)object);
                    }
                    if (!(object instanceof Date)) break;
                    throw Trace.error(95, Types.getTypeString(n2));
                }
                case 93: {
                    if (object instanceof Timestamp) {
                        return object;
                    }
                    if (object instanceof Time) {
                        return HsqlDateTime.getNormalisedTimestamp((Time)object);
                    }
                    if (object instanceof Date) {
                        return HsqlDateTime.getNormalisedTimestamp((Date)object);
                    }
                    if (!(object instanceof String)) break;
                    return HsqlDateTime.timestampValue((String)object);
                }
                case 91: {
                    if (object instanceof Date) {
                        return HsqlDateTime.getNormalisedDate((Date)object);
                    }
                    if (object instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedDate((Timestamp)object);
                    }
                    if (object instanceof String) {
                        return HsqlDateTime.dateValue((String)object);
                    }
                    if (!(object instanceof Time)) break;
                    throw Trace.error(95, Types.getTypeString(n2));
                }
                case -4: 
                case -3: 
                case -2: {
                    if (object instanceof Binary) {
                        return object;
                    }
                    if (object instanceof byte[]) {
                        return new Binary((byte[])object, false);
                    }
                    if (object instanceof String) {
                        return new Binary(StringConverter.hexToByte((String)object), false);
                    }
                    throw Trace.error(95, Types.getTypeString(n2));
                }
                case 1111: {
                    if (object instanceof JavaObject) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new JavaObject(StringConverter.hexToByte((String)object));
                    }
                    if (object instanceof Binary) {
                        return new JavaObject(((Binary)object).getBytes());
                    }
                    return new JavaObject((Serializable)object);
                }
            }
            if (object instanceof JavaObject) {
                object = ((JavaObject)object).getObject();
                return Column.convertObject(object, n2);
            }
            return Column.convertString(object.toString(), n2);
        }
        catch (HsqlException hsqlException) {
            throw hsqlException;
        }
        catch (Exception exception) {
            throw Trace.error(16, exception.toString());
        }
    }

    private static Object convertString(String string, int n2) throws HsqlException {
        switch (n2) {
            case -6: 
            case 5: {
                return Column.convertObject(string, n2);
            }
            case 4: {
                int n3 = Integer.parseInt(string);
                return ValuePool.getInt(n3);
            }
            case -5: {
                return ValuePool.getLong(Long.parseLong(string));
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = JavaSystem.parseDouble(string);
                long l2 = Double.doubleToLongBits(d2);
                return ValuePool.getDouble(l2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return string;
            }
            case 91: {
                return HsqlDateTime.dateValue(string);
            }
            case 92: {
                return HsqlDateTime.timeValue(string);
            }
            case 93: {
                return HsqlDateTime.timestampValue(string);
            }
            case 2: 
            case 3: {
                string = Library.trim(string, " ", true, true);
                return new BigDecimal(string);
            }
            case 16: {
                return string.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Trace.error(95, Types.getTypeString(n2));
    }

    static String createSQLString(Object object, int n2) throws HsqlException {
        if (object == null) {
            return "NULL";
        }
        switch (n2) {
            case 0: {
                return "NULL";
            }
            case 6: 
            case 7: 
            case 8: {
                return Column.createSQLString(((Number)object).doubleValue());
            }
            case 91: 
            case 92: 
            case 93: {
                return StringConverter.toQuotedString(object.toString(), '\'', false);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(object instanceof Binary)) {
                    throw Trace.error(95);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((Binary)object).getBytes()), '\'', false);
            }
            case 1111: {
                if (!(object instanceof JavaObject)) {
                    throw Trace.error(18);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((JavaObject)object).getBytes()), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createSQLString((String)object);
            }
        }
        return object.toString();
    }

    public static String createSQLString(double d2) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return "-1E0/0";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "1E0/0";
        }
        if (Double.isNaN(d2)) {
            return "0E0/0E0";
        }
        String string = Double.toString(d2);
        if (string.indexOf(69) < 0) {
            string = string.concat("E0");
        }
        return string;
    }

    public static String createSQLString(String string) {
        if (string == null) {
            return "NULL";
        }
        return StringConverter.toQuotedString(string, '\'', true);
    }

    public static Object convertObject(Session session, Object object, int n2, int n3, int n4) throws HsqlException {
        if (object == null) {
            return object;
        }
        if (n3 == 0) {
            return Column.convertObject(object, n2);
        }
        boolean bl = true;
        switch (n2) {
            case -1: 
            case 100: {
                n2 = 12;
            }
            case 1: 
            case 12: {
                if (object instanceof String) {
                    bl = false;
                } else {
                    object = Column.convertObject(object, 12);
                }
                return Column.enforceSize(object, n2, n3, n4, bl);
            }
            case 2: 
            case 3: {
                if (!(object instanceof BigDecimal)) {
                    object = Column.convertObject(object, n2);
                }
                return Column.enforceSize(object, n2, n3, n4, true);
            }
            case 93: {
                if (object instanceof Time) {
                    long l2 = session.currentDate.getTime() + ((Time)object).getTime();
                    object = HsqlDateTime.getTimestamp(l2);
                }
                if (!(object instanceof Timestamp)) break;
                return Column.enforceSize(object, n2, n3, n4, false);
            }
        }
        return Column.convertObject(object, n2);
    }

    static Object enforceSize(Object object, int n2, int n3, int n4, boolean bl) throws HsqlException {
        if (object == null) {
            return object;
        }
        if (n3 == 0 && n2 != 93) {
            return object;
        }
        switch (n2) {
            case 1: {
                return Column.checkChar((String)object, n3, bl);
            }
            case 12: 
            case 100: {
                return Column.checkVarchar((String)object, n3, bl);
            }
            case 2: 
            case 3: {
                int n5;
                BigDecimal bigDecimal = (BigDecimal)object;
                bigDecimal = bigDecimal.setScale(n4, 5);
                BigInteger bigInteger = JavaSystem.getUnscaledValue(bigDecimal);
                int n6 = n5 = bigInteger.signum() == -1 ? 1 : 0;
                if (bigInteger.toString().length() - n5 > n3) {
                    throw Trace.error(124);
                }
                return bigDecimal;
            }
            case 93: {
                if (n3 == 6) {
                    return object;
                }
                Timestamp timestamp = (Timestamp)object;
                int n7 = timestamp.getNanos();
                int n8 = tenPower[n3];
                int n9 = n7 / n8 * n8;
                timestamp.setNanos(n9);
                return timestamp;
            }
        }
        return object;
    }

    static String checkVarchar(String string, int n2, boolean bl) throws HsqlException {
        int n3 = string.length();
        if (n3 > n2) {
            if (bl) {
                throw Trace.error(124);
            }
            return string.substring(0, n2);
        }
        return string;
    }

    static String checkChar(String string, int n2, boolean bl) throws HsqlException {
        int n3 = string.length();
        if (n3 == n2) {
            return string;
        }
        if (n3 > n2) {
            if (bl) {
                throw Trace.error(124);
            }
            return string.substring(0, n2);
        }
        char[] cArray = new char[n2];
        string.getChars(0, n3, cArray, 0);
        for (int i2 = n3; i2 < n2; ++i2) {
            cArray[i2] = 32;
        }
        return new String(cArray);
    }

    static Integer convertToInt(Object object) throws HsqlException {
        if (object instanceof BigDecimal) {
            BigInteger bigInteger = ((BigDecimal)object).toBigInteger();
            if (bigInteger.compareTo(MAX_INT) > 0 || bigInteger.compareTo(MIN_INT) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getInt(bigInteger.intValue());
        }
        if (object instanceof Double || object instanceof Float) {
            double d2 = ((Number)object).doubleValue();
            if (Double.isNaN(d2) || d2 >= 2.147483648E9 || d2 <= -2.147483649E9) {
                throw Trace.error(65);
            }
            return ValuePool.getInt((int)d2);
        }
        throw Trace.error(95);
    }

    static Long convertToLong(Object object) throws HsqlException {
        if (object instanceof BigDecimal) {
            BigInteger bigInteger = ((BigDecimal)object).toBigInteger();
            if (bigInteger.compareTo(MAX_LONG) > 0 || bigInteger.compareTo(MIN_LONG) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getLong(bigInteger.longValue());
        }
        if (object instanceof Double || object instanceof Float) {
            double d2 = ((Number)object).doubleValue();
            if (Double.isNaN(d2) || d2 >= 9.223372036854776E18 || d2 <= -9.223372036854776E18) {
                throw Trace.error(65);
            }
            return ValuePool.getLong((long)d2);
        }
        throw Trace.error(95);
    }

    static Double convertToDouble(Object object) throws HsqlException {
        double d2;
        if (object instanceof BigDecimal) {
            int n2;
            BigDecimal bigDecimal = (BigDecimal)object;
            d2 = bigDecimal.doubleValue();
            BigDecimal bigDecimal2 = new BigDecimal(d2 + (double)(n2 = bigDecimal.signum()));
            if (bigDecimal2.compareTo(bigDecimal) != n2) {
                throw Trace.error(65);
            }
        } else {
            d2 = ((Number)object).doubleValue();
        }
        return ValuePool.getDouble(Double.doubleToLongBits(d2));
    }

    static int getCombinedNumberType(int n2, int n3, int n4) {
        int n5 = Column.getNumTypeWidth(n2);
        int n6 = Column.getNumTypeWidth(n3);
        if (n5 == 16 || n6 == 16) {
            return 8;
        }
        switch (n4) {
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 70: {
                return n5 > n6 ? n2 : n3;
            }
        }
        int n7 = n5 + n6;
        if (n7 <= 4) {
            return 4;
        }
        if (n7 <= 8) {
            return -5;
        }
        return 2;
    }

    static int getNumTypeWidth(int n2) {
        switch (n2) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return 32;
    }

    static int compareToTypeRange(Object object, int n2) {
        if (!(object instanceof Number)) {
            return 0;
        }
        if (object instanceof Integer || object instanceof Long) {
            int n3;
            int n4;
            long l2 = ((Number)object).longValue();
            switch (n2) {
                case -6: {
                    n4 = -128;
                    n3 = 127;
                    break;
                }
                case 5: {
                    n4 = Short.MIN_VALUE;
                    n3 = Short.MAX_VALUE;
                    break;
                }
                case 4: {
                    n4 = Integer.MIN_VALUE;
                    n3 = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    return 0;
                }
            }
            if ((long)n3 < l2) {
                return 1;
            }
            if (l2 < (long)n4) {
                return -1;
            }
            return 0;
        }
        try {
            object = Column.convertToLong(object);
            return Column.compareToTypeRange(object, n2);
        }
        catch (HsqlException hsqlException) {
            if (hsqlException.getErrorCode() == -65) {
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).signum();
                }
                if (object instanceof Double) {
                    return (Double)object > 0.0 ? 1 : -1;
                }
            }
            return 0;
        }
    }

    public static byte[] hexToByteArray(String string) throws HsqlException {
        try {
            return StringConverter.hexToByte(string);
        }
        catch (IOException iOException) {
            throw Trace.error(81);
        }
    }

    static int compareTo(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        int n4 = 0;
        while (true) {
            int n5 = 0;
            int n6 = 0;
            if (n4 < n2) {
                n5 = byArray[n4] & 0xFF;
            } else if (n4 >= n3) {
                return 0;
            }
            if (n4 < n3) {
                n6 = byArray2[n4] & 0xFF;
            }
            if (n5 > n6) {
                return 1;
            }
            if (n6 > n5) {
                return -1;
            }
            ++n4;
        }
    }
}

