/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Implementation of Container and LifeCycle")
public class ContainerLifeCycle
extends AbstractLifeCycle
implements Container,
Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(ContainerLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private final List<Container.Listener> _listeners = new CopyOnWriteArrayList<Container.Listener>();
    private boolean _doStarted;
    private boolean _destroyed;

    @Override
    protected void doStart() throws Exception {
        if (this._destroyed) {
            throw new IllegalStateException("Destroyed container cannot be restarted");
        }
        this._doStarted = true;
        try {
            for (Bean b2 : this._beans) {
                if (!(b2._bean instanceof LifeCycle)) continue;
                LifeCycle l2 = (LifeCycle)b2._bean;
                switch (b2._managed) {
                    case MANAGED: {
                        if (!l2.isStopped() && !l2.isFailed()) break;
                        this.start(l2);
                        break;
                    }
                    case AUTO: {
                        if (l2.isStopped()) {
                            this.manage(b2);
                            this.start(l2);
                            break;
                        }
                        this.unmanage(b2);
                        break;
                    }
                }
            }
            super.doStart();
        }
        catch (Throwable t2) {
            ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
            Collections.reverse(reverse);
            for (Bean b3 : reverse) {
                LifeCycle l3;
                if (!(b3._bean instanceof LifeCycle) || b3._managed != Managed.MANAGED || !(l3 = (LifeCycle)b3._bean).isRunning()) continue;
                try {
                    this.stop(l3);
                }
                catch (Throwable cause2) {
                    if (cause2 == t2) continue;
                    t2.addSuppressed(cause2);
                }
            }
            throw t2;
        }
    }

    protected void start(LifeCycle l2) throws Exception {
        l2.start();
    }

    protected void stop(LifeCycle l2) throws Exception {
        l2.stop();
    }

    @Override
    protected void doStop() throws Exception {
        this._doStarted = false;
        super.doStop();
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        MultiException mex = new MultiException();
        for (Bean b2 : reverse) {
            if (b2._managed != Managed.MANAGED || !(b2._bean instanceof LifeCycle)) continue;
            LifeCycle l2 = (LifeCycle)b2._bean;
            try {
                this.stop(l2);
            }
            catch (Throwable cause) {
                mex.add(cause);
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    public void destroy() {
        this._destroyed = true;
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b2 : reverse) {
            if (!(b2._bean instanceof Destroyable) || b2._managed != Managed.MANAGED && b2._managed != Managed.POJO) continue;
            Destroyable d2 = (Destroyable)b2._bean;
            try {
                d2.destroy();
            }
            catch (Throwable cause) {
                LOG.warn(cause);
            }
        }
        this._beans.clear();
    }

    public boolean contains(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isManaged(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return b2.isManaged();
        }
        return false;
    }

    public boolean isAuto(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return b2._managed == Managed.AUTO;
        }
        return false;
    }

    public boolean isUnmanaged(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return b2._managed == Managed.UNMANAGED;
        }
        return false;
    }

    @Override
    public boolean addBean(Object o2) {
        if (o2 instanceof LifeCycle) {
            LifeCycle l2 = (LifeCycle)o2;
            return this.addBean(o2, l2.isRunning() ? Managed.UNMANAGED : Managed.AUTO);
        }
        return this.addBean(o2, Managed.POJO);
    }

    @Override
    public boolean addBean(Object o2, boolean managed) {
        if (o2 instanceof LifeCycle) {
            return this.addBean(o2, managed ? Managed.MANAGED : Managed.UNMANAGED);
        }
        return this.addBean(o2, managed ? Managed.POJO : Managed.UNMANAGED);
    }

    private boolean addBean(Object o2, Managed managed) {
        if (o2 == null || this.contains(o2)) {
            return false;
        }
        Bean newBean = new Bean(o2);
        if (o2 instanceof Container.Listener) {
            this.addEventListener((Container.Listener)o2);
        }
        this._beans.add(newBean);
        for (Container.Listener l2 : this._listeners) {
            l2.beanAdded(this, o2);
        }
        try {
            switch (managed) {
                case UNMANAGED: {
                    this.unmanage(newBean);
                    break;
                }
                case MANAGED: {
                    this.manage(newBean);
                    if (!this.isStarting() || !this._doStarted) break;
                    LifeCycle l3 = (LifeCycle)o2;
                    if (!l3.isRunning()) {
                        this.start(l3);
                    }
                    break;
                }
                case AUTO: {
                    LifeCycle l3;
                    if (o2 instanceof LifeCycle) {
                        l3 = (LifeCycle)o2;
                        if (this.isStarting()) {
                            if (l3.isRunning()) {
                                this.unmanage(newBean);
                                break;
                            }
                            if (this._doStarted) {
                                this.manage(newBean);
                                this.start(l3);
                                break;
                            }
                            newBean._managed = Managed.AUTO;
                            break;
                        }
                        if (this.isStarted()) {
                            this.unmanage(newBean);
                            break;
                        }
                        newBean._managed = Managed.AUTO;
                        break;
                    }
                    newBean._managed = Managed.POJO;
                    break;
                }
                case POJO: {
                    newBean._managed = Managed.POJO;
                }
            }
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added {}", this, newBean);
        }
        return true;
    }

    public void addManaged(LifeCycle lifecycle) {
        this.addBean((Object)lifecycle, true);
        try {
            if (this.isRunning() && !lifecycle.isRunning()) {
                this.start(lifecycle);
            }
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    @Override
    public void addEventListener(Container.Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
        for (Bean b2 : this._beans) {
            listener.beanAdded(this, b2._bean);
            if (!(listener instanceof Container.InheritedListener) || !b2.isManaged() || !(b2._bean instanceof Container)) continue;
            if (b2._bean instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)b2._bean).addBean((Object)listener, false);
                continue;
            }
            ((Container)b2._bean).addBean(listener);
        }
    }

    @Override
    public void manage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            this.manage(b2);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void manage(Bean bean) {
        if (bean._managed != Managed.MANAGED) {
            bean._managed = Managed.MANAGED;
            if (bean._bean instanceof Container) {
                for (Container.Listener l2 : this._listeners) {
                    if (!(l2 instanceof Container.InheritedListener)) continue;
                    if (bean._bean instanceof ContainerLifeCycle) {
                        ((ContainerLifeCycle)bean._bean).addBean((Object)l2, false);
                        continue;
                    }
                    ((Container)bean._bean).addBean(l2);
                }
            }
            if (bean._bean instanceof AbstractLifeCycle) {
                ((AbstractLifeCycle)bean._bean).setStopTimeout(this.getStopTimeout());
            }
        }
    }

    @Override
    public void unmanage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            this.unmanage(b2);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void unmanage(Bean bean) {
        if (bean._managed != Managed.UNMANAGED) {
            if (bean._managed == Managed.MANAGED && bean._bean instanceof Container) {
                for (Container.Listener l2 : this._listeners) {
                    if (!(l2 instanceof Container.InheritedListener)) continue;
                    ((Container)bean._bean).removeBean(l2);
                }
            }
            bean._managed = Managed.UNMANAGED;
        }
    }

    @Override
    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public void setBeans(Collection<Object> beans) {
        for (Object bean : beans) {
            this.addBean(bean);
        }
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> clazz) {
        ArrayList<T> beans = null;
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            if (beans == null) {
                beans = new ArrayList<T>();
            }
            beans.add(clazz.cast(b2._bean));
        }
        return beans == null ? Collections.emptyList() : beans;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            return clazz.cast(b2._bean);
        }
        return null;
    }

    public void removeBeans() {
        ArrayList<Bean> beans = new ArrayList<Bean>(this._beans);
        for (Bean b2 : beans) {
            this.remove(b2);
        }
    }

    private Bean getBean(Object o2) {
        for (Bean b2 : this._beans) {
            if (b2._bean != o2) continue;
            return b2;
        }
        return null;
    }

    @Override
    public boolean removeBean(Object o2) {
        Bean b2 = this.getBean(o2);
        return b2 != null && this.remove(b2);
    }

    private boolean remove(Bean bean) {
        if (this._beans.remove(bean)) {
            boolean wasManaged = bean.isManaged();
            this.unmanage(bean);
            for (Container.Listener l2 : this._listeners) {
                l2.beanRemoved(this, bean._bean);
            }
            if (bean._bean instanceof Container.Listener) {
                this.removeEventListener((Container.Listener)bean._bean);
            }
            if (wasManaged && bean._bean instanceof LifeCycle) {
                try {
                    this.stop((LifeCycle)bean._bean);
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeEventListener(Container.Listener listener) {
        if (this._listeners.remove(listener)) {
            for (Bean b2 : this._beans) {
                listener.beanRemoved(this, b2._bean);
                if (!(listener instanceof Container.InheritedListener) || !b2.isManaged() || !(b2._bean instanceof Container)) continue;
                ((Container)b2._bean).removeBean(listener);
            }
        }
    }

    @Override
    public void setStopTimeout(long stopTimeout) {
        super.setStopTimeout(stopTimeout);
        for (Bean bean : this._beans) {
            if (!bean.isManaged() || !(bean._bean instanceof AbstractLifeCycle)) continue;
            ((AbstractLifeCycle)bean._bean).setStopTimeout(stopTimeout);
        }
    }

    @ManagedOperation(value="Dump the object to stderr")
    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
            System.err.println("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
    }

    @Override
    @ManagedOperation(value="Dump the object to a string")
    public String dump() {
        return Dumpable.dump(this);
    }

    @Deprecated
    public static String dump(Dumpable dumpable) {
        return Dumpable.dump(dumpable);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[0]);
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    @Deprecated
    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    @Deprecated
    public static void dumpObject(Appendable out, Object obj) throws IOException {
        Dumpable.dumpObject(out, obj);
    }

    protected void dumpObjects(Appendable out, String indent, Object ... items) throws IOException {
        Dumpable.dumpObjects(out, indent, this, items);
    }

    @Deprecated
    protected void dumpBeans(Appendable out, String indent, Collection<?> ... items) throws IOException {
        ContainerLifeCycle.dump(out, indent, items);
    }

    @Deprecated
    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        for (Collection<?> c2 : collections) {
            size += c2.size();
        }
        if (size == 0) {
            return;
        }
        int i2 = 0;
        for (Collection<?> c3 : collections) {
            for (Object o2 : c3) {
                out.append(indent).append(" +- ");
                Dumpable.dumpObjects(out, indent + (++i2 < size ? " |  " : "    "), o2, new Object[0]);
            }
        }
    }

    public void updateBean(Object oldBean, Object newBean) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                this.removeBean(oldBean);
            }
            if (newBean != null) {
                this.addBean(newBean);
            }
        }
    }

    public void updateBean(Object oldBean, Object newBean, boolean managed) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                this.removeBean(oldBean);
            }
            if (newBean != null) {
                this.addBean(newBean, managed);
            }
        }
    }

    public void updateBeans(Object[] oldBeans, Object[] newBeans) {
        if (oldBeans != null) {
            block0: for (Object o2 : oldBeans) {
                if (newBeans != null) {
                    for (Object n2 : newBeans) {
                        if (o2 == n2) continue block0;
                    }
                }
                this.removeBean(o2);
            }
        }
        if (newBeans != null) {
            block2: for (Object n3 : newBeans) {
                if (oldBeans != null) {
                    for (Object o3 : oldBeans) {
                        if (o3 == n3) continue block2;
                    }
                }
                this.addBean(n3);
            }
        }
    }

    @Override
    public <T> Collection<T> getContainedBeans(Class<T> clazz) {
        HashSet beans = new HashSet();
        this.getContainedBeans(clazz, beans);
        return beans;
    }

    protected <T> void getContainedBeans(Class<T> clazz, Collection<T> beans) {
        beans.addAll(this.getBeans(clazz));
        for (Container c2 : this.getBeans(Container.class)) {
            Bean bean = this.getBean(c2);
            if (bean == null || !bean.isManageable()) continue;
            if (c2 instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)c2).getContainedBeans(clazz, beans);
                continue;
            }
            beans.addAll(c2.getContainedBeans(clazz));
        }
    }

    private static class Bean {
        private final Object _bean;
        private volatile Managed _managed = Managed.POJO;

        private Bean(Object b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            this._bean = b2;
        }

        public boolean isManaged() {
            return this._managed == Managed.MANAGED;
        }

        public boolean isManageable() {
            switch (this._managed) {
                case MANAGED: {
                    return true;
                }
                case AUTO: {
                    return this._bean instanceof LifeCycle && ((LifeCycle)this._bean).isStopped();
                }
            }
            return false;
        }

        public String toString() {
            return String.format("{%s,%s}", new Object[]{this._bean, this._managed});
        }
    }

    static enum Managed {
        POJO,
        MANAGED,
        UNMANAGED,
        AUTO;

    }
}

