/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.util.ByteArrayOutputStream2;

public class ByteArrayISO8859Writer
extends Writer {
    private byte[] _buf;
    private int _size;
    private ByteArrayOutputStream2 _bout = null;
    private OutputStreamWriter _writer = null;
    private boolean _fixed = false;

    public ByteArrayISO8859Writer() {
        this._buf = new byte[2048];
    }

    public ByteArrayISO8859Writer(int capacity) {
        this._buf = new byte[capacity];
    }

    public ByteArrayISO8859Writer(byte[] buf) {
        this._buf = buf;
        this._fixed = true;
    }

    public Object getLock() {
        return this.lock;
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._buf.length;
    }

    public int spareCapacity() {
        return this._buf.length - this._size;
    }

    public void setLength(int l2) {
        this._size = l2;
    }

    public byte[] getBuf() {
        return this._buf;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this._buf, 0, this._size);
    }

    public void write(char c2) throws IOException {
        this.ensureSpareCapacity(1);
        if (c2 >= '\u0000' && c2 <= '\u007f') {
            this._buf[this._size++] = (byte)c2;
        } else {
            char[] ca = new char[]{c2};
            this.writeEncoded(ca, 0, 1);
        }
    }

    @Override
    public void write(char[] ca) throws IOException {
        this.ensureSpareCapacity(ca.length);
        for (int i2 = 0; i2 < ca.length; ++i2) {
            char c2 = ca[i2];
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(ca, i2, ca.length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    @Override
    public void write(char[] ca, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = ca[offset + i2];
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(ca, offset + i2, length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    @Override
    public void write(String s2) throws IOException {
        if (s2 == null) {
            this.write("null", 0, 4);
            return;
        }
        int length = s2.length();
        this.ensureSpareCapacity(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(s2.toCharArray(), i2, length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    @Override
    public void write(String s2, int offset, int length) throws IOException {
        this.ensureSpareCapacity(length);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(offset + i2);
            if (c2 < '\u0000' || c2 > '\u007f') {
                this.writeEncoded(s2.toCharArray(), offset + i2, length - i2);
                break;
            }
            this._buf[this._size++] = (byte)c2;
        }
    }

    private void writeEncoded(char[] ca, int offset, int length) throws IOException {
        if (this._bout == null) {
            this._bout = new ByteArrayOutputStream2(2 * length);
            this._writer = new OutputStreamWriter((OutputStream)this._bout, StandardCharsets.ISO_8859_1);
        } else {
            this._bout.reset();
        }
        this._writer.write(ca, offset, length);
        this._writer.flush();
        this.ensureSpareCapacity(this._bout.getCount());
        System.arraycopy(this._bout.getBuf(), 0, this._buf, this._size, this._bout.getCount());
        this._size += this._bout.getCount();
    }

    @Override
    public void flush() {
    }

    public void resetWriter() {
        this._size = 0;
    }

    @Override
    public void close() {
    }

    public void destroy() {
        this._buf = null;
    }

    public void ensureSpareCapacity(int n2) throws IOException {
        if (this._size + n2 > this._buf.length) {
            if (this._fixed) {
                throw new IOException("Buffer overflow: " + this._buf.length);
            }
            this._buf = Arrays.copyOf(this._buf, (this._buf.length + n2) * 4 / 3);
        }
    }

    public byte[] getByteArray() {
        return Arrays.copyOf(this._buf, this._size);
    }
}

