/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToIntFunction;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.log.Log;

public class QuotedQualityCSV
extends QuotedCSV
implements Iterable<String> {
    public static ToIntFunction<String> MOST_SPECIFIC_MIME_ORDERING = s2 -> {
        if ("*/*".equals(s2)) {
            return 0;
        }
        if (s2.endsWith("/*")) {
            return 1;
        }
        if (s2.indexOf(59) < 0) {
            return 2;
        }
        return 3;
    };
    private final List<Double> _quality = new ArrayList<Double>();
    private boolean _sorted = false;
    private final ToIntFunction<String> _secondaryOrdering;

    public QuotedQualityCSV() {
        this((ToIntFunction<String>)null);
    }

    public QuotedQualityCSV(String[] preferredOrder) {
        this(s2 -> {
            for (int i2 = 0; i2 < preferredOrder.length; ++i2) {
                if (!preferredOrder[i2].equals(s2)) continue;
                return preferredOrder.length - i2;
            }
            if ("*".equals(s2)) {
                return preferredOrder.length;
            }
            return Integer.MIN_VALUE;
        });
    }

    public QuotedQualityCSV(ToIntFunction<String> secondaryOrdering) {
        super(new String[0]);
        this._secondaryOrdering = secondaryOrdering == null ? s2 -> 0 : secondaryOrdering;
    }

    @Override
    protected void parsedValue(StringBuffer buffer) {
        super.parsedValue(buffer);
        this._quality.add(1.0);
    }

    @Override
    protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
        if (paramName < 0) {
            if (buffer.charAt(buffer.length() - 1) == ';') {
                buffer.setLength(buffer.length() - 1);
            }
        } else if (paramValue >= 0 && buffer.charAt(paramName) == 'q' && paramValue > paramName && buffer.length() >= paramName && buffer.charAt(paramName + 1) == '=') {
            Double q2;
            try {
                q2 = this._keepQuotes && buffer.charAt(paramValue) == '\"' ? Double.valueOf(buffer.substring(paramValue + 1, buffer.length() - 1)) : Double.valueOf(buffer.substring(paramValue));
            }
            catch (Exception e2) {
                Log.getLogger(QuotedQualityCSV.class).ignore(e2);
                q2 = 0.0;
            }
            buffer.setLength(Math.max(0, paramName - 1));
            if (q2 != 1.0) {
                this._quality.set(this._quality.size() - 1, q2);
            }
        }
    }

    @Override
    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values.iterator();
    }

    protected void sort() {
        this._sorted = true;
        Double last = 0.0;
        int lastSecondaryOrder = Integer.MIN_VALUE;
        int i2 = this._values.size();
        while (i2-- > 0) {
            String v2 = (String)this._values.get(i2);
            Double q2 = this._quality.get(i2);
            int compare = last.compareTo(q2);
            if (compare > 0 || compare == 0 && this._secondaryOrdering.applyAsInt(v2) < lastSecondaryOrder) {
                this._values.set(i2, (String)this._values.get(i2 + 1));
                this._values.set(i2 + 1, v2);
                this._quality.set(i2, this._quality.get(i2 + 1));
                this._quality.set(i2 + 1, q2);
                last = 0.0;
                lastSecondaryOrder = 0;
                i2 = this._values.size();
                continue;
            }
            last = q2;
            lastSecondaryOrder = this._secondaryOrdering.applyAsInt(v2);
        }
        int lastElement = this._quality.size();
        while (lastElement > 0 && this._quality.get(--lastElement).equals(0.0)) {
            this._quality.remove(lastElement);
            this._values.remove(lastElement);
        }
    }
}

