/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.sasn1.Asn1Generator;

public abstract class DerGenerator
extends Asn1Generator {
    private boolean _tagged = false;
    private boolean _isExplicit;
    private int _tagNo;

    protected DerGenerator(OutputStream outputStream) {
        super(outputStream);
    }

    public DerGenerator(OutputStream outputStream, int n2, boolean bl) {
        super(outputStream);
        this._tagged = true;
        this._isExplicit = bl;
        this._tagNo = n2;
    }

    private void writeLength(OutputStream outputStream, int n2) throws IOException {
        if (n2 > 127) {
            int n3 = 1;
            int n4 = n2;
            while ((n4 >>>= 8) != 0) {
                ++n3;
            }
            outputStream.write((byte)(n3 | 0x80));
            for (int i2 = (n3 - 1) * 8; i2 >= 0; i2 -= 8) {
                outputStream.write((byte)(n2 >> i2));
            }
        } else {
            outputStream.write((byte)n2);
        }
    }

    void writeDerEncoded(OutputStream outputStream, int n2, byte[] byArray) throws IOException {
        outputStream.write(n2);
        this.writeLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    void writeDerEncoded(int n2, byte[] byArray) throws IOException {
        if (this._tagged) {
            int n3 = this._tagNo | 0x80;
            if (this._isExplicit) {
                int n4 = this._tagNo | 0x20 | 0x80;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.writeDerEncoded((OutputStream)byteArrayOutputStream, n2, byArray);
                this.writeDerEncoded(this._out, n4, byteArrayOutputStream.toByteArray());
            } else if ((n2 & 0x20) != 0) {
                this.writeDerEncoded(this._out, n3 | 0x20, byArray);
            } else {
                this.writeDerEncoded(this._out, n3, byArray);
            }
        } else {
            this.writeDerEncoded(this._out, n2, byArray);
        }
    }

    void writeDerEncoded(OutputStream outputStream, int n2, InputStream inputStream) throws IOException {
        outputStream.write(n2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while ((n3 = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n3);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.writeLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }
}

