/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import org.bouncycastle.crypto.agreement.kdf.ECDHKEKGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.ECUtil;

public class JCEECDHKeyAgreement
extends KeyAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private static final Hashtable algorithms = new Hashtable();
    private BigInteger result;
    private ECPrivateKeyParameters privKey;
    private BasicAgreement agreement;
    private DerivationFunction kdf;

    private byte[] bigIntToBytes(BigInteger bigInteger) {
        return converter.integerToBytes(bigInteger, converter.getByteLength(this.privKey.getParameters().getG().getX()));
    }

    protected JCEECDHKeyAgreement(BasicAgreement basicAgreement) {
        this.agreement = basicAgreement;
    }

    protected JCEECDHKeyAgreement(BasicAgreement basicAgreement, DerivationFunction derivationFunction) {
        this.agreement = basicAgreement;
        this.kdf = derivationFunction;
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("EC Diffie-Hellman not initialised.");
        }
        if (!bl) {
            throw new IllegalStateException("EC Diffie-Hellman can only be between two parties.");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("EC Key Agreement doPhase requires ECPublicKey");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = ECUtil.generatePublicKeyParameter((PublicKey)key);
        this.result = this.agreement.calculateAgreement(asymmetricKeyParameter);
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.bigIntToBytes(this.result);
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.bigIntToBytes(this.result);
        if (byArray.length - n2 < byArray2.length) {
            throw new ShortBufferException("ECKeyAgreement - buffer too short");
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    protected SecretKey engineGenerateSecret(String string) throws NoSuchAlgorithmException {
        if (this.kdf != null) {
            if (!algorithms.containsKey(string)) {
                throw new NoSuchAlgorithmException("unknown algorithm encountered: " + string);
            }
            int n2 = (Integer)algorithms.get(string);
            DHKDFParameters dHKDFParameters = new DHKDFParameters(new DERObjectIdentifier(string), n2, this.bigIntToBytes(this.result));
            byte[] byArray = new byte[n2 / 8];
            this.kdf.init(dHKDFParameters);
            this.kdf.generateBytes(byArray, 0, byArray.length);
            return new SecretKeySpec(byArray, string);
        }
        return new SecretKeySpec(this.bigIntToBytes(this.result), string);
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey for initialisation");
        }
        this.privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey");
        }
        this.privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    static {
        Integer n2 = new Integer(128);
        Integer n3 = new Integer(192);
        Integer n4 = new Integer(256);
        algorithms.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), n2);
        algorithms.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), n3);
        algorithms.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), n4);
        algorithms.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), n2);
        algorithms.put(NISTObjectIdentifiers.id_aes192_wrap.getId(), n3);
        algorithms.put(NISTObjectIdentifiers.id_aes256_wrap.getId(), n4);
        algorithms.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), n3);
    }

    public static class DHwithSHA1KDF
    extends JCEECDHKeyAgreement {
        public DHwithSHA1KDF() {
            super(new ECDHBasicAgreement(), new ECDHKEKGenerator(new SHA1Digest()));
        }
    }

    public static class DHC
    extends JCEECDHKeyAgreement {
        public DHC() {
            super(new ECDHCBasicAgreement());
        }
    }

    public static class DH
    extends JCEECDHKeyAgreement {
        public DH() {
            super(new ECDHBasicAgreement());
        }
    }
}

