/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class DigestRandomGenerator
implements RandomGenerator {
    private long counter;
    private Digest digest;
    private byte[] state;

    public DigestRandomGenerator(Digest digest) {
        this.digest = digest;
        this.state = new byte[digest.getDigestSize()];
        this.counter = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeedMaterial(byte[] byArray) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            this.digestUpdate(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeedMaterial(long l2) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            for (int i2 = 0; i2 != 8; ++i2) {
                this.digestUpdate((byte)l2);
                l2 >>>= 8;
            }
        }
    }

    public void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] byArray, int n2, int n3) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            int n4 = 0;
            this.digestDoFinal(this.state);
            int n5 = n2 + n3;
            for (int i2 = n2; i2 != n5; ++i2) {
                if (n4 == this.state.length) {
                    this.digestUpdate(this.counter++);
                    this.digestUpdate(this.state);
                    this.digestDoFinal(this.state);
                    n4 = 0;
                }
                byArray[i2] = this.state[n4++];
            }
            this.digestUpdate(this.counter++);
            this.digestUpdate(this.state);
        }
    }

    private void digestUpdate(long l2) {
        for (int i2 = 0; i2 != 8; ++i2) {
            this.digest.update((byte)l2);
            l2 >>>= 8;
        }
    }

    private void digestUpdate(byte[] byArray) {
        this.digest.update(byArray, 0, byArray.length);
    }

    private void digestDoFinal(byte[] byArray) {
        this.digest.doFinal(byArray, 0);
    }
}

