/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class HC256Engine
implements StreamCipher {
    private int[] p = new int[1024];
    private int[] q = new int[1024];
    private int cnt = 0;
    private byte[] key;
    private byte[] iv;
    private boolean initialised;
    private byte[] buf = new byte[4];
    private int idx = 0;

    private int step() {
        int n2;
        int n3 = this.cnt & 0x3FF;
        if (this.cnt < 1024) {
            int n4 = this.p[n3 - 3 & 0x3FF];
            int n5 = this.p[n3 - 1023 & 0x3FF];
            int n6 = n3;
            this.p[n6] = this.p[n6] + (this.p[n3 - 10 & 0x3FF] + (HC256Engine.rotateRight(n4, 10) ^ HC256Engine.rotateRight(n5, 23)) + this.q[(n4 ^ n5) & 0x3FF]);
            n4 = this.p[n3 - 12 & 0x3FF];
            n2 = this.q[n4 & 0xFF] + this.q[(n4 >> 8 & 0xFF) + 256] + this.q[(n4 >> 16 & 0xFF) + 512] + this.q[(n4 >> 24 & 0xFF) + 768] ^ this.p[n3];
        } else {
            int n7 = this.q[n3 - 3 & 0x3FF];
            int n8 = this.q[n3 - 1023 & 0x3FF];
            int n9 = n3;
            this.q[n9] = this.q[n9] + (this.q[n3 - 10 & 0x3FF] + (HC256Engine.rotateRight(n7, 10) ^ HC256Engine.rotateRight(n8, 23)) + this.p[(n7 ^ n8) & 0x3FF]);
            n7 = this.q[n3 - 12 & 0x3FF];
            n2 = this.p[n7 & 0xFF] + this.p[(n7 >> 8 & 0xFF) + 256] + this.p[(n7 >> 16 & 0xFF) + 512] + this.p[(n7 >> 24 & 0xFF) + 768] ^ this.q[n3];
        }
        this.cnt = this.cnt + 1 & 0x7FF;
        return n2;
    }

    private void init() {
        int n2;
        if (this.key.length != 32) {
            throw new IllegalArgumentException("The key must be 256 bit long");
        }
        this.cnt = 0;
        int[] nArray = new int[2560];
        for (n2 = 0; n2 < 32; ++n2) {
            int n3 = n2 >> 3;
            nArray[n3] = nArray[n3] | this.key[n2] << (n2 & 7);
        }
        for (n2 = 0; n2 < this.iv.length && n2 < 32; ++n2) {
            int n4 = (n2 >> 3) + 8;
            nArray[n4] = nArray[n4] | this.iv[n2] << (n2 & 7);
        }
        for (n2 = 16; n2 < 2560; ++n2) {
            int n5 = nArray[n2 - 2];
            int n6 = nArray[n2 - 15];
            nArray[n2] = (HC256Engine.rotateRight(n5, 17) ^ HC256Engine.rotateRight(n5, 19) ^ n5 >>> 10) + nArray[n2 - 7] + (HC256Engine.rotateRight(n6, 7) ^ HC256Engine.rotateRight(n6, 18) ^ n6 >>> 3) + nArray[n2 - 16] + n2;
        }
        System.arraycopy(nArray, 512, this.p, 0, 1024);
        System.arraycopy(nArray, 1536, this.q, 0, 1024);
        for (n2 = 0; n2 < 4096; ++n2) {
            this.step();
        }
        this.cnt = 0;
    }

    public String getAlgorithmName() {
        return "HC-256";
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2 = cipherParameters;
        if (cipherParameters instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)cipherParameters).getIV();
            cipherParameters2 = ((ParametersWithIV)cipherParameters).getParameters();
        } else {
            this.iv = new byte[0];
        }
        if (!(cipherParameters2 instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to HC256 init - " + cipherParameters.getClass().getName());
        }
        this.key = ((KeyParameter)cipherParameters2).getKey();
        this.init();
        this.initialised = true;
    }

    private byte getByte() {
        int n2;
        if (this.idx == 0) {
            n2 = this.step();
            this.buf[3] = (byte)(n2 & 0xFF);
            this.buf[2] = (byte)((n2 >>= 8) & 0xFF);
            this.buf[1] = (byte)((n2 >>= 8) & 0xFF);
            this.buf[0] = (byte)((n2 >>= 8) & 0xFF);
        }
        n2 = this.buf[this.idx];
        this.idx = this.idx + 1 & 3;
        return (byte)n2;
    }

    public void processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n4 + n3 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray2[n4 + i2] = (byte)(byArray[n2 + i2] ^ this.getByte());
        }
    }

    public void reset() {
        this.idx = 0;
        this.init();
    }

    public byte returnByte(byte by) {
        return (byte)(by ^ this.getByte());
    }

    private static int rotateRight(int n2, int n3) {
        return n2 >>> n3 | n2 << -n3;
    }
}

