/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class CamelliaEngine
implements BlockCipher {
    private boolean initialised;
    private boolean _keyIs128;
    private static final int BLOCK_SIZE = 16;
    private static final long MASK8 = 255L;
    private static final long MASK32 = 0xFFFFFFFFL;
    private static final long SIGMA1 = -6872943284670656373L;
    private static final long SIGMA2 = -5297666545706961998L;
    private static final long SIGMA3 = -4112007255848680770L;
    private static final long SIGMA4 = 6124705990439038748L;
    private static final long SIGMA5 = 1217423232700263709L;
    private static final long SIGMA6 = -5740250305213840899L;
    private long _kw1;
    private long _kw2;
    private long _kw3;
    private long _kw4;
    private long _k1;
    private long _k2;
    private long _k3;
    private long _k4;
    private long _k5;
    private long _k6;
    private long _k7;
    private long _k8;
    private long _k9;
    private long _k10;
    private long _k11;
    private long _k12;
    private long _k13;
    private long _k14;
    private long _k15;
    private long _k16;
    private long _k17;
    private long _k18;
    private long _k19;
    private long _k20;
    private long _k21;
    private long _k22;
    private long _k23;
    private long _k24;
    private long _ke1;
    private long _ke2;
    private long _ke3;
    private long _ke4;
    private long _ke5;
    private long _ke6;
    private final byte[] SBOX1 = new byte[]{112, -126, 44, -20, -77, 39, -64, -27, -28, -123, 87, 53, -22, 12, -82, 65, 35, -17, 107, -109, 69, 25, -91, 33, -19, 14, 79, 78, 29, 101, -110, -67, -122, -72, -81, -113, 124, -21, 31, -50, 62, 48, -36, 95, 94, -59, 11, 26, -90, -31, 57, -54, -43, 71, 93, 61, -39, 1, 90, -42, 81, 86, 108, 77, -117, 13, -102, 102, -5, -52, -80, 45, 116, 18, 43, 32, -16, -79, -124, -103, -33, 76, -53, -62, 52, 126, 118, 5, 109, -73, -87, 49, -47, 23, 4, -41, 20, 88, 58, 97, -34, 27, 17, 28, 50, 15, -100, 22, 83, 24, -14, 34, -2, 68, -49, -78, -61, -75, 122, -111, 36, 8, -24, -88, 96, -4, 105, 80, -86, -48, -96, 125, -95, -119, 98, -105, 84, 91, 30, -107, -32, -1, 100, -46, 16, -60, 0, 72, -93, -9, 117, -37, -118, 3, -26, -38, 9, 63, -35, -108, -121, 92, -125, 2, -51, 74, -112, 51, 115, 103, -10, -13, -99, 127, -65, -30, 82, -101, -40, 38, -56, 55, -58, 59, -127, -106, 111, 75, 19, -66, 99, 46, -23, 121, -89, -116, -97, 110, -68, -114, 41, -11, -7, -74, 47, -3, -76, 89, 120, -104, 6, 106, -25, 70, 113, -70, -44, 37, -85, 66, -120, -94, -115, -6, 114, 7, -71, 85, -8, -18, -84, 10, 54, 73, 42, 104, 60, 56, -15, -92, 64, 40, -45, 123, -69, -55, 67, -63, 21, -29, -83, -12, 119, -57, -128, -98};
    private final byte[] SBOX2 = new byte[256];
    private final byte[] SBOX3 = new byte[256];
    private final byte[] SBOX4 = new byte[256];

    public CamelliaEngine() {
        for (int i2 = 0; i2 != 256; ++i2) {
            this.SBOX2[i2] = this.lRot8(this.SBOX1[i2], 1);
            this.SBOX3[i2] = this.lRot8(this.SBOX1[i2], 7);
            this.SBOX4[i2] = this.SBOX1[this.lRot8((byte)i2, 1) & 0xFF];
        }
    }

    private void setKey(boolean bl, byte[] byArray) {
        long l2;
        long l3;
        long l4;
        long l5;
        switch (byArray.length) {
            case 16: {
                this._keyIs128 = true;
                l5 = this.bytesToWord(byArray, 0);
                l4 = this.bytesToWord(byArray, 8);
                l3 = 0L;
                l2 = 0L;
                break;
            }
            case 24: {
                l5 = this.bytesToWord(byArray, 0);
                l4 = this.bytesToWord(byArray, 8);
                l3 = this.bytesToWord(byArray, 16);
                l2 = this.bytesToWord(byArray, 16) ^ 0xFFFFFFFFFFFFFFFFL;
                this._keyIs128 = false;
                break;
            }
            case 32: {
                l5 = this.bytesToWord(byArray, 0);
                l4 = this.bytesToWord(byArray, 8);
                l3 = this.bytesToWord(byArray, 16);
                l2 = this.bytesToWord(byArray, 24);
                this._keyIs128 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("only a key sizes of 128/192/256 are acceptable.");
            }
        }
        long l6 = l5 ^ l3;
        long l7 = l4 ^ l2;
        l7 ^= this.f(l6, -6872943284670656373L);
        l6 ^= this.f(l7, -5297666545706961998L);
        l7 ^= l4;
        l7 ^= this.f(l6 ^= l5, -4112007255848680770L);
        long l8 = l6 ^= this.f(l7, 6124705990439038748L);
        long l9 = l7;
        if (this._keyIs128) {
            if (bl) {
                this._kw1 = l5;
                this._kw2 = l4;
                this._kw3 = this.lRot128high(l8, l9, 111);
                this._kw4 = this.lRot128low(l8, l9, 111);
                this._k1 = l8;
                this._k2 = l9;
                this._k3 = this.lRot128high(l5, l4, 15);
                this._k4 = this.lRot128low(l5, l4, 15);
                this._k5 = this.lRot128high(l8, l9, 15);
                this._k6 = this.lRot128low(l8, l9, 15);
                this._k7 = this.lRot128high(l5, l4, 45);
                this._k8 = this.lRot128low(l5, l4, 45);
                this._k9 = this.lRot128high(l8, l9, 45);
                this._k10 = this.lRot128low(l5, l4, 60);
                this._k11 = this.lRot128high(l8, l9, 60);
                this._k12 = this.lRot128low(l8, l9, 60);
                this._k13 = this.lRot128high(l5, l4, 94);
                this._k14 = this.lRot128low(l5, l4, 94);
                this._k15 = this.lRot128high(l8, l9, 94);
                this._k16 = this.lRot128low(l8, l9, 94);
                this._k17 = this.lRot128high(l5, l4, 111);
                this._k18 = this.lRot128low(l5, l4, 111);
                this._ke1 = this.lRot128high(l8, l9, 30);
                this._ke2 = this.lRot128low(l8, l9, 30);
                this._ke3 = this.lRot128high(l5, l4, 77);
                this._ke4 = this.lRot128low(l5, l4, 77);
            } else {
                this._kw3 = l5;
                this._kw4 = l4;
                this._kw1 = this.lRot128high(l8, l9, 111);
                this._kw2 = this.lRot128low(l8, l9, 111);
                this._k18 = l8;
                this._k17 = l9;
                this._k16 = this.lRot128high(l5, l4, 15);
                this._k15 = this.lRot128low(l5, l4, 15);
                this._k14 = this.lRot128high(l8, l9, 15);
                this._k13 = this.lRot128low(l8, l9, 15);
                this._k12 = this.lRot128high(l5, l4, 45);
                this._k11 = this.lRot128low(l5, l4, 45);
                this._k10 = this.lRot128high(l8, l9, 45);
                this._k9 = this.lRot128low(l5, l4, 60);
                this._k8 = this.lRot128high(l8, l9, 60);
                this._k7 = this.lRot128low(l8, l9, 60);
                this._k6 = this.lRot128high(l5, l4, 94);
                this._k5 = this.lRot128low(l5, l4, 94);
                this._k4 = this.lRot128high(l8, l9, 94);
                this._k3 = this.lRot128low(l8, l9, 94);
                this._k2 = this.lRot128high(l5, l4, 111);
                this._k1 = this.lRot128low(l5, l4, 111);
                this._ke4 = this.lRot128high(l8, l9, 30);
                this._ke3 = this.lRot128low(l8, l9, 30);
                this._ke2 = this.lRot128high(l5, l4, 77);
                this._ke1 = this.lRot128low(l5, l4, 77);
            }
        } else {
            l6 = l8 ^ l3;
            l7 = l9 ^ l2;
            l7 ^= this.f(l6, 1217423232700263709L);
            long l10 = l6 ^= this.f(l7, -5740250305213840899L);
            long l11 = l7;
            if (bl) {
                this._kw1 = l5;
                this._kw2 = l4;
                this._k1 = l10;
                this._k2 = l11;
                this._k3 = this.lRot128high(l3, l2, 15);
                this._k4 = this.lRot128low(l3, l2, 15);
                this._k5 = this.lRot128high(l8, l9, 15);
                this._k6 = this.lRot128low(l8, l9, 15);
                this._ke1 = this.lRot128high(l3, l2, 30);
                this._ke2 = this.lRot128low(l3, l2, 30);
                this._k7 = this.lRot128high(l10, l11, 30);
                this._k8 = this.lRot128low(l10, l11, 30);
                this._k9 = this.lRot128high(l5, l4, 45);
                this._k10 = this.lRot128low(l5, l4, 45);
                this._k11 = this.lRot128high(l8, l9, 45);
                this._k12 = this.lRot128low(l8, l9, 45);
                this._ke3 = this.lRot128high(l5, l4, 60);
                this._ke4 = this.lRot128low(l5, l4, 60);
                this._k13 = this.lRot128high(l3, l2, 60);
                this._k14 = this.lRot128low(l3, l2, 60);
                this._k15 = this.lRot128high(l10, l11, 60);
                this._k16 = this.lRot128low(l10, l11, 60);
                this._k17 = this.lRot128high(l5, l4, 77);
                this._k18 = this.lRot128low(l5, l4, 77);
                this._ke5 = this.lRot128high(l8, l9, 77);
                this._ke6 = this.lRot128low(l8, l9, 77);
                this._k19 = this.lRot128high(l3, l2, 94);
                this._k20 = this.lRot128low(l3, l2, 94);
                this._k21 = this.lRot128high(l8, l9, 94);
                this._k22 = this.lRot128low(l8, l9, 94);
                this._k23 = this.lRot128high(l5, l4, 111);
                this._k24 = this.lRot128low(l5, l4, 111);
                this._kw3 = this.lRot128high(l10, l11, 111);
                this._kw4 = this.lRot128low(l10, l11, 111);
            } else {
                this._kw3 = l5;
                this._kw4 = l4;
                this._kw1 = this.lRot128high(l10, l11, 111);
                this._kw2 = this.lRot128low(l10, l11, 111);
                this._k24 = l10;
                this._k23 = l11;
                this._k22 = this.lRot128high(l3, l2, 15);
                this._k21 = this.lRot128low(l3, l2, 15);
                this._k20 = this.lRot128high(l8, l9, 15);
                this._k19 = this.lRot128low(l8, l9, 15);
                this._k18 = this.lRot128high(l10, l11, 30);
                this._k17 = this.lRot128low(l10, l11, 30);
                this._k16 = this.lRot128high(l5, l4, 45);
                this._k15 = this.lRot128low(l5, l4, 45);
                this._k14 = this.lRot128high(l8, l9, 45);
                this._k13 = this.lRot128low(l8, l9, 45);
                this._k12 = this.lRot128high(l3, l2, 60);
                this._k11 = this.lRot128low(l3, l2, 60);
                this._k10 = this.lRot128high(l10, l11, 60);
                this._k9 = this.lRot128low(l10, l11, 60);
                this._k8 = this.lRot128high(l5, l4, 77);
                this._k7 = this.lRot128low(l5, l4, 77);
                this._k6 = this.lRot128high(l3, l2, 94);
                this._k5 = this.lRot128low(l3, l2, 94);
                this._k4 = this.lRot128high(l8, l9, 94);
                this._k3 = this.lRot128low(l8, l9, 94);
                this._k2 = this.lRot128high(l5, l4, 111);
                this._k1 = this.lRot128low(l5, l4, 111);
                this._ke6 = this.lRot128high(l3, l2, 30);
                this._ke5 = this.lRot128low(l3, l2, 30);
                this._ke4 = this.lRot128high(l5, l4, 60);
                this._ke3 = this.lRot128low(l5, l4, 60);
                this._ke2 = this.lRot128high(l8, l9, 77);
                this._ke1 = this.lRot128low(l8, l9, 77);
            }
        }
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("only simple KeyParameter expected.");
        }
        this.setKey(bl, ((KeyParameter)cipherParameters).getKey());
        this.initialised = true;
    }

    public String getAlgorithmName() {
        return "Camellia";
    }

    public int getBlockSize() {
        return 16;
    }

    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (!this.initialised) {
            throw new IllegalStateException("Camellia engine not initialised");
        }
        if (n2 + 16 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 16 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this._keyIs128) {
            return this.processBlock128(byArray, n2, byArray2, n3);
        }
        return this.processBlock192or256(byArray, n2, byArray2, n3);
    }

    public void reset() {
    }

    private byte lRot8(byte by, int n2) {
        return (byte)(by << n2 | (by & 0xFF) >>> 8 - n2);
    }

    private int lRot32(int n2, int n3) {
        return n2 << n3 | n2 >>> -n3;
    }

    private long lRot128high(long l2, long l3, int n2) {
        l2 = n2 < 64 ? l2 << n2 | l3 >>> -n2 : (n2 == 64 ? l3 : l3 << n2 - 64 | l2 >>> -(n2 - 64));
        return l2;
    }

    private long lRot128low(long l2, long l3, int n2) {
        l3 = n2 < 64 ? l3 << n2 | l2 >>> -n2 : (n2 == 64 ? l2 : l2 << n2 - 64 | l3 >>> -(n2 - 64));
        return l3;
    }

    private long fl(long l2, long l3) {
        int n2 = (int)(l2 >> 32);
        int n3 = (int)l2;
        int n4 = (int)(l3 >> 32);
        int n5 = (int)l3;
        n3 ^= this.lRot32(n2 & n4, 1);
        return (long)(n2 ^= n3 | n5) << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    private long flInv(long l2, long l3) {
        int n2 = (int)(l2 >> 32);
        int n3 = (int)l2;
        int n4 = (int)(l3 >> 32);
        int n5 = (int)l3;
        n2 ^= n3 | n5;
        return (long)n2 << 32 | (long)(n3 ^= this.lRot32(n2 & n4, 1)) & 0xFFFFFFFFL;
    }

    private long f(long l2, long l3) {
        long l4 = l2 ^ l3;
        int n2 = (int)(l4 >> 32);
        int n3 = (int)l4;
        byte by = this.SBOX1[n2 >> 24 & 0xFF];
        byte by2 = this.SBOX2[n2 >> 16 & 0xFF];
        byte by3 = this.SBOX3[n2 >> 8 & 0xFF];
        byte by4 = this.SBOX4[n2 & 0xFF];
        byte by5 = this.SBOX2[n3 >> 24 & 0xFF];
        byte by6 = this.SBOX3[n3 >> 16 & 0xFF];
        byte by7 = this.SBOX4[n3 >> 8 & 0xFF];
        byte by8 = this.SBOX1[n3 & 0xFF];
        int n4 = by ^ by3 ^ by4 ^ by6 ^ by7 ^ by8;
        int n5 = by ^ by2 ^ by4 ^ by5 ^ by7 ^ by8;
        int n6 = by ^ by2 ^ by3 ^ by5 ^ by6 ^ by8;
        int n7 = by2 ^ by3 ^ by4 ^ by5 ^ by6 ^ by7;
        int n8 = by ^ by2 ^ by6 ^ by7 ^ by8;
        int n9 = by2 ^ by3 ^ by5 ^ by7 ^ by8;
        int n10 = by3 ^ by4 ^ by5 ^ by6 ^ by8;
        int n11 = by ^ by4 ^ by5 ^ by6 ^ by7;
        return (long)n4 << 56 | ((long)n5 & 0xFFL) << 48 | ((long)n6 & 0xFFL) << 40 | ((long)n7 & 0xFFL) << 32 | ((long)n8 & 0xFFL) << 24 | ((long)n9 & 0xFFL) << 16 | ((long)n10 & 0xFFL) << 8 | (long)n11 & 0xFFL;
    }

    private long bytesToWord(byte[] byArray, int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            l2 = (l2 << 8) + (long)(byArray[i2 + n2] & 0xFF);
        }
        return l2;
    }

    private void wordToBytes(long l2, byte[] byArray, int n2) {
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[7 - i2 + n2] = (byte)l2;
            l2 >>>= 8;
        }
    }

    private int processBlock128(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        long l2 = this.bytesToWord(byArray, n2);
        long l3 = this.bytesToWord(byArray, n2 + 8);
        l3 ^= this._kw2;
        l3 ^= this.f(l2 ^= this._kw1, this._k1);
        l2 ^= this.f(l3, this._k2);
        l3 ^= this.f(l2, this._k3);
        l2 ^= this.f(l3, this._k4);
        l3 ^= this.f(l2, this._k5);
        l2 ^= this.f(l3, this._k6);
        l2 = this.fl(l2, this._ke1);
        l3 = this.flInv(l3, this._ke2);
        l3 ^= this.f(l2, this._k7);
        l2 ^= this.f(l3, this._k8);
        l3 ^= this.f(l2, this._k9);
        l2 ^= this.f(l3, this._k10);
        l3 ^= this.f(l2, this._k11);
        l2 ^= this.f(l3, this._k12);
        l2 = this.fl(l2, this._ke3);
        l3 = this.flInv(l3, this._ke4);
        l3 ^= this.f(l2, this._k13);
        l2 ^= this.f(l3, this._k14);
        l3 ^= this.f(l2, this._k15);
        l2 ^= this.f(l3, this._k16);
        l3 ^= this.f(l2, this._k17);
        l2 ^= this.f(l3, this._k18);
        this.wordToBytes(l3 ^= this._kw3, byArray2, n3);
        this.wordToBytes(l2 ^= this._kw4, byArray2, n3 + 8);
        return 16;
    }

    private int processBlock192or256(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        long l2 = this.bytesToWord(byArray, n2);
        long l3 = this.bytesToWord(byArray, n2 + 8);
        l3 ^= this._kw2;
        l3 ^= this.f(l2 ^= this._kw1, this._k1);
        l2 ^= this.f(l3, this._k2);
        l3 ^= this.f(l2, this._k3);
        l2 ^= this.f(l3, this._k4);
        l3 ^= this.f(l2, this._k5);
        l2 ^= this.f(l3, this._k6);
        l2 = this.fl(l2, this._ke1);
        l3 = this.flInv(l3, this._ke2);
        l3 ^= this.f(l2, this._k7);
        l2 ^= this.f(l3, this._k8);
        l3 ^= this.f(l2, this._k9);
        l2 ^= this.f(l3, this._k10);
        l3 ^= this.f(l2, this._k11);
        l2 ^= this.f(l3, this._k12);
        l2 = this.fl(l2, this._ke3);
        l3 = this.flInv(l3, this._ke4);
        l3 ^= this.f(l2, this._k13);
        l2 ^= this.f(l3, this._k14);
        l3 ^= this.f(l2, this._k15);
        l2 ^= this.f(l3, this._k16);
        l3 ^= this.f(l2, this._k17);
        l2 ^= this.f(l3, this._k18);
        l2 = this.fl(l2, this._ke5);
        l3 = this.flInv(l3, this._ke6);
        l3 ^= this.f(l2, this._k19);
        l2 ^= this.f(l3, this._k20);
        l3 ^= this.f(l2, this._k21);
        l2 ^= this.f(l3, this._k22);
        l3 ^= this.f(l2, this._k23);
        l2 ^= this.f(l3, this._k24);
        this.wordToBytes(l3 ^= this._kw3, byArray2, n3);
        this.wordToBytes(l2 ^= this._kw4, byArray2, n3 + 8);
        return 16;
    }
}

