/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extension;

public class AuthorityInformationAccess
extends ASN1Encodable {
    private AccessDescription[] descriptions;

    public static AuthorityInformationAccess getInstance(Object object) {
        if (object instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AuthorityInformationAccess((ASN1Sequence)object);
        }
        if (object instanceof X509Extension) {
            return AuthorityInformationAccess.getInstance(X509Extension.convertValueToObject((X509Extension)object));
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AuthorityInformationAccess(ASN1Sequence aSN1Sequence) {
        this.descriptions = new AccessDescription[aSN1Sequence.size()];
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            this.descriptions[i2] = AccessDescription.getInstance(aSN1Sequence.getObjectAt(i2));
        }
    }

    public AuthorityInformationAccess(DERObjectIdentifier dERObjectIdentifier, GeneralName generalName) {
        this.descriptions = new AccessDescription[1];
        this.descriptions[0] = new AccessDescription(dERObjectIdentifier, generalName);
    }

    public AccessDescription[] getAccessDescriptions() {
        return this.descriptions;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.descriptions.length; ++i2) {
            aSN1EncodableVector.add(this.descriptions[i2]);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "AuthorityInformationAccess: Oid(" + this.descriptions[0].getAccessMethod().getId() + ")";
    }
}

