/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private int _length;

    DefiniteLengthInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._length = n2;
    }

    public int read() throws IOException {
        if (this._length > 0) {
            int n2 = this._in.read();
            if (n2 < 0) {
                throw new EOFException();
            }
            --this._length;
            return n2;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this._length > 0) {
            int n4 = Math.min(n3, this._length);
            int n5 = this._in.read(byArray, n2, n4);
            if (n5 < 0) {
                throw new EOFException();
            }
            this._length -= n5;
            return n5;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    byte[] toByteArray() throws IOException {
        byte[] byArray = new byte[this._length];
        if (this._length > 0) {
            int n2;
            int n3 = 0;
            do {
                if ((n2 = this._in.read(byArray, n3, this._length - n3)) >= 0) continue;
                throw new EOFException();
            } while ((n3 += n2) < this._length);
            this._length = 0;
        }
        this.setParentEofDetect(true);
        return byArray;
    }
}

