/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERApplicationSpecific
extends ASN1Object {
    private int tag;
    private byte[] octets;

    public DERApplicationSpecific(int n2, byte[] byArray) {
        this.tag = n2;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n2, DEREncodable dEREncodable) throws IOException {
        this(true, n2, dEREncodable);
    }

    public DERApplicationSpecific(boolean bl, int n2, DEREncodable dEREncodable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        dEROutputStream.writeObject(dEREncodable);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (n2 >= 31) {
            throw new IOException("unsupported tag number");
        }
        if (bl) {
            this.tag = n2 | 0x20;
            this.octets = byArray;
        } else {
            this.tag = n2;
            int n3 = this.getLengthOfLength(byArray);
            byte[] byArray2 = new byte[byArray.length - n3];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            this.octets = byArray2;
        }
    }

    private int getLengthOfLength(byte[] byArray) {
        int n2 = 2;
        while ((byArray[n2 - 1] & 0x80) != 0) {
            ++n2;
        }
        return n2;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public DERObject getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public DERObject getObject(int n2) throws IOException {
        if (this.tag >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byArray[0] = (byte)n2;
        return new ASN1InputStream(byArray).readObject();
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(0x40 | this.tag, this.octets);
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)dERObject;
        if (this.tag != dERApplicationSpecific.tag) {
            return false;
        }
        if (this.octets.length != dERApplicationSpecific.octets.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.octets.length; ++i2) {
            if (this.octets[i2] == dERApplicationSpecific.octets[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        byte[] byArray = this.getContents();
        int n2 = 0;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            n2 ^= (byArray[i2] & 0xFF) << i2 % 4;
        }
        return n2 ^ this.getApplicationTag();
    }
}

