/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERTaggedObject;

public class BERInputStream
extends DERInputStream {
    private static final DERObject END_OF_STREAM = new DERObject(){

        void encode(DEROutputStream dEROutputStream) throws IOException {
            throw new IOException("Eeek!");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    };

    public BERInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = this.read();
        while ((n2 = this.read()) >= 0 && (n3 != 0 || n2 != 0)) {
            byteArrayOutputStream.write(n3);
            n3 = n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DERObject dERObject;
        Vector<DERObject> vector = new Vector<DERObject>();
        while ((dERObject = this.readObject()) != END_OF_STREAM) {
            vector.addElement(dERObject);
        }
        return new BERConstructedOctetString(vector);
    }

    public DERObject readObject() throws IOException {
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        int n3 = this.readLength();
        if (n3 < 0) {
            switch (n2) {
                case 5: {
                    return null;
                }
                case 48: {
                    DERObject dERObject;
                    BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
                    while ((dERObject = this.readObject()) != END_OF_STREAM) {
                        bERConstructedSequence.addObject(dERObject);
                    }
                    return bERConstructedSequence;
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
                case 49: {
                    DERObject dERObject;
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    while ((dERObject = this.readObject()) != END_OF_STREAM) {
                        aSN1EncodableVector.add(dERObject);
                    }
                    return new BERSet(aSN1EncodableVector);
                }
            }
            if ((n2 & 0x80) != 0) {
                if ((n2 & 0x1F) == 31) {
                    throw new IOException("unsupported high tag encountered");
                }
                if ((n2 & 0x20) == 0) {
                    byte[] byArray = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, n2 & 0x1F, new DEROctetString(byArray));
                }
                DERObject dERObject = this.readObject();
                if (dERObject == END_OF_STREAM) {
                    return new DERTaggedObject(n2 & 0x1F);
                }
                DERObject dERObject2 = this.readObject();
                if (dERObject2 == END_OF_STREAM) {
                    return new BERTaggedObject(n2 & 0x1F, dERObject);
                }
                BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
                bERConstructedSequence.addObject(dERObject);
                do {
                    bERConstructedSequence.addObject(dERObject2);
                } while ((dERObject2 = this.readObject()) != END_OF_STREAM);
                return new BERTaggedObject(false, n2 & 0x1F, bERConstructedSequence);
            }
            throw new IOException("unknown BER object encountered");
        }
        if (n2 == 0 && n3 == 0) {
            return END_OF_STREAM;
        }
        byte[] byArray = new byte[n3];
        this.readFully(byArray);
        return this.buildObject(n2, byArray);
    }
}

