/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.storage.BigBlock;
import org.apache.poi.poifs.storage.BlockWritable;

public final class PropertyBlock
extends BigBlock {
    private static final int _properties_per_block = 4;
    private Property[] _properties = new Property[4];

    private PropertyBlock(Property[] properties, int offset) {
        for (int j2 = 0; j2 < 4; ++j2) {
            this._properties[j2] = properties[j2 + offset];
        }
    }

    public static BlockWritable[] createPropertyBlockArray(List properties) {
        int block_count = (properties.size() + 4 - 1) / 4;
        Property[] to_be_written = new Property[block_count * 4];
        System.arraycopy(properties.toArray(new Property[0]), 0, to_be_written, 0, properties.size());
        for (int j2 = properties.size(); j2 < to_be_written.length; ++j2) {
            to_be_written[j2] = new Property(){

                protected void preWrite() {
                }

                public boolean isDirectory() {
                    return false;
                }
            };
        }
        BlockWritable[] rvalue = new BlockWritable[block_count];
        for (int j3 = 0; j3 < block_count; ++j3) {
            rvalue[j3] = new PropertyBlock(to_be_written, j3 * 4);
        }
        return rvalue;
    }

    void writeData(OutputStream stream) throws IOException {
        for (int j2 = 0; j2 < 4; ++j2) {
            this._properties[j2].writeData(stream);
        }
    }
}

