/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.PrintWriter;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.model.Sheet;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.aggregates.WorksheetProtectionBlock;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheetConditionalFormatting;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFSheet
implements org.apache.poi.ss.usermodel.Sheet {
    private static final POILogger log = POILogFactory.getLogger(HSSFSheet.class);
    private static final int DEBUG = POILogger.DEBUG;
    public static final int INITIAL_CAPACITY = 20;
    private final Sheet _sheet;
    private final TreeMap<Integer, HSSFRow> _rows;
    protected final Workbook _book;
    protected final HSSFWorkbook _workbook;
    private int _firstrow;
    private int _lastrow;

    protected HSSFSheet(HSSFWorkbook workbook) {
        this._sheet = Sheet.createSheet();
        this._rows = new TreeMap();
        this._workbook = workbook;
        this._book = workbook.getWorkbook();
    }

    protected HSSFSheet(HSSFWorkbook workbook, Sheet sheet) {
        this._sheet = sheet;
        this._rows = new TreeMap();
        this._workbook = workbook;
        this._book = workbook.getWorkbook();
        this.setPropertiesFromSheet(sheet);
    }

    HSSFSheet cloneSheet(HSSFWorkbook workbook) {
        return new HSSFSheet(workbook, this._sheet.cloneSheet());
    }

    @Override
    public HSSFWorkbook getWorkbook() {
        return this._workbook;
    }

    private void setPropertiesFromSheet(Sheet sheet) {
        boolean rowRecordsAlreadyPresent;
        RowRecord row = sheet.getNextRow();
        boolean bl = rowRecordsAlreadyPresent = row != null;
        while (row != null) {
            this.createRowFromRecord(row);
            row = sheet.getNextRow();
        }
        CellValueRecordInterface[] cvals = sheet.getValueRecords();
        long timestart = System.currentTimeMillis();
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"Time at start of cell creating in HSSF sheet = ", timestart);
        }
        HSSFRow lastrow = null;
        for (int i2 = 0; i2 < cvals.length; ++i2) {
            CellValueRecordInterface cval = cvals[i2];
            long cellstart = System.currentTimeMillis();
            HSSFRow hrow = lastrow;
            if (hrow == null || hrow.getRowNum() != cval.getRow()) {
                lastrow = hrow = this.getRow(cval.getRow());
                if (hrow == null) {
                    if (rowRecordsAlreadyPresent) {
                        throw new RuntimeException("Unexpected missing row when some rows already present");
                    }
                    RowRecord rowRec = new RowRecord(cval.getRow());
                    sheet.addRow(rowRec);
                    hrow = this.createRowFromRecord(rowRec);
                }
            }
            if (log.check(POILogger.DEBUG)) {
                log.log(DEBUG, "record id = " + Integer.toHexString(((Record)((Object)cval)).getSid()));
            }
            hrow.createCellFromRecord(cval);
            if (!log.check(POILogger.DEBUG)) continue;
            log.log(DEBUG, (Object)"record took ", System.currentTimeMillis() - cellstart);
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"total sheet cell creation took ", System.currentTimeMillis() - timestart);
        }
    }

    @Override
    public HSSFRow createRow(int rownum) {
        HSSFRow row = new HSSFRow(this._workbook, this, rownum);
        this.addRow(row, true);
        return row;
    }

    private HSSFRow createRowFromRecord(RowRecord row) {
        HSSFRow hrow = new HSSFRow(this._workbook, this, row);
        this.addRow(hrow, false);
        return hrow;
    }

    @Override
    public void removeRow(Row row) {
        HSSFRow hrow = (HSSFRow)row;
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        if (this._rows.size() > 0) {
            Integer key = row.getRowNum();
            HSSFRow removedRow = this._rows.remove(key);
            if (removedRow != row) {
                throw new IllegalArgumentException("Specified row does not belong to this sheet");
            }
            if (hrow.getRowNum() == this.getLastRowNum()) {
                this._lastrow = this.findLastRow(this._lastrow);
            }
            if (hrow.getRowNum() == this.getFirstRowNum()) {
                this._firstrow = this.findFirstRow(this._firstrow);
            }
            this._sheet.removeRow(hrow.getRowRecord());
        }
    }

    private int findLastRow(int lastrow) {
        if (lastrow < 1) {
            return 0;
        }
        int rownum = lastrow - 1;
        HSSFRow r2 = this.getRow(rownum);
        while (r2 == null && rownum > 0) {
            r2 = this.getRow(--rownum);
        }
        if (r2 == null) {
            return 0;
        }
        return rownum;
    }

    private int findFirstRow(int firstrow) {
        int rownum = firstrow + 1;
        HSSFRow r2 = this.getRow(rownum);
        while (r2 == null && rownum <= this.getLastRowNum()) {
            r2 = this.getRow(++rownum);
        }
        if (rownum > this.getLastRowNum()) {
            return 0;
        }
        return rownum;
    }

    private void addRow(HSSFRow row, boolean addLow) {
        boolean firstRow;
        this._rows.put(row.getRowNum(), row);
        if (addLow) {
            this._sheet.addRow(row.getRowRecord());
        }
        boolean bl = firstRow = this._rows.size() == 1;
        if (row.getRowNum() > this.getLastRowNum() || firstRow) {
            this._lastrow = row.getRowNum();
        }
        if (row.getRowNum() < this.getFirstRowNum() || firstRow) {
            this._firstrow = row.getRowNum();
        }
    }

    @Override
    public HSSFRow getRow(int rowIndex) {
        return this._rows.get(rowIndex);
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    @Override
    public int getFirstRowNum() {
        return this._firstrow;
    }

    @Override
    public int getLastRowNum() {
        return this._lastrow;
    }

    public void addValidationData(HSSFDataValidation dataValidation) {
        if (dataValidation == null) {
            throw new IllegalArgumentException("objValidation must not be null");
        }
        DataValidityTable dvt = this._sheet.getOrCreateDataValidityTable();
        DVRecord dvRecord = dataValidation.createDVRecord(this);
        dvt.addDataValidation(dvRecord);
    }

    public void setColumnHidden(short columnIndex, boolean hidden) {
        this.setColumnHidden(columnIndex & 0xFFFF, hidden);
    }

    public boolean isColumnHidden(short columnIndex) {
        return this.isColumnHidden(columnIndex & 0xFFFF);
    }

    public void setColumnWidth(short columnIndex, short width) {
        this.setColumnWidth(columnIndex & 0xFFFF, width & 0xFFFF);
    }

    public short getColumnWidth(short columnIndex) {
        return (short)this.getColumnWidth(columnIndex & 0xFFFF);
    }

    public void setDefaultColumnWidth(short width) {
        this.setDefaultColumnWidth(width & 0xFFFF);
    }

    @Override
    public void setColumnHidden(int columnIndex, boolean hidden) {
        this._sheet.setColumnHidden(columnIndex, hidden);
    }

    @Override
    public boolean isColumnHidden(int columnIndex) {
        return this._sheet.isColumnHidden(columnIndex);
    }

    @Override
    public void setColumnWidth(int columnIndex, int width) {
        this._sheet.setColumnWidth(columnIndex, width);
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return this._sheet.getColumnWidth(columnIndex);
    }

    @Override
    public int getDefaultColumnWidth() {
        return this._sheet.getDefaultColumnWidth();
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this._sheet.setDefaultColumnWidth(width);
    }

    @Override
    public short getDefaultRowHeight() {
        return this._sheet.getDefaultRowHeight();
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        return (float)this._sheet.getDefaultRowHeight() / 20.0f;
    }

    @Override
    public void setDefaultRowHeight(short height) {
        this._sheet.setDefaultRowHeight(height);
    }

    @Override
    public void setDefaultRowHeightInPoints(float height) {
        this._sheet.setDefaultRowHeight((short)(height * 20.0f));
    }

    @Override
    public HSSFCellStyle getColumnStyle(int column) {
        short styleIndex = this._sheet.getXFIndexForColAt((short)column);
        if (styleIndex == 15) {
            return null;
        }
        ExtendedFormatRecord xf = this._book.getExFormatAt(styleIndex);
        return new HSSFCellStyle(styleIndex, xf, this._book);
    }

    public boolean isGridsPrinted() {
        return this._sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean value) {
        this._sheet.setGridsPrinted(value);
    }

    public int addMergedRegion(org.apache.poi.ss.util.Region region) {
        return this._sheet.addMergedRegion(region.getRowFrom(), region.getColumnFrom(), region.getRowTo(), region.getColumnTo());
    }

    @Override
    public int addMergedRegion(CellRangeAddress region) {
        region.validate(SpreadsheetVersion.EXCEL97);
        return this._sheet.addMergedRegion(region.getFirstRow(), region.getFirstColumn(), region.getLastRow(), region.getLastColumn());
    }

    public void setForceFormulaRecalculation(boolean value) {
        this._sheet.setUncalced(value);
    }

    public boolean getForceFormulaRecalculation() {
        return this._sheet.getUncalced();
    }

    @Override
    public void setVerticallyCenter(boolean value) {
        this._sheet.getPageSettings().getVCenter().setVCenter(value);
    }

    public boolean getVerticallyCenter(boolean value) {
        return this.getVerticallyCenter();
    }

    @Override
    public boolean getVerticallyCenter() {
        return this._sheet.getPageSettings().getVCenter().getVCenter();
    }

    @Override
    public void setHorizontallyCenter(boolean value) {
        this._sheet.getPageSettings().getHCenter().setHCenter(value);
    }

    @Override
    public boolean getHorizontallyCenter() {
        return this._sheet.getPageSettings().getHCenter().getHCenter();
    }

    public void setRightToLeft(boolean value) {
        this._sheet.getWindowTwo().setArabic(value);
    }

    public boolean isRightToLeft() {
        return this._sheet.getWindowTwo().getArabic();
    }

    @Override
    public void removeMergedRegion(int index) {
        this._sheet.removeMergedRegion(index);
    }

    @Override
    public int getNumMergedRegions() {
        return this._sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int index) {
        CellRangeAddress cra = this.getMergedRegion(index);
        return new Region(cra.getFirstRow(), (short)cra.getFirstColumn(), cra.getLastRow(), (short)cra.getLastColumn());
    }

    @Override
    public CellRangeAddress getMergedRegion(int index) {
        return this._sheet.getMergedRegionAt(index);
    }

    @Override
    public Iterator<Row> rowIterator() {
        Iterator<Row> result = this._rows.values().iterator();
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    Sheet getSheet() {
        return this._sheet;
    }

    public void setAlternativeExpression(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAlternateExpression(b2);
    }

    public void setAlternativeFormula(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAlternateFormula(b2);
    }

    @Override
    public void setAutobreaks(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setAutobreaks(b2);
    }

    public void setDialog(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setDialog(b2);
    }

    @Override
    public void setDisplayGuts(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setDisplayGuts(b2);
    }

    @Override
    public void setFitToPage(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setFitToPage(b2);
    }

    @Override
    public void setRowSumsBelow(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setRowSumsBelow(b2);
        record.setAlternateExpression(b2);
    }

    @Override
    public void setRowSumsRight(boolean b2) {
        WSBoolRecord record = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        record.setRowSumsRight(b2);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    @Override
    public boolean getAutobreaks() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    @Override
    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    @Override
    public boolean isDisplayZeros() {
        return this._sheet.getWindowTwo().getDisplayZeros();
    }

    @Override
    public void setDisplayZeros(boolean value) {
        this._sheet.getWindowTwo().setDisplayZeros(value);
    }

    @Override
    public boolean getFitToPage() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    @Override
    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    @Override
    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    @Override
    public boolean isPrintGridlines() {
        return this.getSheet().getPrintGridlines().getPrintGridlines();
    }

    @Override
    public void setPrintGridlines(boolean newPrintGridlines) {
        this.getSheet().getPrintGridlines().setPrintGridlines(newPrintGridlines);
    }

    @Override
    public HSSFPrintSetup getPrintSetup() {
        return new HSSFPrintSetup(this._sheet.getPageSettings().getPrintSetup());
    }

    @Override
    public HSSFHeader getHeader() {
        return new HSSFHeader(this._sheet.getPageSettings());
    }

    @Override
    public HSSFFooter getFooter() {
        return new HSSFFooter(this._sheet.getPageSettings());
    }

    @Override
    public boolean isSelected() {
        return this.getSheet().getWindowTwo().getSelected();
    }

    @Override
    public void setSelected(boolean sel) {
        this.getSheet().getWindowTwo().setSelected(sel);
    }

    public boolean isActive() {
        return this.getSheet().getWindowTwo().isActive();
    }

    public void setActive(boolean sel) {
        this.getSheet().getWindowTwo().setActive(sel);
    }

    @Override
    public double getMargin(short margin) {
        return this._sheet.getPageSettings().getMargin(margin);
    }

    @Override
    public void setMargin(short margin, double size) {
        this._sheet.getPageSettings().setMargin(margin, size);
    }

    private WorksheetProtectionBlock getProtectionBlock() {
        return this._sheet.getProtectionBlock();
    }

    @Override
    public boolean getProtect() {
        return this.getProtectionBlock().isSheetProtected();
    }

    public short getPassword() {
        return (short)this.getProtectionBlock().getPasswordHash();
    }

    public boolean getObjectProtect() {
        return this.getProtectionBlock().isObjectProtected();
    }

    @Override
    public boolean getScenarioProtect() {
        return this.getProtectionBlock().isScenarioProtected();
    }

    public void protectSheet(String password) {
        this.getProtectionBlock().protectSheet(password, true, true);
    }

    @Override
    public void setZoom(int numerator, int denominator) {
        if (numerator < 1 || numerator > 65535) {
            throw new IllegalArgumentException("Numerator must be greater than 1 and less than 65536");
        }
        if (denominator < 1 || denominator > 65535) {
            throw new IllegalArgumentException("Denominator must be greater than 1 and less than 65536");
        }
        SCLRecord sclRecord = new SCLRecord();
        sclRecord.setNumerator((short)numerator);
        sclRecord.setDenominator((short)denominator);
        this.getSheet().setSCLRecord(sclRecord);
    }

    @Override
    public short getTopRow() {
        return this._sheet.getTopRow();
    }

    @Override
    public short getLeftCol() {
        return this._sheet.getLeftCol();
    }

    @Override
    public void showInPane(short toprow, short leftcol) {
        this._sheet.setTopRow(toprow);
        this._sheet.setLeftCol(leftcol);
    }

    protected void shiftMerged(int startRow, int endRow, int n2, boolean isRow) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        for (int i2 = 0; i2 < this.getNumMergedRegions(); ++i2) {
            boolean inEnd;
            CellRangeAddress merged = this.getMergedRegion(i2);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || HSSFSheet.containsCell(merged, startRow - 1, 0) || HSSFSheet.containsCell(merged, endRow + 1, 0)) continue;
            merged.setFirstRow(merged.getFirstRow() + n2);
            merged.setLastRow(merged.getLastRow() + n2);
            shiftedRegions.add(merged);
            this.removeMergedRegion(i2);
            --i2;
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.addMergedRegion(region);
        }
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n2) {
        this.shiftRows(startRow, endRow, n2, false, false);
    }

    @Override
    public void shiftRows(int startRow, int endRow, int n2, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        this.shiftRows(startRow, endRow, n2, copyRowHeight, resetOriginalRowHeight, true);
    }

    public void shiftRows(int startRow, int endRow, int n2, boolean copyRowHeight, boolean resetOriginalRowHeight, boolean moveComments) {
        int inc;
        int s2;
        if (n2 < 0) {
            s2 = startRow;
            inc = 1;
        } else {
            s2 = endRow;
            inc = -1;
        }
        NoteRecord[] noteRecs = moveComments ? this._sheet.getNoteRecords() : NoteRecord.EMPTY_ARRAY;
        this.shiftMerged(startRow, endRow, n2, true);
        this._sheet.getPageSettings().shiftRowBreaks(startRow, endRow, n2);
        for (int rowNum = s2; rowNum >= startRow && rowNum <= endRow && rowNum >= 0 && rowNum < 65536; rowNum += inc) {
            HSSFRow row = this.getRow(rowNum);
            HSSFRow row2Replace = this.getRow(rowNum + n2);
            if (row2Replace == null) {
                row2Replace = this.createRow(rowNum + n2);
            }
            row2Replace.removeAllCells();
            if (row == null) continue;
            if (copyRowHeight) {
                row2Replace.setHeight(row.getHeight());
            }
            if (resetOriginalRowHeight) {
                row.setHeight((short)255);
            }
            Iterator<Cell> cells = row.cellIterator();
            while (cells.hasNext()) {
                HSSFCell cell = (HSSFCell)cells.next();
                row.removeCell(cell);
                CellValueRecordInterface cellRecord = cell.getCellValueRecord();
                cellRecord.setRow(rowNum + n2);
                row2Replace.createCellFromRecord(cellRecord);
                this._sheet.addValueRecord(rowNum + n2, cellRecord);
                HSSFHyperlink link = cell.getHyperlink();
                if (link == null) continue;
                link.setFirstRow(link.getFirstRow() + n2);
                link.setLastRow(link.getLastRow() + n2);
            }
            row.removeAllCells();
            if (!moveComments) continue;
            for (int i2 = noteRecs.length - 1; i2 >= 0; --i2) {
                HSSFComment comment;
                NoteRecord nr = noteRecs[i2];
                if (nr.getRow() != rowNum || (comment = this.getCellComment(rowNum, nr.getColumn())) == null) continue;
                comment.setRow(rowNum + n2);
            }
        }
        if (endRow == this._lastrow || endRow + n2 > this._lastrow) {
            this._lastrow = Math.min(endRow + n2, SpreadsheetVersion.EXCEL97.getLastRowIndex());
        }
        if (startRow == this._firstrow || startRow + n2 < this._firstrow) {
            this._firstrow = Math.max(startRow + n2, 0);
        }
        int sheetIndex = this._workbook.getSheetIndex(this);
        short externSheetIndex = this._book.checkExternSheet(sheetIndex);
        FormulaShifter shifter = FormulaShifter.createForRowShift(externSheetIndex, startRow, endRow, n2);
        this._sheet.updateFormulasAfterCellShift(shifter, externSheetIndex);
        int nSheets = this._workbook.getNumberOfSheets();
        for (int i3 = 0; i3 < nSheets; ++i3) {
            Sheet otherSheet = this._workbook.getSheetAt(i3).getSheet();
            if (otherSheet == this._sheet) continue;
            short otherExtSheetIx = this._book.checkExternSheet(i3);
            otherSheet.updateFormulasAfterCellShift(shifter, otherExtSheetIx);
        }
        this._workbook.getWorkbook().updateNamesAfterCellShift(shifter);
    }

    protected void insertChartRecords(List<Record> records) {
        int window2Loc = this._sheet.findFirstRecordLocBySid((short)574);
        this._sheet.getRecords().addAll(window2Loc, records);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this.validateColumn(colSplit);
        this.validateRow(rowSplit);
        if (leftmostColumn < colSplit) {
            throw new IllegalArgumentException("leftmostColumn parameter must not be less than colSplit parameter");
        }
        if (topRow < rowSplit) {
            throw new IllegalArgumentException("topRow parameter must not be less than leftmostColumn parameter");
        }
        this.getSheet().createFreezePane(colSplit, rowSplit, topRow, leftmostColumn);
    }

    @Override
    public void createFreezePane(int colSplit, int rowSplit) {
        this.createFreezePane(colSplit, rowSplit, colSplit, rowSplit);
    }

    @Override
    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this.getSheet().createSplitPane(xSplitPos, ySplitPos, topRow, leftmostColumn, activePane);
    }

    @Override
    public PaneInformation getPaneInformation() {
        return this.getSheet().getPaneInformation();
    }

    @Override
    public void setDisplayGridlines(boolean show) {
        this._sheet.setDisplayGridlines(show);
    }

    @Override
    public boolean isDisplayGridlines() {
        return this._sheet.isDisplayGridlines();
    }

    @Override
    public void setDisplayFormulas(boolean show) {
        this._sheet.setDisplayFormulas(show);
    }

    @Override
    public boolean isDisplayFormulas() {
        return this._sheet.isDisplayFormulas();
    }

    @Override
    public void setDisplayRowColHeadings(boolean show) {
        this._sheet.setDisplayRowColHeadings(show);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this._sheet.isDisplayRowColHeadings();
    }

    @Override
    public void setRowBreak(int row) {
        this.validateRow(row);
        this._sheet.getPageSettings().setRowBreak(row, (short)0, (short)255);
    }

    @Override
    public boolean isRowBroken(int row) {
        return this._sheet.getPageSettings().isRowBroken(row);
    }

    @Override
    public void removeRowBreak(int row) {
        this._sheet.getPageSettings().removeRowBreak(row);
    }

    @Override
    public int[] getRowBreaks() {
        return this._sheet.getPageSettings().getRowBreaks();
    }

    @Override
    public int[] getColumnBreaks() {
        return this._sheet.getPageSettings().getColumnBreaks();
    }

    @Override
    public void setColumnBreak(int column) {
        this.validateColumn((short)column);
        this._sheet.getPageSettings().setColumnBreak((short)column, (short)0, (short)SpreadsheetVersion.EXCEL97.getLastRowIndex());
    }

    @Override
    public boolean isColumnBroken(int column) {
        return this._sheet.getPageSettings().isColumnBroken(column);
    }

    @Override
    public void removeColumnBreak(int column) {
        this._sheet.getPageSettings().removeColumnBreak(column);
    }

    protected void validateRow(int row) {
        int maxrow = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (row > maxrow) {
            throw new IllegalArgumentException("Maximum row number is " + maxrow);
        }
        if (row < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    protected void validateColumn(int column) {
        int maxcol = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
        if (column > maxcol) {
            throw new IllegalArgumentException("Maximum column number is " + maxcol);
        }
        if (column < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public void dumpDrawingRecords(boolean fat) {
        this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        EscherAggregate r2 = (EscherAggregate)this.getSheet().findFirstRecordBySid((short)9876);
        List escherRecords = r2.getEscherRecords();
        PrintWriter w2 = new PrintWriter(System.out);
        for (EscherRecord escherRecord : escherRecords) {
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w2, 0);
        }
        w2.flush();
    }

    @Override
    public HSSFPatriarch createDrawingPatriarch() {
        this._book.createDrawingGroup();
        this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), true);
        EscherAggregate agg = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876);
        HSSFPatriarch patriarch = new HSSFPatriarch(this, agg);
        agg.clear();
        agg.setPatriarch(patriarch);
        return patriarch;
    }

    public EscherAggregate getDrawingEscherAggregate() {
        this._book.findDrawingGroup();
        if (this._book.getDrawingManager() == null) {
            return null;
        }
        int found = this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        if (found == -1) {
            return null;
        }
        EscherAggregate agg = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876);
        return agg;
    }

    public HSSFPatriarch getDrawingPatriarch() {
        EscherAggregate agg = this.getDrawingEscherAggregate();
        if (agg == null) {
            return null;
        }
        HSSFPatriarch patriarch = new HSSFPatriarch(this, agg);
        agg.setPatriarch(patriarch);
        agg.convertRecordsToUserModel();
        return patriarch;
    }

    public void setColumnGroupCollapsed(short columnNumber, boolean collapsed) {
        this.setColumnGroupCollapsed(columnNumber & 0xFFFF, collapsed);
    }

    public void groupColumn(short fromColumn, short toColumn) {
        this.groupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    public void ungroupColumn(short fromColumn, short toColumn) {
        this.ungroupColumn(fromColumn & 0xFFFF, toColumn & 0xFFFF);
    }

    @Override
    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this._sheet.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    @Override
    public void groupColumn(int fromColumn, int toColumn) {
        this._sheet.groupColumnRange(fromColumn, toColumn, true);
    }

    @Override
    public void ungroupColumn(int fromColumn, int toColumn) {
        this._sheet.groupColumnRange(fromColumn, toColumn, false);
    }

    @Override
    public void groupRow(int fromRow, int toRow) {
        this._sheet.groupRowRange(fromRow, toRow, true);
    }

    @Override
    public void ungroupRow(int fromRow, int toRow) {
        this._sheet.groupRowRange(fromRow, toRow, false);
    }

    @Override
    public void setRowGroupCollapsed(int rowIndex, boolean collapse) {
        if (collapse) {
            this._sheet.getRowsAggregate().collapseRow(rowIndex);
        } else {
            this._sheet.getRowsAggregate().expandRow(rowIndex);
        }
    }

    @Override
    public void setDefaultColumnStyle(int column, CellStyle style) {
        this._sheet.setDefaultColumnStyle(column, ((HSSFCellStyle)style).getIndex());
    }

    @Override
    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    @Override
    public void autoSizeColumn(int column, boolean useMergedCells) {
        char defaultChar = '0';
        double fontHeightMultiple = 2.0;
        FontRenderContext frc = new FontRenderContext(null, true, true);
        HSSFWorkbook wb = new HSSFWorkbook(this._book);
        HSSFFont defaultFont = wb.getFontAt((short)0);
        AttributedString str = new AttributedString("" + defaultChar);
        this.copyAttributes(defaultFont, str, 0, 1);
        TextLayout layout = new TextLayout(str.getIterator(), frc);
        int defaultCharWidth = (int)layout.getAdvance();
        double width = -1.0;
        Iterator<Row> it = this.rowIterator();
        block2: while (it.hasNext()) {
            String sval;
            HSSFFont font;
            HSSFCellStyle style;
            int colspan;
            HSSFCell cell;
            block17: {
                HSSFRow row = (HSSFRow)it.next();
                cell = row.getCell(column);
                if (cell == null) continue;
                colspan = 1;
                for (int i2 = 0; i2 < this.getNumMergedRegions(); ++i2) {
                    CellRangeAddress region = this.getMergedRegion(i2);
                    if (!HSSFSheet.containsCell(region, row.getRowNum(), column)) continue;
                    if (!useMergedCells) continue block2;
                    cell = row.getCell(region.getFirstColumn());
                    colspan = 1 + region.getLastColumn() - region.getFirstColumn();
                }
                style = cell.getCellStyle();
                int cellType = cell.getCellType();
                if (cellType == 2) {
                    cellType = cell.getCachedFormulaResultType();
                }
                font = wb.getFontAt(style.getFontIndex());
                if (cellType == 1) {
                    HSSFRichTextString rt = cell.getRichStringCellValue();
                    String[] lines = rt.getString().split("\\n");
                    for (int i3 = 0; i3 < lines.length; ++i3) {
                        String txt = lines[i3] + defaultChar;
                        str = new AttributedString(txt);
                        this.copyAttributes(font, str, 0, txt.length());
                        if (rt.numFormattingRuns() > 0) {
                            for (int j2 = 0; j2 < lines[i3].length(); ++j2) {
                                short idx = rt.getFontAtIndex(j2);
                                if (idx == 0) continue;
                                HSSFFont fnt = wb.getFontAt(idx);
                                this.copyAttributes(fnt, str, j2, j2 + 1);
                            }
                        }
                        layout = new TextLayout(str.getIterator(), frc);
                        if (style.getRotation() != 0) {
                            AffineTransform trans = new AffineTransform();
                            trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                            trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                            width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                            continue;
                        }
                        width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                    }
                    continue;
                }
                sval = null;
                if (cellType == 0) {
                    String dfmt = style.getDataFormatString();
                    String format = dfmt == null ? null : dfmt.replaceAll("\"", "");
                    double value = cell.getNumericCellValue();
                    try {
                        if ("General".equals(format)) {
                            sval = "" + value;
                            break block17;
                        }
                        DecimalFormat fmt = new DecimalFormat(format);
                        sval = fmt.format(value);
                    }
                    catch (Exception e2) {
                        sval = "" + value;
                    }
                } else if (cellType == 4) {
                    sval = String.valueOf(cell.getBooleanCellValue());
                }
            }
            if (sval == null) continue;
            String txt = sval + defaultChar;
            str = new AttributedString(txt);
            this.copyAttributes(font, str, 0, txt.length());
            layout = new TextLayout(str.getIterator(), frc);
            if (style.getRotation() != 0) {
                AffineTransform trans = new AffineTransform();
                trans.concatenate(AffineTransform.getRotateInstance((double)style.getRotation() * 2.0 * Math.PI / 360.0));
                trans.concatenate(AffineTransform.getScaleInstance(1.0, fontHeightMultiple));
                width = Math.max(width, layout.getOutline(trans).getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
                continue;
            }
            width = Math.max(width, layout.getBounds().getWidth() / (double)colspan / (double)defaultCharWidth + (double)cell.getCellStyle().getIndention());
        }
        if (width != -1.0) {
            if ((width *= 256.0) > 32767.0) {
                width = 32767.0;
            }
            this._sheet.setColumnWidth(column, (short)width);
        }
    }

    private void copyAttributes(HSSFFont font, AttributedString str, int startIdx, int endIdx) {
        str.addAttribute(TextAttribute.FAMILY, font.getFontName(), startIdx, endIdx);
        str.addAttribute(TextAttribute.SIZE, new Float(font.getFontHeightInPoints()));
        if (font.getBoldweight() == 700) {
            str.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIdx, endIdx);
        }
        if (font.getItalic()) {
            str.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIdx, endIdx);
        }
        if (font.getUnderline() == 1) {
            str.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIdx, endIdx);
        }
    }

    @Override
    public HSSFComment getCellComment(int row, int column) {
        HSSFRow r2 = this.getRow(row);
        if (r2 != null) {
            HSSFCell c2 = r2.getCell(column);
            if (c2 != null) {
                return c2.getCellComment();
            }
            return HSSFCell.findCellComment(this._sheet, row, column);
        }
        return null;
    }

    public HSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new HSSFSheetConditionalFormatting(this);
    }

    @Override
    public String getSheetName() {
        HSSFWorkbook wb = this.getWorkbook();
        int idx = wb.getSheetIndex(this);
        return wb.getSheetName(idx);
    }
}

