/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Fixed2ArgFunction;
import org.apache.poi.hssf.record.formula.functions.LookupUtils;

public abstract class XYNumericFunction
extends Fixed2ArgFunction {
    protected abstract Accumulator createAccumulator();

    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        double result;
        try {
            LookupUtils.ValueVector vvX = XYNumericFunction.createValueVector(arg0);
            LookupUtils.ValueVector vvY = XYNumericFunction.createValueVector(arg1);
            int size = vvX.getSize();
            if (size == 0 || vvY.getSize() != size) {
                return ErrorEval.NA;
            }
            result = this.evaluateInternal(vvX, vvY, size);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(result);
    }

    private double evaluateInternal(LookupUtils.ValueVector x2, LookupUtils.ValueVector y2, int size) throws EvaluationException {
        Accumulator acc = this.createAccumulator();
        ErrorEval firstXerr = null;
        ErrorEval firstYerr = null;
        boolean accumlatedSome = false;
        double result = 0.0;
        for (int i2 = 0; i2 < size; ++i2) {
            ValueEval vx = x2.getItem(i2);
            ValueEval vy = y2.getItem(i2);
            if (vx instanceof ErrorEval && firstXerr == null) {
                firstXerr = (ErrorEval)vx;
                continue;
            }
            if (vy instanceof ErrorEval && firstYerr == null) {
                firstYerr = (ErrorEval)vy;
                continue;
            }
            if (!(vx instanceof NumberEval) || !(vy instanceof NumberEval)) continue;
            accumlatedSome = true;
            NumberEval nx = (NumberEval)vx;
            NumberEval ny = (NumberEval)vy;
            result += acc.accumulate(nx.getNumberValue(), ny.getNumberValue());
        }
        if (firstXerr != null) {
            throw new EvaluationException(firstXerr);
        }
        if (firstYerr != null) {
            throw new EvaluationException(firstYerr);
        }
        if (!accumlatedSome) {
            throw new EvaluationException(ErrorEval.DIV_ZERO);
        }
        return result;
    }

    private static LookupUtils.ValueVector createValueVector(ValueEval arg) throws EvaluationException {
        if (arg instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)arg);
        }
        if (arg instanceof AreaEval) {
            return new AreaValueArray((AreaEval)arg);
        }
        if (arg instanceof RefEval) {
            return new RefValueArray((RefEval)arg);
        }
        return new SingleCellValueArray(arg);
    }

    protected static interface Accumulator {
        public double accumulate(double var1, double var3);
    }

    private static final class AreaValueArray
    extends ValueArray {
        private final AreaEval _ae;
        private final int _width;

        public AreaValueArray(AreaEval ae2) {
            super(ae2.getWidth() * ae2.getHeight());
            this._ae = ae2;
            this._width = ae2.getWidth();
        }

        protected ValueEval getItemInternal(int index) {
            int rowIx = index / this._width;
            int colIx = index % this._width;
            return this._ae.getRelativeValue(rowIx, colIx);
        }
    }

    private static final class RefValueArray
    extends ValueArray {
        private final RefEval _ref;

        public RefValueArray(RefEval ref) {
            super(1);
            this._ref = ref;
        }

        protected ValueEval getItemInternal(int index) {
            return this._ref.getInnerValueEval();
        }
    }

    private static final class SingleCellValueArray
    extends ValueArray {
        private final ValueEval _value;

        public SingleCellValueArray(ValueEval value) {
            super(1);
            this._value = value;
        }

        protected ValueEval getItemInternal(int index) {
            return this._value;
        }
    }

    private static abstract class ValueArray
    implements LookupUtils.ValueVector {
        private final int _size;

        protected ValueArray(int size) {
            this._size = size;
        }

        public ValueEval getItem(int index) {
            if (index < 0 || index > this._size) {
                throw new IllegalArgumentException("Specified index " + index + " is outside range (0.." + (this._size - 1) + ")");
            }
            return this.getItemInternal(index);
        }

        protected abstract ValueEval getItemInternal(int var1);

        public final int getSize() {
            return this._size;
        }
    }
}

