/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.Arrays;

final class StatsLib {
    private StatsLib() {
    }

    public static double avedev(double[] v2) {
        int i2;
        double r2 = 0.0;
        double m2 = 0.0;
        double s2 = 0.0;
        int iSize = v2.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s2 += v2[i2];
        }
        m2 = s2 / (double)v2.length;
        s2 = 0.0;
        iSize = v2.length;
        for (i2 = 0; i2 < iSize; ++i2) {
            s2 += Math.abs(v2[i2] - m2);
        }
        r2 = s2 / (double)v2.length;
        return r2;
    }

    public static double stdev(double[] v2) {
        double r2 = Double.NaN;
        if (v2 != null && v2.length > 1) {
            r2 = Math.sqrt(StatsLib.devsq(v2) / (double)(v2.length - 1));
        }
        return r2;
    }

    public static double median(double[] v2) {
        double r2 = Double.NaN;
        if (v2 != null && v2.length >= 1) {
            int n2 = v2.length;
            Arrays.sort(v2);
            r2 = n2 % 2 == 0 ? (v2[n2 / 2] + v2[n2 / 2 - 1]) / 2.0 : v2[n2 / 2];
        }
        return r2;
    }

    public static double devsq(double[] v2) {
        double r2 = Double.NaN;
        if (v2 != null && v2.length >= 1) {
            int i2;
            double m2 = 0.0;
            double s2 = 0.0;
            int n2 = v2.length;
            for (i2 = 0; i2 < n2; ++i2) {
                s2 += v2[i2];
            }
            m2 = s2 / (double)n2;
            s2 = 0.0;
            for (i2 = 0; i2 < n2; ++i2) {
                s2 += (v2[i2] - m2) * (v2[i2] - m2);
            }
            r2 = n2 == 1 ? 0.0 : s2;
        }
        return r2;
    }

    public static double kthLargest(double[] v2, int k2) {
        double r2 = Double.NaN;
        int index = k2 - 1;
        if (v2 != null && v2.length > index && index >= 0) {
            Arrays.sort(v2);
            r2 = v2[v2.length - index - 1];
        }
        return r2;
    }

    public static double kthSmallest(double[] v2, int k2) {
        double r2 = Double.NaN;
        int index = k2 - 1;
        if (v2 != null && v2.length > index && index >= 0) {
            Arrays.sort(v2);
            r2 = v2[index];
        }
        return r2;
    }
}

