/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.MissingArgEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function2Arg;
import org.apache.poi.hssf.record.formula.functions.Function3Arg;
import org.apache.poi.hssf.record.formula.functions.Function4Arg;

public final class Index
implements Function2Arg,
Function3Arg,
Function4Arg {
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        AreaEval reference = Index.convertFirstArg(arg0);
        boolean colArgWasPassed = false;
        int columnIx = 0;
        try {
            int rowIx = Index.resolveIndexArg(arg1, srcRowIndex, srcColumnIndex);
            return Index.getValueFromArea(reference, rowIx, columnIx, colArgWasPassed, srcRowIndex, srcColumnIndex);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
    }

    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        AreaEval reference = Index.convertFirstArg(arg0);
        boolean colArgWasPassed = true;
        try {
            int columnIx = Index.resolveIndexArg(arg2, srcRowIndex, srcColumnIndex);
            int rowIx = Index.resolveIndexArg(arg1, srcRowIndex, srcColumnIndex);
            return Index.getValueFromArea(reference, rowIx, columnIx, colArgWasPassed, srcRowIndex, srcColumnIndex);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
    }

    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2, ValueEval arg3) {
        throw new RuntimeException("Incomplete code - don't know how to support the 'area_num' parameter yet)");
    }

    private static AreaEval convertFirstArg(ValueEval arg0) {
        ValueEval firstArg = arg0;
        if (firstArg instanceof RefEval) {
            return ((RefEval)firstArg).offset(0, 0, 0, 0);
        }
        if (firstArg instanceof AreaEval) {
            return (AreaEval)firstArg;
        }
        throw new RuntimeException("Incomplete code - cannot handle first arg of type (" + firstArg.getClass().getName() + ")");
    }

    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        switch (args.length) {
            case 2: {
                return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1]);
            }
            case 3: {
                return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1], args[2]);
            }
            case 4: {
                return this.evaluate(srcRowIndex, srcColumnIndex, args[0], args[1], args[2], args[3]);
            }
        }
        return ErrorEval.VALUE_INVALID;
    }

    private static ValueEval getValueFromArea(AreaEval ae2, int pRowIx, int pColumnIx, boolean colArgWasPassed, int srcRowIx, int srcColIx) throws EvaluationException {
        int columnIx;
        int rowIx;
        boolean colArgWasEmpty;
        boolean rowArgWasEmpty = pRowIx == 0;
        boolean bl = colArgWasEmpty = pColumnIx == 0;
        if (ae2.isRow()) {
            if (ae2.isColumn()) {
                rowIx = rowArgWasEmpty ? 0 : pRowIx - 1;
                columnIx = colArgWasEmpty ? 0 : pColumnIx - 1;
            } else if (colArgWasPassed) {
                rowIx = rowArgWasEmpty ? 0 : pRowIx - 1;
                columnIx = pColumnIx - 1;
            } else {
                rowIx = 0;
                columnIx = pRowIx - 1;
                colArgWasEmpty = rowArgWasEmpty;
            }
        } else if (ae2.isColumn()) {
            rowIx = rowArgWasEmpty ? srcRowIx - ae2.getFirstRow() : pRowIx - 1;
            columnIx = colArgWasEmpty ? 0 : (colArgWasEmpty ? 0 : pColumnIx - 1);
        } else {
            if (!colArgWasPassed) {
                throw new EvaluationException(pRowIx < 0 ? ErrorEval.VALUE_INVALID : ErrorEval.REF_INVALID);
            }
            rowIx = rowArgWasEmpty ? srcRowIx - ae2.getFirstRow() : pRowIx - 1;
            columnIx = colArgWasEmpty ? srcColIx - ae2.getFirstColumn() : pColumnIx - 1;
        }
        int width = ae2.getWidth();
        int height = ae2.getHeight();
        if (!rowArgWasEmpty && rowIx >= height || !colArgWasEmpty && columnIx >= width) {
            throw new EvaluationException(ErrorEval.REF_INVALID);
        }
        if (rowIx < 0 || columnIx < 0 || rowIx >= height || columnIx >= width) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return ae2.getRelativeValue(rowIx, columnIx);
    }

    private static int resolveIndexArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ev = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        if (ev == MissingArgEval.instance) {
            return 0;
        }
        if (ev == BlankEval.instance) {
            return 0;
        }
        int result = OperandResolver.coerceValueToInt(ev);
        if (result < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return result;
    }
}

