/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.CFHeaderRecord;
import org.apache.poi.hssf.record.CFRuleRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.formula.AreaErrPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.ss.util.CellRangeAddress;

public final class CFRecordsAggregate
extends RecordAggregate {
    private static final int MAX_CONDTIONAL_FORMAT_RULES = 3;
    private final CFHeaderRecord header;
    private final List rules;

    private CFRecordsAggregate(CFHeaderRecord pHeader, CFRuleRecord[] pRules) {
        if (pHeader == null) {
            throw new IllegalArgumentException("header must not be null");
        }
        if (pRules == null) {
            throw new IllegalArgumentException("rules must not be null");
        }
        if (pRules.length > 3) {
            throw new IllegalArgumentException("No more than 3 rules may be specified");
        }
        if (pRules.length != pHeader.getNumberOfConditionalFormats()) {
            throw new RuntimeException("Mismatch number of rules");
        }
        this.header = pHeader;
        this.rules = new ArrayList(3);
        for (int i2 = 0; i2 < pRules.length; ++i2) {
            this.rules.add(pRules[i2]);
        }
    }

    public CFRecordsAggregate(CellRangeAddress[] regions, CFRuleRecord[] rules) {
        this(new CFHeaderRecord(regions, rules.length), rules);
    }

    public static CFRecordsAggregate createCFAggregate(RecordStream rs) {
        Record rec = rs.getNext();
        if (rec.getSid() != 432) {
            throw new IllegalStateException("next record sid was " + rec.getSid() + " instead of " + 432 + " as expected");
        }
        CFHeaderRecord header = (CFHeaderRecord)rec;
        int nRules = header.getNumberOfConditionalFormats();
        CFRuleRecord[] rules = new CFRuleRecord[nRules];
        for (int i2 = 0; i2 < rules.length; ++i2) {
            rules[i2] = (CFRuleRecord)rs.getNext();
        }
        return new CFRecordsAggregate(header, rules);
    }

    public CFRecordsAggregate cloneCFAggregate() {
        CFRuleRecord[] newRecs = new CFRuleRecord[this.rules.size()];
        for (int i2 = 0; i2 < newRecs.length; ++i2) {
            newRecs[i2] = (CFRuleRecord)this.getRule(i2).clone();
        }
        return new CFRecordsAggregate((CFHeaderRecord)this.header.clone(), newRecs);
    }

    public CFHeaderRecord getHeader() {
        return this.header;
    }

    private void checkRuleIndex(int idx) {
        if (idx < 0 || idx >= this.rules.size()) {
            throw new IllegalArgumentException("Bad rule record index (" + idx + ") nRules=" + this.rules.size());
        }
    }

    public CFRuleRecord getRule(int idx) {
        this.checkRuleIndex(idx);
        return (CFRuleRecord)this.rules.get(idx);
    }

    public void setRule(int idx, CFRuleRecord r2) {
        if (r2 == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        this.checkRuleIndex(idx);
        this.rules.set(idx, r2);
    }

    public void addRule(CFRuleRecord r2) {
        if (r2 == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        if (this.rules.size() >= 3) {
            throw new IllegalStateException("Cannot have more than 3 conditional format rules");
        }
        this.rules.add(r2);
        this.header.setNumberOfConditionalFormats(this.rules.size());
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CF]\n");
        if (this.header != null) {
            buffer.append(this.header.toString());
        }
        for (int i2 = 0; i2 < this.rules.size(); ++i2) {
            CFRuleRecord cfRule = (CFRuleRecord)this.rules.get(i2);
            buffer.append(cfRule.toString());
        }
        buffer.append("[/CF]\n");
        return buffer.toString();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        rv.visitRecord(this.header);
        for (int i2 = 0; i2 < this.rules.size(); ++i2) {
            CFRuleRecord rule = (CFRuleRecord)this.rules.get(i2);
            rv.visitRecord(rule);
        }
    }

    public boolean updateFormulasAfterCellShift(FormulaShifter shifter, int currentExternSheetIx) {
        int i2;
        CellRangeAddress[] cellRanges = this.header.getCellRanges();
        boolean changed = false;
        ArrayList<CellRangeAddress> temp = new ArrayList<CellRangeAddress>();
        for (i2 = 0; i2 < cellRanges.length; ++i2) {
            CellRangeAddress craOld = cellRanges[i2];
            CellRangeAddress craNew = CFRecordsAggregate.shiftRange(shifter, craOld, currentExternSheetIx);
            if (craNew == null) {
                changed = true;
                continue;
            }
            temp.add(craNew);
            if (craNew == craOld) continue;
            changed = true;
        }
        if (changed) {
            int nRanges = temp.size();
            if (nRanges == 0) {
                return false;
            }
            CellRangeAddress[] newRanges = new CellRangeAddress[nRanges];
            temp.toArray(newRanges);
            this.header.setCellRanges(newRanges);
        }
        for (i2 = 0; i2 < this.rules.size(); ++i2) {
            CFRuleRecord rule = (CFRuleRecord)this.rules.get(i2);
            Ptg[] ptgs = rule.getParsedExpression1();
            if (ptgs != null && shifter.adjustFormula(ptgs, currentExternSheetIx)) {
                rule.setParsedExpression1(ptgs);
            }
            if ((ptgs = rule.getParsedExpression2()) == null || !shifter.adjustFormula(ptgs, currentExternSheetIx)) continue;
            rule.setParsedExpression2(ptgs);
        }
        return true;
    }

    private static CellRangeAddress shiftRange(FormulaShifter shifter, CellRangeAddress cra, int currentExternSheetIx) {
        AreaPtg aptg = new AreaPtg(cra.getFirstRow(), cra.getLastRow(), cra.getFirstColumn(), cra.getLastColumn(), false, false, false, false);
        Ptg[] ptgs = new Ptg[]{aptg};
        if (!shifter.adjustFormula(ptgs, currentExternSheetIx)) {
            return cra;
        }
        Ptg ptg0 = ptgs[0];
        if (ptg0 instanceof AreaPtg) {
            AreaPtg bptg = (AreaPtg)ptg0;
            return new CellRangeAddress(bptg.getFirstRow(), bptg.getLastRow(), bptg.getFirstColumn(), bptg.getLastColumn());
        }
        if (ptg0 instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg0.getClass().getName() + ")");
    }
}

