/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class SupBookRecord
extends StandardRecord {
    public static final short sid = 430;
    private static final short SMALL_RECORD_SIZE = 4;
    private static final short TAG_INTERNAL_REFERENCES = 1025;
    private static final short TAG_ADD_IN_FUNCTIONS = 14849;
    private short field_1_number_of_sheets;
    private String field_2_encoded_url;
    private String[] field_3_sheet_names;
    private boolean _isAddInFunctions;

    public static SupBookRecord createInternalReferences(short numberOfSheets) {
        return new SupBookRecord(false, numberOfSheets);
    }

    public static SupBookRecord createAddInFunctions() {
        return new SupBookRecord(true, 0);
    }

    public static SupBookRecord createExternalReferences(String url, String[] sheetNames) {
        return new SupBookRecord(url, sheetNames);
    }

    private SupBookRecord(boolean isAddInFuncs, short numberOfSheets) {
        this.field_1_number_of_sheets = numberOfSheets;
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        this._isAddInFunctions = isAddInFuncs;
    }

    public SupBookRecord(String url, String[] sheetNames) {
        this.field_1_number_of_sheets = (short)sheetNames.length;
        this.field_2_encoded_url = url;
        this.field_3_sheet_names = sheetNames;
        this._isAddInFunctions = false;
    }

    public boolean isExternalReferences() {
        return this.field_3_sheet_names != null;
    }

    public boolean isInternalReferences() {
        return this.field_3_sheet_names == null && !this._isAddInFunctions;
    }

    public boolean isAddInFunctions() {
        return this.field_3_sheet_names == null && this._isAddInFunctions;
    }

    public SupBookRecord(RecordInputStream in) {
        int recLen = in.remaining();
        this.field_1_number_of_sheets = in.readShort();
        if (recLen > 4) {
            this._isAddInFunctions = false;
            this.field_2_encoded_url = in.readString();
            String[] sheetNames = new String[this.field_1_number_of_sheets];
            for (int i2 = 0; i2 < sheetNames.length; ++i2) {
                sheetNames[i2] = in.readString();
            }
            this.field_3_sheet_names = sheetNames;
            return;
        }
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        short nextShort = in.readShort();
        if (nextShort == 1025) {
            this._isAddInFunctions = false;
        } else if (nextShort == 14849) {
            this._isAddInFunctions = true;
            if (this.field_1_number_of_sheets != 1) {
                throw new RuntimeException("Expected 0x0001 for number of sheets field in 'Add-In Functions' but got (" + this.field_1_number_of_sheets + ")");
            }
        } else {
            throw new RuntimeException("invalid EXTERNALBOOK code (" + Integer.toHexString(nextShort) + ")");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [SUPBOOK ");
        if (this.isExternalReferences()) {
            sb.append("External References");
            sb.append(" nSheets=").append(this.field_1_number_of_sheets);
            sb.append(" url=").append(this.field_2_encoded_url);
        } else if (this._isAddInFunctions) {
            sb.append("Add-In Functions");
        } else {
            sb.append("Internal References ");
            sb.append(" nSheets= ").append(this.field_1_number_of_sheets);
        }
        sb.append("]");
        return sb.toString();
    }

    protected int getDataSize() {
        if (!this.isExternalReferences()) {
            return 4;
        }
        int sum = 2;
        sum += StringUtil.getEncodedSize(this.field_2_encoded_url);
        for (int i2 = 0; i2 < this.field_3_sheet_names.length; ++i2) {
            sum += StringUtil.getEncodedSize(this.field_3_sheet_names[i2]);
        }
        return sum;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_number_of_sheets);
        if (this.isExternalReferences()) {
            StringUtil.writeUnicodeString(out, this.field_2_encoded_url);
            for (int i2 = 0; i2 < this.field_3_sheet_names.length; ++i2) {
                StringUtil.writeUnicodeString(out, this.field_3_sheet_names[i2]);
            }
        } else {
            int field2val = this._isAddInFunctions ? 14849 : 1025;
            out.writeShort(field2val);
        }
    }

    public void setNumberOfSheets(short number) {
        this.field_1_number_of_sheets = number;
    }

    public short getNumberOfSheets() {
        return this.field_1_number_of_sheets;
    }

    public short getSid() {
        return 430;
    }

    public String getURL() {
        String encodedUrl = this.field_2_encoded_url;
        switch (encodedUrl.charAt(0)) {
            case '\u0000': {
                return encodedUrl.substring(1);
            }
            case '\u0001': {
                return SupBookRecord.decodeFileName(encodedUrl);
            }
            case '\u0002': {
                return encodedUrl.substring(1);
            }
        }
        return encodedUrl;
    }

    private static String decodeFileName(String encodedUrl) {
        return encodedUrl.substring(1);
    }

    public String[] getSheetNames() {
        return (String[])this.field_3_sheet_names.clone();
    }
}

